/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.js.event;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenMyFamilyJsEvent
implements JsEvent {
    private static final String TAG = "OpenMyFamilyJsEvent";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BBS.openMyFamily;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param2, final @Nullable IJsEventCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)param2)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback2 != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback2.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenMyFamilyJsEvent.this.openProfile(param2, callback2);
            }
        });
    }

    private void openProfile(@NonNull String paramJson, final @Nullable IJsEventCallback callback2) {
        block5: {
            try {
                JSONObject jo = JsonParser.obtainJSONObject((String)paramJson);
                final String gid = jo.optString("gid");
                if (TextUtils.isEmpty((CharSequence)gid)) {
                    if (callback2 != null) {
                        BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                        callback2.callJs((IJsParam)err);
                    }
                } else {
                    ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(gid).getDataService().fetchChannelDetailInfo(new IDataService.IGetDetailInfoCallBack(){

                        public void onSuccess(String channelId, final ChannelDetailInfo info) {
                            MLog.info((Object)OpenMyFamilyJsEvent.TAG, (String)("getChannelDetailInfo: " + info.toString()), (Object[])new Object[0]);
                            ((IChannelCenterService)ServiceManagerProxy.getServiceManager().getService(IChannelCenterService.class)).getChannel(gid).getRoleService().getMyRole(new IRoleService.IGetRoleCallBack(){

                                public void onSuccess(String channelId, int roleType) {
                                    Message message = Message.obtain();
                                    message.what = AppbaseMsgDef.ChannelMsgDef.OPEN_WINDOW_VIEW_MY_FAMILY;
                                    message.obj = info;
                                    message.arg1 = roleType;
                                    message.arg2 = 1;
                                    MsgDispatcher.getInstance().sendMessage(message);
                                    if (callback2 != null) {
                                        BaseJsParam re = BaseJsParam.codeParam((int)1, (String)"go to profile success");
                                        callback2.callJs((IJsParam)re);
                                    }
                                }

                                public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                                    MLog.error((Object)OpenMyFamilyJsEvent.TAG, (String)("getRoleService error : " + errorCode + ", msg: " + errorTips + ", channelId: " + channelId), (Object[])new Object[0]);
                                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.get_my_family_failed);
                                }
                            });
                        }

                        public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                            MLog.error((Object)OpenMyFamilyJsEvent.TAG, (String)("getChannelDetailInfo error : " + errorCode + ", msg: " + errorTips + ", channelId: " + channelId), (Object[])new Object[0]);
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.get_my_family_failed);
                        }
                    });
                }
            }
            catch (JSONException e) {
                if (callback2 == null) break block5;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
                callback2.callJs((IJsParam)err);
            }
        }
    }
}

