/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.history.mvp;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.data.VoiceRoomHistoryDbBean;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.channel.module.history.bean.VoiceRoomHistoryDateBean;
import com.yy.hiyo.channel.module.history.mvp.VoiceRoomHistoryMvp;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.channel.srv.mgr.GetHistoryChannelReq;
import net.ihago.channel.srv.mgr.GetHistoryChannelRes;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class VoiceRoomHistoryModel
implements VoiceRoomHistoryMvp.IModel {
    private static final String TAG = "VoiceRoomHistoryModel";
    private IServiceManager mServiceManager;
    private Map<String, Long> mDbRoomsMap;

    public VoiceRoomHistoryModel(IServiceManager iServiceManager) {
        this.mServiceManager = iServiceManager;
        this.mDbRoomsMap = new ConcurrentHashMap<String, Long>();
    }

    @Override
    public void getHistoryRoom(final VoiceRoomHistoryMvp.IModel.CallBack<List<Object>, Boolean> callBack, final List<Integer> filterList) {
        FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryModelgetHistoryRoomDbDataStart", (Object[])new Object[0]);
        this.getLocalVoiceRoomHistory(new VoiceRoomHistoryMvp.IModel.DBCallBack<List<String>>(){

            @Override
            public void onResult(List<String> data2) {
                if (data2.size() > 0) {
                    VoiceRoomHistoryModel.this.getHistoryRoomInner(callBack, data2, filterList);
                } else {
                    callBack.requestResult(true);
                }
            }
        });
    }

    @Override
    public void getHistoryRoom(DataCallback<List<Object>> callback2) {
        this.getLocalVoiceRoomHistory(data2 -> {
            MLog.debug((Object)TAG, (String)"getHistoryRoom list: %s", (Object[])new Object[]{data2});
            if (data2.size() > 0) {
                this.requestChannelHistory(callback2, (List<String>)data2);
            } else {
                callback2.onResult(Collections.emptyList());
            }
        });
    }

    @Override
    public void getHistoryRoomInner(VoiceRoomHistoryMvp.IModel.CallBack<List<Object>, Boolean> callBack, List<String> roomIds, List<Integer> filterList) {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            callBack.requestResult(false);
            return;
        }
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModelgetHistoryRoomServerDataRequestStart" + roomIds.size()), (Object[])new Object[0]);
        this.requestChannelHistory(callBack, roomIds, filterList);
    }

    private void requestChannelHistory(final DataCallback<List<Object>> callback2, List<String> roomIds) {
        GetHistoryChannelReq getHistoryChannelReq = new GetHistoryChannelReq.Builder().cids(roomIds).ret_top_onlines(Boolean.valueOf(true)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getHistoryChannelReq, (IProtoCallback)new SimpleProtoCallback<GetHistoryChannelRes>("requestChannelHistory"){

            public void onResponse(@NonNull GetHistoryChannelRes res, long code, String msgTip) {
                super.onResponse((AndroidMessage)res, code, msgTip);
                MLog.debug((Object)VoiceRoomHistoryModel.TAG, (String)"requestChannelHistory response code: %s", (Object[])new Object[]{code});
                if (ProtoManager.isSuccessCode((long)code)) {
                    List historyChannelList = res.history_channels;
                    List<Object> totalList = VoiceRoomHistoryModel.this.addChannelDate(historyChannelList);
                    callback2.onResult(totalList);
                } else {
                    callback2.onResult(Collections.emptyList());
                }
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                MLog.error((Object)VoiceRoomHistoryModel.TAG, (String)"requestChannelHistory error code: %s", (Object[])new Object[]{code});
                callback2.onResult(Collections.emptyList());
            }
        });
    }

    private void requestChannelHistory(final VoiceRoomHistoryMvp.IModel.CallBack<List<Object>, Boolean> callBack, List<String> roomIds, final List<Integer> filterList) {
        final long startTime = SystemClock.uptimeMillis();
        GetHistoryChannelReq getHistoryChannelReq = new GetHistoryChannelReq.Builder().cids(roomIds).ret_top_onlines(Boolean.valueOf(true)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)getHistoryChannelReq, (IProtoCallback)new SimpleProtoCallback<GetHistoryChannelRes>(){

            public void onResponse(@Nullable GetHistoryChannelRes message) {
                super.onResponse((AndroidMessage)message);
                BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)0L);
                VoiceRoomHistoryModel.this.handleSuccess(message, callBack, filterList);
            }

            public void onResponse(@NonNull GetHistoryChannelRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)code);
                    VoiceRoomHistoryModel.this.handleSuccess(message, callBack, filterList);
                } else {
                    BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.requestResult(false);
                    }
                });
                return super.retryWhenTimeout(canRetry);
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                BaseRequestManager.statMetric((String)"channel/gethistory", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.requestResult(false);
                    }
                });
                return super.retryWhenError(canRetry, reason, code);
            }
        });
    }

    private void handleSuccess(GetHistoryChannelRes message, VoiceRoomHistoryMvp.IModel.CallBack<List<Object>, Boolean> callBack, List<Integer> filterList) {
        ArrayList<HistoryChannel> mHisRooms;
        if (message != null && (mHisRooms = new ArrayList<HistoryChannel>(message.history_channels)).size() > 0) {
            FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModel getHistoryRoomServerDataRequestResult" + mHisRooms.size()), (Object[])new Object[0]);
            if (filterList != null && !filterList.isEmpty()) {
                ListIterator listIterator = mHisRooms.listIterator();
                while (listIterator.hasNext()) {
                    HistoryChannel hChannel = (HistoryChannel)listIterator.next();
                    if (hChannel.plugin_info == null || !filterList.contains(hChannel.plugin_info.type)) continue;
                    listIterator.remove();
                }
            }
            List<Object> totalDatas = !mHisRooms.isEmpty() ? this.addChannelDate(mHisRooms) : new ArrayList<Object>();
            FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModel getHistoryRoomServerDataRequestResult" + totalDatas.size()), (Object[])new Object[0]);
            if (totalDatas.size() > 0) {
                callBack.onResponse(totalDatas);
            }
        }
        callBack.requestResult(true);
    }

    @Override
    public void updateLocalVoiceRoomHistory(String roomId) {
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModelupdateLocalVoiceRoomHistory " + roomId), (Object[])new Object[0]);
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            VoiceRoomHistoryDbBean bean2 = new VoiceRoomHistoryDbBean(roomId, System.currentTimeMillis());
            box.updateItem((BaseDBBean)bean2, true);
        }
    }

    @Override
    public void deleteLocalVoiceRoomHistory(String roomId) {
        FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModeldeleteLocalVoiceRoomHistory " + roomId), (Object[])new Object[0]);
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            VoiceRoomHistoryDbBean bean2 = new VoiceRoomHistoryDbBean(roomId, System.currentTimeMillis());
            box.deleteItem((BaseDBBean)bean2);
        }
    }

    @Override
    public void getLocalVoiceRoomHistory(final VoiceRoomHistoryMvp.IModel.DBCallBack<List<String>> callBack) {
        final ArrayList roomIds = new ArrayList();
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null == box) {
            callBack.onResult(roomIds);
            return;
        }
        box.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<VoiceRoomHistoryDbBean>(){

            public void onLoaded(ArrayList<VoiceRoomHistoryDbBean> datas) {
                Collections.sort(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModelgetHistoryRoomDbDataResult" + datas.size()), (Object[])new Object[0]);
                ArrayList data1 = VoiceRoomHistoryModel.this.handeMax(datas);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModelgetHistoryRoomDbDataResultMax" + data1.size()), (Object[])new Object[0]);
                ArrayList data2 = VoiceRoomHistoryModel.this.handleServenData(data1);
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryModelgetHistoryRoomDbDataSeven" + data2.size()), (Object[])new Object[0]);
                if (data2.size() > 0) {
                    for (int i = 0; i < data2.size(); ++i) {
                        VoiceRoomHistoryDbBean bean2 = (VoiceRoomHistoryDbBean)data2.get(i);
                        String roomId = bean2.getRoomId();
                        roomIds.add(roomId);
                        VoiceRoomHistoryModel.this.mDbRoomsMap.put(roomId, bean2.getTimestamp());
                    }
                }
                callBack.onResult(roomIds);
            }
        });
    }

    @Override
    public void deleteLocalVoiceRoomHistory() {
        MyBox box = ((IDBService)this.mServiceManager.getService(IDBService.class)).boxForCurUser(VoiceRoomHistoryDbBean.class);
        if (null != box) {
            box.deleteAll();
        }
    }

    @Override
    public void clearData() {
        this.mDbRoomsMap.clear();
    }

    @Override
    public List<Object> addChannelDate(List<HistoryChannel> data1) {
        ArrayList<Object> data2 = new ArrayList<Object>();
        String roomId = data1.get((int)0).cid;
        long time = this.mDbRoomsMap.get(roomId);
        data2.add(this.getDateBean(time));
        Date currentDate = new Date(time);
        for (int i = 0; i < data1.size(); ++i) {
            HistoryChannel item = data1.get(i);
            long itemTime = this.mDbRoomsMap.get(item.cid);
            if (this.isSameDay(currentDate, new Date(itemTime))) {
                data2.add(item);
                continue;
            }
            VoiceRoomHistoryDateBean dateBean = this.getDateBean(itemTime);
            data2.add(dateBean);
            data2.add(item);
            currentDate = new Date(itemTime);
        }
        VoiceRoomHistoryDateBean dateBean = new VoiceRoomHistoryDateBean();
        data2.add(dateBean);
        return data2;
    }

    private boolean isSameDay(Date one, Date two) {
        SimpleDateFormat simpleDateFormat;
        if (one == null && two == null) {
            return true;
        }
        return one != null && two != null && (simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd")).format(one).equals(simpleDateFormat.format(two));
    }

    private VoiceRoomHistoryDateBean getDateBean(long time) {
        String strDate = "";
        strDate = DateUtils.isToday((Calendar)Calendar.getInstance(), (long)time) ? ResourceUtils.getString((int)R.string.short_summary_today) : (this.isYesterday(Calendar.getInstance(), time) ? ResourceUtils.getString((int)R.string.short_summary_yestoday) : (DateUtils.isThisYear((Calendar)Calendar.getInstance(), (long)time) ? this.timeStampToDate(time, "dd/MM") : this.timeStampToDate(time, "dd-MM-yyyy")));
        VoiceRoomHistoryDateBean showBean = new VoiceRoomHistoryDateBean();
        showBean.setDate(strDate);
        return showBean;
    }

    private boolean isYesterday(Calendar cal, long timestamp) {
        Calendar c = cal;
        this.clearCalendar(c, 11, 12, 13, 14);
        c.add(5, -1);
        long firstOfDay = c.getTimeInMillis();
        c.setTimeInMillis(timestamp);
        this.clearCalendar(c, 11, 12, 13, 14);
        return firstOfDay == c.getTimeInMillis();
    }

    private void clearCalendar(Calendar c, int ... fields) {
        for (int f : fields) {
            c.set(f, 0);
        }
    }

    public String timeStampToDate(long time, String format) {
        if (format == null || format.isEmpty()) {
            format = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    private ArrayList<VoiceRoomHistoryDbBean> handeMax(ArrayList<VoiceRoomHistoryDbBean> datas) {
        if (datas.size() > 100) {
            ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
            for (int i = 0; i < 100; ++i) {
                VoiceRoomHistoryDbBean dbBean = datas.get(i);
                newDatas.add(dbBean);
            }
            return newDatas;
        }
        return datas;
    }

    private ArrayList<VoiceRoomHistoryDbBean> handleServenData(ArrayList<VoiceRoomHistoryDbBean> datas) {
        ArrayList<VoiceRoomHistoryDbBean> newDatas = new ArrayList<VoiceRoomHistoryDbBean>();
        for (int i = 0; i < datas.size(); ++i) {
            VoiceRoomHistoryDbBean bean2 = datas.get(i);
            boolean isSeven = this.isSevenInner(bean2.getTimestamp());
            if (!isSeven) continue;
            newDatas.add(bean2);
        }
        return newDatas;
    }

    private boolean isSevenInner(long time) {
        long current = System.currentTimeMillis();
        int sub = (int)((current - time) / 86400000L);
        return sub < 7;
    }
}

