/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.history.holder;

import android.view.View;
import android.widget.ImageView;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.ui.widget.image.RoundImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.utils.ChannelCoverUtils;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class ChannelHistoryHolder
extends BaseItemBinder.ViewHolder<HistoryChannel> {
    private CircleImageView mRoomCircleHead;
    private RoundImageView mRoomRoundHead;
    private YYTextView mRoomName;
    private YYTextView mRoomOwner;
    private YYTextView mPeopleCount;
    private YYTextView mOldChannel;
    private YYView mOnlineState;

    public ChannelHistoryHolder(View itemView) {
        super(itemView);
        this.mRoomCircleHead = (CircleImageView)itemView.findViewById(R.id.iv_room_head);
        this.mRoomRoundHead = (RoundImageView)itemView.findViewById(R.id.iv_room_round_head);
        this.mRoomName = (YYTextView)itemView.findViewById(R.id.tv_room_name);
        this.mRoomOwner = (YYTextView)itemView.findViewById(R.id.tv_room_owner);
        this.mPeopleCount = (YYTextView)itemView.findViewById(R.id.tv_people_count);
        this.mOldChannel = (YYTextView)itemView.findViewById(R.id.oldChannelTv);
        this.mOnlineState = (YYView)itemView.findViewById(R.id.online_state);
    }

    public void setData(HistoryChannel data2) {
        super.setData((Object)data2);
        String strName = data2.name;
        String strOwner = data2.nick;
        this.mPeopleCount.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mRoomName.setText((CharSequence)strName);
        this.mRoomOwner.setText((CharSequence)ResourceUtils.getString((int)R.string.title_history_channel_host_name, (Object[])new Object[]{strOwner}));
        if (!data2.plugin_info.__isDefaultInstance() && data2.plugin_info.type > 1) {
            String loadUrl = data2.url + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)48.0f), (int)ResolutionUtils.dip2Px((float)48.0f), (boolean)true);
            this.mRoomCircleHead.setVisibility(0);
            this.mRoomRoundHead.setVisibility(4);
            ImageLoader.loadImage((ImageView)this.mRoomCircleHead, (String)loadUrl, (int)R.drawable.icon_avatar_default_female);
            this.mPeopleCount.setText((CharSequence)String.valueOf(data2.onlines));
        } else {
            this.mRoomCircleHead.setVisibility(4);
            this.mRoomRoundHead.setVisibility(0);
            ChannelCoverUtils.INSTANCE.showChannelCover(data2.version.intValue(), data2.avatar, data2.url, (RecycleImageView)this.mRoomRoundHead);
            this.mPeopleCount.setText((CharSequence)String.valueOf(data2.top_onlines));
        }
        if (data2.version == 1) {
            this.mOldChannel.setVisibility(8);
        } else {
            this.mOldChannel.setVisibility(0);
        }
        if (data2.owner_online.booleanValue()) {
            this.mOnlineState.setVisibility(0);
        } else {
            this.mOnlineState.setVisibility(8);
        }
    }
}

