/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.history;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.module.history.IVoiceRoomHistoryPage;
import com.yy.hiyo.channel.module.history.bean.TempRoomHistory;
import com.yy.hiyo.channel.module.history.bean.VoiceRoomHistoryDateBean;
import com.yy.hiyo.channel.module.history.holder.ChannelHistoryHolder;
import com.yy.hiyo.channel.module.history.holder.VoiceRoomHistoryDateHolder;
import com.yy.hiyo.channel.module.history.mvp.VoiceRoomHistoryMvp;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.voice.base.mediav1.service.IMediaRoomService;
import java.util.ArrayList;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.channel.srv.mgr.HistoryChannel;

public class VoiceRoomHistoryPage
extends YYLinearLayout
implements ICustomView,
IVoiceRoomHistoryPage,
VoiceRoomHistoryMvp.IView {
    private VoiceRoomHistoryMvp.IPresenter mPresenter;
    private RecyclerView mRecyclerView;
    private MultiTypeAdapter mAdapter;
    private CommonStatusLayout mStatusLayout;
    private SimpleTitleBar titleBar;
    private boolean isAnimationEnd;
    private TempRoomHistory mTempRoomHistory;
    private static final String TAG = "VoiceRoomHistoryPage";

    public TempRoomHistory getTempRoomHistory() {
        if (this.mTempRoomHistory == null) {
            this.mTempRoomHistory = new TempRoomHistory();
        }
        return this.mTempRoomHistory;
    }

    public VoiceRoomHistoryPage(Context context, boolean animated) {
        super(context);
        this.isAnimationEnd = !animated;
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        VoiceRoomHistoryPage.inflate((Context)this.getContext(), (int)this.getLayoutId(), (ViewGroup)this);
        this.setOrientation(1);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.initView();
    }

    private void initView() {
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_voice_room_history);
        this.mAdapter = new MultiTypeAdapter();
        this.titleBar = (SimpleTitleBar)this.findViewById(R.id.voice_room_list_title);
        this.titleBar.setLeftTitle(ResourceUtils.getString((int)R.string.title_voice_room_history_title));
        this.titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                VoiceRoomHistoryPage.this.mPresenter.exitVoiceHistoryRoom();
                RoomTrack.INSTANCE.onVoiceRoomHistoryListBacklick();
            }
        });
        this.titleBar.setRightBtn(R.drawable.icon_delete_voice_room_history, new View.OnClickListener(){

            public void onClick(View v) {
                VoiceRoomHistoryPage.this.deleteHistoryClick();
            }
        });
        this.titleBar.getRightView().setVisibility(0);
        this.mAdapter.register(HistoryChannel.class, (ItemViewBinder)new BaseItemBinder<HistoryChannel, ChannelHistoryHolder>(){

            @NonNull
            protected ChannelHistoryHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new ChannelHistoryHolder(this.createItemView(inflater, parent, R.layout.layout_voice_room_history_item_channel));
            }

            public void onBindViewHolder(@NonNull ChannelHistoryHolder holder, final @NonNull HistoryChannel channel) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (!RepeatClickUtils.canRepeatClick((String)"onRoomClick", (long)700L)) {
                            return;
                        }
                        VoiceRoomHistoryPage.this.mPresenter.onItemClick(channel.cid, channel);
                    }
                });
                super.onBindViewHolder((BaseItemBinder.ViewHolder)holder, (Object)channel);
            }
        });
        this.mAdapter.register(VoiceRoomHistoryDateBean.class, (ItemViewBinder)new BaseItemBinder<VoiceRoomHistoryDateBean, VoiceRoomHistoryDateHolder>(){

            @NonNull
            protected VoiceRoomHistoryDateHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                return new VoiceRoomHistoryDateHolder(this.createItemView(inflater, parent, R.layout.layout_voice_room_history_date_item_channel));
            }
        });
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(1);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    public void setPresenter(VoiceRoomHistoryMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        this.setObserver();
    }

    public void onCompletedEntryAnimation() {
        FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPage onCompletedEntryAnimation", (Object[])new Object[0]);
        this.isAnimationEnd = true;
        if (this.mTempRoomHistory == null) {
            return;
        }
        if (this.mTempRoomHistory.getHisRoomItems() != null) {
            this.setVoiceRoomHistory(this.mTempRoomHistory.getHisRoomItems());
        }
        if (this.mTempRoomHistory.getResult() != null) {
            this.updateRequestResult(this.mTempRoomHistory.getResult());
        }
        this.mTempRoomHistory.clear();
    }

    private void setObserver() {
        this.mPresenter.getVoiceRoomHistory().observe((LifecycleOwner)this.mPresenter.getMvpContext().getLifecycleOwner(), (Observer)new Observer<List<Object>>(){

            public void onChanged(@Nullable List<Object> hisRoomItems) {
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPage HistoryListResult" + hisRoomItems.size()), (Object[])new Object[0]);
                if (VoiceRoomHistoryPage.this.isAnimationEnd) {
                    VoiceRoomHistoryPage.this.setVoiceRoomHistory(hisRoomItems);
                } else {
                    VoiceRoomHistoryPage.this.getTempRoomHistory().setHisRoomItems(hisRoomItems);
                }
            }
        });
        this.mPresenter.getRequestResult().observe((LifecycleOwner)this.mPresenter.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Boolean>(){

            public void onChanged(@Nullable Boolean result) {
                FeatureLog.i((String)"FTVoiceRoom", (String)("VoiceRoomHistoryPage RequestResult" + result), (Object[])new Object[0]);
                if (VoiceRoomHistoryPage.this.isAnimationEnd) {
                    VoiceRoomHistoryPage.this.updateRequestResult(result);
                } else {
                    VoiceRoomHistoryPage.this.getTempRoomHistory().setResult(result);
                }
            }
        });
    }

    private void updateRequestResult(Boolean result) {
        this.hideLoading();
        if (this.mAdapter != null && this.mAdapter.getItemCount() == 0) {
            if (result != null) {
                if (result.booleanValue()) {
                    this.mStatusLayout.showNoData();
                } else {
                    this.mStatusLayout.showNetworkError();
                }
            }
            FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPagedelete visibility gone", (Object[])new Object[0]);
            this.setRightDeleteVisibility(false);
        } else {
            this.mStatusLayout.hideAllStatus();
            FeatureLog.i((String)"FTVoiceRoom", (String)"VoiceRoomHistoryPagedelete visibility true", (Object[])new Object[0]);
            this.setRightDeleteVisibility(true);
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.layout_voice_room_history_channel;
    }

    @Override
    public void setVoiceRoomHistory(List<Object> datas) {
        this.mAdapter.setItems(datas);
        this.mAdapter.notifyDataSetChanged();
        ArrayList<String> cid = new ArrayList<String>();
        if (!FP.empty(datas)) {
            for (Object object : datas) {
                if (!(object instanceof HistoryChannel) || !StringUtils.isNotEmpty((String)((HistoryChannel)object).cid)) continue;
                cid.add(((HistoryChannel)object).cid);
            }
            ((IMediaRoomService)ServiceManagerProxy.getService(IMediaRoomService.class)).preloadRoomMiddleInfos(cid);
        }
    }

    @Override
    public void showLoading() {
        this.mStatusLayout.showLoading();
    }

    @Override
    public void hideLoading() {
        this.mStatusLayout.hideLoading();
    }

    @Override
    public void deleteHistoryClick() {
        this.mPresenter.showDeleteDialog();
    }

    @Override
    public void setRightDeleteVisibility(boolean isShow) {
        if (isShow) {
            this.titleBar.getRightView().setVisibility(0);
        } else {
            this.titleBar.getRightView().setVisibility(8);
        }
    }
}

