/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow.list.reminderlist.ui;

import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.yy.appbase.data.PageData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.bean.ReminderDetails;
import com.yy.hiyo.channel.base.hiido.FollowStatisHelper;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListMvp;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ReminderListPresenter;
import com.yy.hiyo.channel.module.follow.list.reminderlist.ui.ReminderViewHolder;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.widget.BaseListEmptyView;
import com.yy.hiyo.relation.base.widget.BaseListWindow;
import me.drakeet.multitype.ItemViewBinder;

public class ReminderListWindow
extends BaseListWindow
implements ReminderListMvp.IView {
    private ReminderListMvp.IPresenter mReminderListPresenter;

    public ReminderListWindow(IMvpContext mvpContext, UICallBacks callBacks) {
        super(mvpContext, callBacks, "ReminderListWindow");
        this.mReminderListPresenter = new ReminderListPresenter(mvpContext, this);
        this.initDataObserve();
    }

    protected void onInitData() {
        this.mReminderListPresenter.onReminderListRefresh();
    }

    protected void onRegisterViewHolder() {
        super.onRegisterViewHolder();
        this.mAdapter.register(ReminderDetails.class, (ItemViewBinder)ReminderViewHolder.getItemBinder(new ReminderViewHolder.OnItemClickListener(){

            @Override
            public void onItemClicked(ReminderDetails reminderDetails) {
                if (reminderDetails == null || reminderDetails.getNoticeUserInfo() == null) {
                    return;
                }
                EnterParam param2 = EnterParam.of((String)reminderDetails.getNoticeUserInfo().channel_id).entry(11).putExtra("follow_uid", (Object)("" + reminderDetails.getNoticeUserInfo().uid)).build();
                param2.enterUid = reminderDetails.getNoticeUserInfo().uid;
                param2.entryInfo = new EntryInfo(FirstEntType.FOLLOWING, "", "");
                param2.setExtra("pluginType", (Object)reminderDetails.getNoticeUserInfo().plugin_type);
                param2.setExtra("live_cover_url", (Object)reminderDetails.getNoticeUserInfo().avatar);
                ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param2);
                FollowStatisHelper.reportReminderListClick();
            }
        }));
    }

    private void initDataObserve() {
        this.mReminderListPresenter.listTotal().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                ReminderListWindow.this.setListCount(integer);
            }
        });
        this.mReminderListPresenter.nextPage().observe((LifecycleOwner)this.getMvpContext().getLifecycleOwner(), (Observer)new Observer<PageData<ReminderDetails>>(){

            public void onChanged(@Nullable PageData<ReminderDetails> pageData) {
                ReminderListWindow.this.setPageData(pageData);
            }
        });
    }

    public void onShown() {
        super.onShown();
        FollowStatisHelper.reportReminderListShow();
    }

    protected void onListRefresh() {
        this.mReminderListPresenter.onReminderListRefresh();
    }

    protected void onListLoadmore() {
        this.mReminderListPresenter.onReminderListLoadmore();
    }

    protected void onInitEmpty(BaseListEmptyView emptyView2) {
        emptyView2.setInfo(R.drawable.img_list_empty, "", "");
    }

    @Override
    public void clearStatus() {
        this.clearListStatus();
    }
}

