/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.follow;

import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.roomfloat.FloatMsgInfo;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.VoiceRoomFollowConfig;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.TimeUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.module.follow.bean.FloatMsgFollowInfo;
import com.yy.hiyo.channel.plugins.radio.RadioNAB;
import com.yy.hiyo.channel.plugins.voiceroom.plugin.common.followbubble.SeatFollowPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.channel.service.growth.PathTimeAdjustExperiment;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class FollowPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private static final String TAG = "FollowPresenter";
    private static final String FOLLOW_TIMES = "follow_times";
    private static final String LAST_FOLLOW_MILLS = "last_follow_time_millis";
    private int mFollowDuration = 180000;
    private int mNewRegisterFollowDuration = 50000;
    private int mFollowFloatDuration = 120000;
    private int mNewRegisterFollowFloatDuration = 90000;
    private int mFloatFollowShowDuration = 10000;
    private int mFollowCount = 3;
    protected long mRoomOwnerId = 0L;
    private int mFollowGuideTimes = 3;
    private int mNewRegisterFollowGuideTimes = 3;
    private long mCurrentFloatTimes = -1L;
    private long mFollowNum = 6L;
    private long videoStartTime = 0L;
    private int followLeavePeople = 1;
    private long followLeaveStayTime = 120000L;
    private int followLeaveShowTime = 1;
    private static final int ThREE_MiNIS = 180000;
    protected static final String SHOWED_FOLLOW_TIMES = "showed_follow_times";
    private static final String LAST_COMMON_FOLLOW_MILLS = "last_common_follow_mills";
    private int mFollowTime = 180000;
    private int mFollowFloatSecond = 120;
    private int floatingTime = 10;
    protected int followGuideTimes = 3;
    protected long times = 0L;
    private List<Integer> mFollowPluginModes;
    private IAB mUITest;
    Runnable mFloatFollowGuideRunnable = () -> {
        if (this.isFollowing() || this.mRoomOwnerId <= 0L) {
            return;
        }
        ArrayList<Long> uids = new ArrayList<Long>();
        uids.add(this.mRoomOwnerId);
        uids.add(AccountUtil.getUid());
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode() || NAB.B.equals((Object)this.mUITest) && this.isSupportFollowGuide()) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfos(uids, new OnProfileCallback(){

                public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                    if (FP.empty(userInfoKSList) || FollowPresenter.this.isDestroyed()) {
                        return;
                    }
                    FollowPresenter.this.addFloatMsg(userInfoKSList, FollowPresenter.this.mCurrentFloatTimes + 1L);
                }

                public void onFail(int id2, String msg, String response) {
                }

                public int id() {
                    return 0;
                }
            });
        }
    };
    Runnable mPublicFollowGuideRunnable = new Runnable(){

        @Override
        public void run() {
            RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(FollowPresenter.this.mRoomOwnerId);
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"followRunnable followed:%s", (Object[])new Object[]{relationInfo.getRelation().getValue()});
            if (!relationInfo.isFollow() && FollowPresenter.this.mRoomOwnerId == FollowPresenter.this.getChannelDetailInfo().baseInfo.ownerUid) {
                boolean matchNewPathTimeTest;
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"request roomOwnerInfo success", (Object[])new Object[0]);
                if (FollowPresenter.this.isDestroyed()) {
                    return;
                }
                int followCount = 0;
                PathTimeAdjustExperiment experiment = PathTimeAdjustExperiment.Companion.newExperiment();
                boolean bl = matchNewPathTimeTest = experiment != null && experiment.matchTest();
                if (!matchNewPathTimeTest) {
                    followCount = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)0);
                    FeatureLog.i((String)"FTVoiceRoomFollow", (String)"followRunnable unFollowed:%s", (Object[])new Object[]{followCount});
                    long appearTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"));
                    if (followCount > FollowPresenter.this.mFollowCount && TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"followRunnable followCount max:%s\uff0c appearCount:%s", (Object[])new Object[]{followCount, FollowPresenter.this.mFollowCount});
                        return;
                    }
                }
                int mode = FollowPresenter.this.getChannel().getPluginService().getCurPluginData().mode;
                if (matchNewPathTimeTest && !ChannelDefine.isRadioMode((int)mode) && !ChannelDefine.isMultiVideoMode((int)mode)) {
                    SeatFollowPresenter seatFollowPresenter = null;
                    IChannelPageContext mvpContext = (IChannelPageContext)FollowPresenter.this.getMvpContext();
                    if (mvpContext != null && mvpContext.hasPresenter(SeatFollowPresenter.class)) {
                        seatFollowPresenter = (SeatFollowPresenter)FollowPresenter.this.getPresenter(SeatFollowPresenter.class);
                    }
                    if (seatFollowPresenter != null) {
                        seatFollowPresenter.innerShowFollowBubble(FollowPresenter.this.mRoomOwnerId, ResourceUtils.getString((int)R.string.channel_radio_video_un_follow_tips), (Function1<? super Boolean, Unit>)new Function1<Boolean, Unit>(){

                            public Unit invoke(Boolean success) {
                                if (!success.booleanValue()) {
                                    MLog.debug((Object)FollowPresenter.TAG, (String)"innerShowFollowBubble fail, push to public screen", (Object[])new Object[0]);
                                    FollowPresenter.this.pushFollowMessage(ResourceUtils.getString((int)R.string.channel_radio_video_un_follow_tips), false);
                                } else {
                                    MLog.debug((Object)FollowPresenter.TAG, (String)"innerShowFollowBubble success, \u6c14\u6ce1\u5f15\u5bfc", (Object[])new Object[0]);
                                }
                                return null;
                            }
                        });
                    } else {
                        MLog.debug((Object)FollowPresenter.TAG, (String)"has not SeatFollowPresenter, pushFollowMessage", (Object[])new Object[0]);
                        FollowPresenter.this.pushFollowMessage(ResourceUtils.getString((int)R.string.channel_radio_video_un_follow_tips), false);
                    }
                } else {
                    FollowPresenter.this.pushFollowMessage(ResourceUtils.getString((int)R.string.channel_radio_video_un_follow_tips), false);
                }
                RoomTrack.INSTANCE.reportFollowGuideShow(FollowPresenter.this.getChannel().getChannelId(), FollowPresenter.this.mRoomOwnerId + "");
                if (!matchNewPathTimeTest) {
                    int finalFollowCount = followCount + 1;
                    SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)finalFollowCount);
                    SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"), (long)System.currentTimeMillis());
                }
            }
        }
    };

    public void onPageAttach(AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach", (Object[])new Object[0]);
        if (this.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
            this.videoStartTime = System.currentTimeMillis();
        }
        if (this.isBan() || this.getChannel().getRoleService().isMeOwner() || this.getChannel().getRoleService().isMeAnchor()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach roomOwner or anchor", (Object[])new Object[0]);
            return;
        }
        this.mRoomOwnerId = this.getAnchorUid();
        this.mUITest = NewABDefine.HAGO_CHATROOM_FOLLOW_UI.getTest();
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_ROOM_FOLLOW);
        if (config instanceof VoiceRoomFollowConfig) {
            VoiceRoomFollowConfig voiceRoomFollowConfig = (VoiceRoomFollowConfig)config;
            int mode = this.getChannel().getPluginService().getCurPluginData().mode;
            if (ChannelDefine.isRadioMode((int)mode)) {
                if (RadioNAB.INSTANCE.getVideoBarNAB((IChannel)this.getChannel())) {
                    this.mFollowDuration = voiceRoomFollowConfig.getRadioVideoFollowTime() * 1000;
                    this.mNewRegisterFollowDuration = voiceRoomFollowConfig.getNewRegisterRadioVideoFollowTime() * 1000;
                } else {
                    this.mFollowDuration = voiceRoomFollowConfig.getRadioFollowTime() * 1000;
                    this.mNewRegisterFollowDuration = voiceRoomFollowConfig.getNewRegisterRadioFollowTime() * 1000;
                }
            } else if (ChannelDefine.isMultiVideoMode((int)mode)) {
                this.mFollowDuration = voiceRoomFollowConfig.getFollowTime() * 1000;
                this.mNewRegisterFollowDuration = voiceRoomFollowConfig.getNewRegisterMultiVideoFollowTime() * 1000;
            } else {
                this.mFollowDuration = voiceRoomFollowConfig.getFollowTime() * 1000;
                this.mNewRegisterFollowDuration = voiceRoomFollowConfig.getNewRegisterFollowTime() * 1000;
            }
            this.mFollowCount = voiceRoomFollowConfig.getFollowCount();
            this.mFollowGuideTimes = voiceRoomFollowConfig.getFollowGuideTimes();
            this.mNewRegisterFollowGuideTimes = voiceRoomFollowConfig.getNewRegisterFollowGuideTimes();
            this.mFollowFloatDuration = voiceRoomFollowConfig.getFollowFloatGuideSecond() * 1000;
            this.mNewRegisterFollowFloatDuration = voiceRoomFollowConfig.getNewRegisterFollowFloatGuideSecond() * 1000;
            this.mFloatFollowShowDuration = voiceRoomFollowConfig.getFloatingSecond() * 1000;
            this.mFollowNum = voiceRoomFollowConfig.getFollowPeopleCount();
        }
        this.handleFloatFollowGuide();
        this.handlePublicScreenFollowGuide();
    }

    protected boolean isBan() {
        return false;
    }

    private void handlePublicScreenFollowGuide() {
        long duration = this.mFollowDuration;
        PathTimeAdjustExperiment experiment = PathTimeAdjustExperiment.Companion.newExperiment();
        if (experiment == null || !experiment.matchTest()) {
            long appearTime = SettingFlags.getLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"));
            int followCount = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"));
            if (followCount >= this.mFollowCount && TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach, followCount max:%s\uff0c appearCount:%s", (Object[])new Object[]{followCount, this.mFollowCount});
                return;
            }
            SettingFlags.setLongValue((String)(AccountUtil.getUid() + "key_voice_room_follow_date"), (long)System.currentTimeMillis());
            if (!TimeUtils.isSameDay((long)appearTime, (long)System.currentTimeMillis())) {
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "key_voice_room_follow_count"), (int)0);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageAttach, followCount reset", (Object[])new Object[0]);
            }
        } else {
            duration = this.mNewRegisterFollowDuration;
        }
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(this.mRoomOwnerId);
        if (!relationInfo.isFollow()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)("onPageAttach not cacheFollowStatus, post PublicFollowGuideRunnable duration: " + duration), (Object[])new Object[0]);
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mPublicFollowGuideRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mPublicFollowGuideRunnable, (long)duration);
        }
    }

    private void handleFloatFollowGuide() {
        if (!this.isFollowing() && this.getChannel().getPluginService().getCurPluginData().isVideoMode()) {
            long followCount;
            int followTimesLimit = this.mFollowGuideTimes;
            int duration = this.mFollowFloatDuration;
            PathTimeAdjustExperiment experiment = PathTimeAdjustExperiment.Companion.newExperiment();
            if (experiment != null && experiment.matchTest()) {
                followTimesLimit = this.mNewRegisterFollowGuideTimes;
                duration = this.mNewRegisterFollowFloatDuration;
            }
            long lastUpdateTime = SettingFlags.getLongValue((String)(LAST_FOLLOW_MILLS + AccountUtil.getUid()), (long)0L);
            if (!DateUtils.isToday((Calendar)Calendar.getInstance(), (long)lastUpdateTime)) {
                SettingFlags.setLongValue((String)(LAST_FOLLOW_MILLS + AccountUtil.getUid()), (long)System.currentTimeMillis());
                SettingFlags.setLongValue((String)(FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide is not today", (Object[])new Object[0]);
            }
            if (this.mCurrentFloatTimes == -1L) {
                this.mCurrentFloatTimes = SettingFlags.getLongValue((String)(FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
            }
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide  value:%s, followTimesLimit:%s", (Object[])new Object[]{this.mCurrentFloatTimes, followTimesLimit});
            if (this.mCurrentFloatTimes >= (long)followTimesLimit) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide followGuideTimes max", (Object[])new Object[0]);
                return;
            }
            if (!(experiment != null && experiment.matchTest() || (followCount = this.getFollowCount()) <= this.mFollowNum)) {
                FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide follownum is max, followCount:%s, max:%s", (Object[])new Object[]{followCount, this.mFollowNum});
                return;
            }
            YYTaskExecutor.postToMainThread((Runnable)this.mFloatFollowGuideRunnable, (long)duration);
        }
    }

    private boolean isSupportFollowGuide() {
        boolean result;
        int mode = this.getChannel().getPluginService().getCurPluginData().getMode();
        if (FP.empty(this.mFollowPluginModes)) {
            MLog.info((Object)TAG, (String)"isSupportFollowGuide config mode is empty ", (Object[])new Object[0]);
            result = ChannelDefine.SUPPORT_FOLLOW_GUIDE.contains(mode);
        } else {
            result = this.mFollowPluginModes.contains(mode);
        }
        MLog.info((Object)TAG, (String)("isSupportFollowGuide mode = " + mode + ", result = " + result), (Object[])new Object[0]);
        return result;
    }

    protected long getTheDayShowTimes() {
        long lastUpdateTime = SettingFlags.getLongValue((String)(LAST_COMMON_FOLLOW_MILLS + AccountUtil.getUid()), (long)0L);
        if (!DateUtils.isToday((Calendar)Calendar.getInstance(), (long)lastUpdateTime)) {
            SettingFlags.setLongValue((String)(LAST_COMMON_FOLLOW_MILLS + AccountUtil.getUid()), (long)System.currentTimeMillis());
            SettingFlags.setLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
        }
        long value = SettingFlags.getLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)0L);
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onFollowGuide  value:%s, followGuideTimes:%s", (Object[])new Object[]{value, this.followGuideTimes});
        return value;
    }

    private void addFloatMsg(List<UserInfoKS> userInfoKSList, long times) {
        UserInfoKS userInfo = null;
        String myNick = "";
        for (UserInfoKS userInfoKS : userInfoKSList) {
            if (userInfoKS.uid == AccountUtil.getUid()) {
                myNick = userInfoKS.nick;
                continue;
            }
            if (userInfoKS.uid != this.mRoomOwnerId) continue;
            userInfo = userInfoKS;
        }
        FloatMsgFollowInfo floatMsgInfo = new FloatMsgFollowInfo(100, ResourceUtils.getString((int)R.string.tips_float_msg_follow_tittle, (Object[])new Object[]{myNick}), ResourceUtils.getString((int)R.string.tips_float_msg_follow_content_2), userInfo, this.mFloatFollowShowDuration);
        if (!this.isDestroyed()) {
            ((IRevenueToolsModulePresenter)this.getPresenter(IRevenueToolsModulePresenter.class)).addFloatMsgItem((FloatMsgInfo)floatMsgInfo);
        }
        this.markShowedFloatFollowTimes(times);
        SettingFlags.setLongValue((String)(FOLLOW_TIMES + AccountUtil.getUid()), (long)times);
        this.mCurrentFloatTimes = times;
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"addFloatMsg times: %d", (Object[])new Object[]{times});
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "olaparty_attention_guided_show").put("guest_uid", AccountUtil.getUid() + "").put("lead_focus_uid", this.mRoomOwnerId + "").put("room_id", this.getChannelId()).put("voice_type", "3"));
    }

    protected void markShowedFloatFollowTimes(long times) {
        SettingFlags.setLongValue((String)(SHOWED_FOLLOW_TIMES + AccountUtil.getUid()), (long)times);
    }

    private boolean isFollowing() {
        this.mRoomOwnerId = this.getAnchorUid();
        RelationInfo relationInfo = ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationLocal(this.mRoomOwnerId);
        return relationInfo.isFollow();
    }

    private Long getAnchorUid() {
        if (this.getChannel().getDataService().getCacheDetail().baseInfo.isLoopMicRoom()) {
            return ((IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class)).getCurrentChannel().getRoleService().getAnchorUid();
        }
        return this.getChannelDetailInfo().baseInfo.ownerUid;
    }

    private long getFollowCount() {
        return ((IRelationService)ServiceManagerProxy.getServiceManager().getService(IRelationService.class)).getRelationNum(AccountUtil.getUid(), false, null).getFollowNum();
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onPageDetach", (Object[])new Object[0]);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mPublicFollowGuideRunnable);
        YYTaskExecutor.removeTask((Runnable)this.mFloatFollowGuideRunnable);
    }

    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTVoiceRoomFollow", (String)"onDestroy", (Object[])new Object[0]);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mPublicFollowGuideRunnable);
        YYTaskExecutor.removeTask((Runnable)this.mFloatFollowGuideRunnable);
        this.showFollowLeaveDialog();
    }

    private void showFollowLeaveDialog() {
    }

    protected void pushFollowMessage(String text, boolean isGift) {
        IPublicScreenModulePresenter publicScreenPresenter = (IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class);
        if (publicScreenPresenter == null || publicScreenPresenter.getPublicScreenPresenter() == null || this.isDestroyed()) {
            FeatureLog.i((String)"FTVoiceRoomFollow", (String)"chatPresenter null", (Object[])new Object[0]);
            return;
        }
        BaseImMsg followMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateFollowMsg(this.getChannel().getChannelId(), (CharSequence)text, this.mRoomOwnerId, this.getChannel().getRoleService().getRoleCache(this.mRoomOwnerId), isGift);
        publicScreenPresenter.getPublicScreenPresenter().appendLocalMsg(followMsg);
    }
}

