/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator.page;

import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.fragment.app.FragmentActivity;

public class SoftHideKeyBoardUtil {
    private View mChildOfContent;
    private int usableHeightPrevious;
    private FrameLayout.LayoutParams frameLayoutParams;
    private int contentHeight;
    private boolean isfirst = true;
    private int statusBarHeight;

    public static void assistActivity(FragmentActivity activity) {
        new SoftHideKeyBoardUtil(activity);
    }

    private SoftHideKeyBoardUtil(FragmentActivity activity) {
        FrameLayout content = (FrameLayout)activity.findViewById(0x1020002);
        this.mChildOfContent = content.getChildAt(0);
        this.mChildOfContent.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (SoftHideKeyBoardUtil.this.isfirst) {
                    SoftHideKeyBoardUtil.this.usableHeightPrevious = SoftHideKeyBoardUtil.this.computeUsableHeight();
                    SoftHideKeyBoardUtil.this.isfirst = false;
                }
                SoftHideKeyBoardUtil.this.contentHeight = SoftHideKeyBoardUtil.this.mChildOfContent.getHeight();
                SoftHideKeyBoardUtil.this.possiblyResizeChildOfContent();
            }
        });
        this.frameLayoutParams = (FrameLayout.LayoutParams)this.mChildOfContent.getLayoutParams();
    }

    private void possiblyResizeChildOfContent() {
        int usableHeightNow = this.computeUsableHeight();
        if (usableHeightNow != this.usableHeightPrevious) {
            int usableHeightSansKeyboard = this.mChildOfContent.getRootView().getHeight();
            int heightDifference = usableHeightSansKeyboard - usableHeightNow;
            this.frameLayoutParams.height = heightDifference > usableHeightSansKeyboard / 4 ? (Build.VERSION.SDK_INT >= 19 ? usableHeightSansKeyboard - heightDifference + this.statusBarHeight : usableHeightSansKeyboard - heightDifference) : this.contentHeight;
            this.mChildOfContent.requestLayout();
            this.usableHeightPrevious = usableHeightNow;
        }
    }

    private int computeUsableHeight() {
        Rect r = new Rect();
        this.mChildOfContent.getWindowVisibleDisplayFrame(r);
        return r.bottom - r.top;
    }
}

