/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.module.creator;

import android.text.TextUtils;
import biz.PluginInfo;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.create.CreateChannelParams;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.module.creator.bean.RoomPermissionData;
import com.yy.hiyo.channel.module.creator.bean.RoomTypeData;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u0014J\u001e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\rJ\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/yy/hiyo/channel/module/creator/RoomCreateManager;", "", "serviceManager", "Lcom/yy/appbase/service/IServiceManager;", "(Lcom/yy/appbase/service/IServiceManager;)V", "buildGamePluginInfo", "Lbiz/PluginInfo;", "gameInfo", "Lcom/yy/hiyo/game/base/bean/GameInfo;", "cleanActivityId", "", "cleanLocationGid", "firstLocationGidToPluginType", "", "defaultPluginType", "firstLocationGidToType", "isVideo", "", "getChannelTypeList", "Ljava/util/ArrayList;", "Lcom/yy/hiyo/channel/module/creator/bean/RoomTypeData;", "obtainPluginInfoData", "roomTypeData", "paresPluginTypeToRoomPageType", "pluginType", "firstRoomType", "roomPermissionData", "Lcom/yy/hiyo/channel/module/creator/bean/RoomPermissionData;", "paresPluginTypeToRoomType", "isGame", "showConfirmDialog", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "dialogManager", "Lcom/yy/framework/core/ui/dialog/frame/DialogLinkManager;", "listener", "Lcom/yy/appbase/ui/dialog/OkCancelDialogListener;", "Companion", "channel-components_release"})
public final class RoomCreateManager {
    private final IServiceManager serviceManager;
    @NotNull
    public static final String TAG = "RoomCreateManager";
    public static final Companion Companion = new Companion(null);

    public final void showConfirmDialog(@NotNull IChannel channel, @NotNull DialogLinkManager dialogManager, @NotNull OkCancelDialogListener listener2) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)dialogManager, (String)"dialogManager");
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        MLog.info((Object)TAG, (String)"showConfirmDialog", (Object[])new Object[0]);
        if (Intrinsics.areEqual((Object)RuntimeContext.getChannelPluginId(), (Object)"radio")) {
            string2 = ResourceUtils.getString((int)R.string.tips_radio_close);
        } else {
            IDataService iDataService;
            IGameInfoService iGameInfoService = (IGameInfoService)this.serviceManager.getService(IGameInfoService.class);
            GameInfo gameInfo = iGameInfoService != null ? iGameInfoService.getGameInfoByGid(RuntimeContext.getChannelPluginId()) : null;
            Object[] objectArray = new Object[1];
            Object object = gameInfo;
            if (object == null || (object = object.getGname()) == null) {
                object = ResourceUtils.getString((int)R.string.default_chat_room_name);
            }
            objectArray[0] = object;
            ResourceUtils.getString((int)R.string.tips_other_game_close, (Object[])objectArray);
            string2 = gameInfo != null && StringUtils.isNotEmpty((String)gameInfo.getGname()) ? ResourceUtils.getString((int)R.string.tips_other_game_close, (Object[])new Object[]{gameInfo.getGname()}) : ResourceUtils.getString((int)R.string.tips_exit_confirm_in_room, (Object[])new Object[]{(iDataService = channel.getDataService()) != null && (iDataService = iDataService.getCacheDetail()) != null && (iDataService = iDataService.baseInfo) != null ? iDataService.name : null});
        }
        String tip = string2;
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)tip, (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, listener2);
        dialogManager.showDialog((BaseDialog)dialog2);
    }

    @NotNull
    public final ArrayList<RoomTypeData> getChannelTypeList() {
        IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
        if (iServiceManager == null) {
            Intrinsics.throwNpe();
        }
        IHomePlanService homePlanService = (IHomePlanService)iServiceManager.getService(IHomePlanService.class);
        boolean needCheckMinor = homePlanService.isMyselfMinorProtect();
        ArrayList<RoomTypeData> channelTypeList = new ArrayList<RoomTypeData>();
        String string2 = ResourceUtils.getString((int)R.string.room_type_chat);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ResourceUtils.getString(R.string.room_type_chat)");
        RoomTypeData chatType = new RoomTypeData("chat", 1, string2);
        channelTypeList.add(chatType);
        if (!RuntimeContext.isHagoPartySdk()) {
            String string3 = ResourceUtils.getString((int)R.string.room_type_game);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ResourceUtils.getString(R.string.room_type_game)");
            RoomTypeData gameType = new RoomTypeData("chat", 2, string3);
            channelTypeList.add(gameType);
        }
        IService iService = ServiceManagerProxy.getService(IGameInfoService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026eInfoService::class.java)");
        List gameInfoList = ((IGameInfoService)iService).getInVoiceRoomGameInfoList();
        if (gameInfoList != null) {
            for (GameInfo gameInfo : gameInfoList) {
                if (gameInfo == null || gameInfo.isHide() || needCheckMinor && homePlanService.isHideChannelPlugin(gameInfo.gid)) continue;
                if (Intrinsics.areEqual((Object)"ktv", (Object)gameInfo.gid)) {
                    String string4 = ResourceUtils.getString((int)R.string.new_page_room_type_ktv);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ResourceUtils.getString(\u2026g.new_page_room_type_ktv)");
                    RoomTypeData ktvType = new RoomTypeData("ktv", 5, string4);
                    channelTypeList.add(ktvType);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)"pickme", (Object)gameInfo.gid)) continue;
                String string5 = ResourceUtils.getString((int)R.string.new_page_room_type_date);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"ResourceUtils.getString(\u2026.new_page_room_type_date)");
                RoomTypeData pickMeType = new RoomTypeData("pickme", 4, string5);
                channelTypeList.add(pickMeType);
            }
        }
        return channelTypeList;
    }

    @Nullable
    public final PluginInfo obtainPluginInfoData(@NotNull RoomTypeData roomTypeData) {
        Intrinsics.checkParameterIsNotNull((Object)roomTypeData, (String)"roomTypeData");
        int type = 10;
        String ext = "";
        if (roomTypeData.getType() == 5) {
            type = 11;
        } else if (roomTypeData.getType() == 2) {
            if (roomTypeData.getSelectedGame() != null) {
                GameInfo gameInfo = roomTypeData.getSelectedGame();
                if (gameInfo == null) {
                    Intrinsics.throwNpe();
                }
                return this.buildGamePluginInfo(gameInfo);
            }
            type = 10;
        } else if (roomTypeData.getType() == 4) {
            type = 13;
        } else if (roomTypeData.getType() == 3) {
            type = 14;
            MLog.info((Object)TAG, (String)"start room from audio", (Object[])new Object[0]);
        } else if (roomTypeData.getType() == 6) {
            type = 15;
        } else if (roomTypeData.getType() == 7) {
            MLog.info((Object)TAG, (String)"start room from video", (Object[])new Object[0]);
            type = 14;
            JSONObject extJson = JsonParser.obtainJSONObject();
            extJson.put("is_video_open", true);
            String string2 = extJson.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"extJson.toString()");
            ext = string2;
            MLog.info((Object)TAG, (String)("start room from video ext:" + ext), (Object[])new Object[0]);
        }
        return new PluginInfo.Builder().type(Integer.valueOf(type)).ext(ext).pid(roomTypeData.getGid()).build();
    }

    private final PluginInfo buildGamePluginInfo(GameInfo gameInfo) {
        JSONObject extJson = JsonParser.obtainJSONObject();
        extJson.put("plugin_launcher", (Object)String.valueOf(AccountUtil.getUid()));
        PluginInfo.Builder builder = new PluginInfo.Builder().type(Integer.valueOf(ChannelUtils.getMode((GameInfo)gameInfo))).pid(gameInfo.gid).templ(Long.valueOf(gameInfo.getRoomTemplate()));
        Object object = gameInfo.getModulerVer();
        if (object == null || (object = StringsKt.toLongOrNull((String)object)) == null) {
            object = 0L;
        }
        PluginInfo pluginInfo = builder.ver((Long)object).ext(extJson.toString()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginInfo, (String)"PluginInfo.Builder()\n   \u2026\n                .build()");
        return pluginInfo;
    }

    public final int paresPluginTypeToRoomPageType(int pluginType, int firstRoomType, @NotNull RoomPermissionData roomPermissionData) {
        Intrinsics.checkParameterIsNotNull((Object)roomPermissionData, (String)"roomPermissionData");
        MLog.debug((Object)TAG, (String)"paresPluginTypeToRoomPageType", (Object[])new Object[0]);
        int roomPageType = 1;
        boolean hasPagePermission = true;
        int innerPluginType = pluginType;
        int uriPluginType = this.firstLocationGidToPluginType(pluginType);
        if (uriPluginType != 0) {
            innerPluginType = uriPluginType;
        }
        switch (innerPluginType) {
            case 15: {
                roomPageType = 2;
                hasPagePermission = roomPermissionData.getMultiVideoPermission();
                break;
            }
            case 14: {
                roomPageType = 3;
                hasPagePermission = roomPermissionData.getRadioVideoPermission() || roomPermissionData.getRadioAudioPermission();
                break;
            }
            default: {
                roomPageType = 1;
            }
        }
        if (uriPluginType != 0 && hasPagePermission) {
            return roomPageType;
        }
        if (firstRoomType == 0 && hasPagePermission) {
            return roomPageType;
        }
        if (firstRoomType == 2 && roomPermissionData.getMultiVideoPermission() || firstRoomType == 3 && (roomPermissionData.getRadioAudioPermission() || roomPermissionData.getRadioVideoPermission())) {
            return firstRoomType;
        }
        return 1;
    }

    public final int paresPluginTypeToRoomType(int pluginType, boolean isGame, boolean isVideo, int firstRoomType) {
        MLog.info((Object)TAG, (String)("paresPluginTypeToRoomType isGame:" + isGame + " firstRoomType:" + firstRoomType), (Object[])new Object[0]);
        if (Intrinsics.areEqual((Object)SettingFlags.getStringValue((String)("key_deeplink_to_start_page_type" + AccountUtil.getUid())), (Object)"game")) {
            return 2;
        }
        int locationGid = this.firstLocationGidToType(isVideo);
        if (locationGid != 0) {
            return locationGid;
        }
        if (firstRoomType == 5) {
            return 2;
        }
        switch (pluginType) {
            case 10: {
                if (isGame) {
                    return 2;
                }
                return 1;
            }
            case 11: {
                return 5;
            }
            case 100: {
                return 2;
            }
            case 200: {
                return 2;
            }
            case 300: {
                return 2;
            }
            case 13: {
                return 4;
            }
            case 15: {
                return 6;
            }
            case 14: {
                if (isVideo) {
                    return 7;
                }
                return 3;
            }
            case 400: {
                return 2;
            }
        }
        return 1;
    }

    public final int firstLocationGidToType(boolean isVideo) {
        String gid;
        String string2 = gid = SettingFlags.getStringValue((String)("key_deeplink_to_start_page_gid" + AccountUtil.getUid()));
        if (string2 != null) {
            switch (string2) {
                case "chat": {
                    return 1;
                }
                case "ktv": {
                    return 5;
                }
                case "pickme": {
                    return 4;
                }
                case "multivideo": {
                    return 6;
                }
                case "radio": {
                    if (isVideo) {
                        return 7;
                    }
                    return 3;
                }
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int firstLocationGidToPluginType(int defaultPluginType) {
        String gid = SettingFlags.getStringValue((String)("key_deeplink_to_start_page_gid" + AccountUtil.getUid()));
        if (TextUtils.isEmpty((CharSequence)gid)) {
            return 0;
        }
        String string2 = gid;
        if (string2 != null) {
            switch (string2) {
                case "multivideo": {
                    return 15;
                }
                case "radio": {
                    return 14;
                }
            }
        }
        int n = defaultPluginType;
        return n;
    }

    public final void cleanLocationGid() {
        SettingFlags.setStringValue((String)("key_deeplink_to_start_page_type" + AccountUtil.getUid()), (String)"");
        SettingFlags.setStringValue((String)("key_deeplink_to_start_page_gid" + AccountUtil.getUid()), (String)"");
    }

    public final void cleanActivityId() {
        SettingFlags.setStringValue((String)("key_h5_to_start_page_activity_id" + AccountUtil.getUid()), (String)"");
    }

    public RoomCreateManager(@NotNull IServiceManager serviceManager) {
        Intrinsics.checkParameterIsNotNull((Object)serviceManager, (String)"serviceManager");
        this.serviceManager = serviceManager;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/yy/hiyo/channel/module/creator/RoomCreateManager$Companion;", "", "()V", "TAG", "", "reportNewRoomSuccess", "", "enterRoomTypeData", "Lcom/yy/hiyo/channel/module/creator/bean/RoomTypeData;", "roleType", "", "duringTime", "", "channelId", "isGroup", "", "from", "channel-components_release"})
    public static final class Companion {
        public final void reportNewRoomSuccess(@NotNull RoomTypeData enterRoomTypeData, int roleType, long duringTime, @NotNull String channelId, boolean isGroup, int from) {
            String source;
            Intrinsics.checkParameterIsNotNull((Object)enterRoomTypeData, (String)"enterRoomTypeData");
            Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
            String lableId = enterRoomTypeData.getType() == 3 || enterRoomTypeData.getType() == 7 ? "7" : (enterRoomTypeData.getType() == 6 ? "" : String.valueOf(enterRoomTypeData.getType()));
            String voiceType = String.valueOf(1);
            if (enterRoomTypeData.getType() == 1) {
                voiceType = String.valueOf(1);
            } else if (enterRoomTypeData.getType() == 2) {
                voiceType = String.valueOf(2);
            } else if (enterRoomTypeData.getType() == 3) {
                voiceType = String.valueOf(3);
            }
            String h5ActivityId = SettingFlags.getStringValue((String)("key_h5_to_start_page_activity_id" + AccountUtil.getUid()), (String)"");
            String string2 = !TextUtils.isEmpty((CharSequence)h5ActivityId) ? "h5" : (isGroup ? (from == CreateChannelParams.From.channel_bottom_add ? "3" : "1") : (source = "2"));
            if (roleType == 0) {
                String string3 = String.valueOf(duringTime);
                Object object = enterRoomTypeData.getSelectedGame();
                if (object == null || (object = object.gid) == null) {
                    object = enterRoomTypeData.getGid();
                }
                RoomTrack.INSTANCE.reportNewRoomSuccess(source, channelId, lableId, voiceType, string3, "", (String)object, h5ActivityId);
            } else {
                String string4 = String.valueOf(duringTime);
                String string5 = String.valueOf(roleType);
                Object object = enterRoomTypeData.getSelectedGame();
                if (object == null || (object = object.gid) == null) {
                    object = enterRoomTypeData.getGid();
                }
                RoomTrack.INSTANCE.reportNewRoomSuccess(source, channelId, lableId, voiceType, string4, string5, (String)object, h5ActivityId);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

