/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.voicefilter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.config.VoiceFilterConfig;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.VoiceFilterData;
import com.yy.hiyo.channel.component.voicefilter.VoiceFilterPresenter;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class VoiceFilterItem
extends YYRelativeLayout {
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private YYTextView mName;
    private View mBorder;
    private CircleImageView mLogo;
    private View mBg;
    private VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem mInfo;
    private VoiceFilterPresenter mPresenter;
    private OnVoiceFilterItemClickListener mOnItemClickListener;
    private int mIndex;

    public VoiceFilterItem(Context context, VoiceFilterPresenter presenter, OnVoiceFilterItemClickListener listener2) {
        super(context);
        this.mPresenter = presenter;
        this.mOnItemClickListener = listener2;
        this.init();
    }

    private void init() {
        VoiceFilterItem.inflate((Context)this.getContext(), (int)R.layout.layout_voice_filter_item, (ViewGroup)this);
        this.mBorder = this.findViewById(R.id.lvfi_border);
        this.mName = (YYTextView)this.findViewById(R.id.lvfi_name);
        this.mLogo = (CircleImageView)this.findViewById(R.id.lvfi_logo);
        this.mBg = this.findViewById(R.id.lvfi_bg);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VoiceFilterItem.this.mPresenter.getChannel().getVoiceFilterService().selectVoiceFilter(((VoiceFilterItem)VoiceFilterItem.this).mInfo.id);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "change_sound_click").put("room_id", VoiceFilterItem.this.mPresenter.getChannelId()).put("gid", VoiceFilterItem.this.mPresenter.getChannel().getPluginService().getCurPluginData().getId()).put("change_sound_mode", String.valueOf(((VoiceFilterItem)VoiceFilterItem.this).mInfo.id)));
                if (VoiceFilterItem.this.mOnItemClickListener != null) {
                    int[] positions = new int[2];
                    VoiceFilterItem.this.getLocationInWindow(positions);
                    VoiceFilterItem.this.mOnItemClickListener.onClick(((VoiceFilterItem)VoiceFilterItem.this).mInfo.id, positions[0], positions[1], VoiceFilterItem.this.mIndex);
                }
            }
        });
    }

    @KvoMethodAnnotation(name="currentVoiceFilterId", sourceClass=VoiceFilterData.class, thread=1)
    public void onSelectedChanged(KvoEventIntent kvoEvent) {
        if (!this.isAttachToWindow()) {
            return;
        }
        int id2 = (Integer)kvoEvent.caseNewValue((Object)0);
        this.setSelected(id2 == this.mInfo.id);
        this.mBorder.setVisibility(id2 == this.mInfo.id ? 0 : 8);
    }

    @KvoMethodAnnotation(name="currentChannelMode", sourceClass=VoiceFilterData.class, thread=1)
    public void onModeChanged(KvoEventIntent kvoEvent) {
        if (!this.isAttachToWindow()) {
            return;
        }
        int mode = (Integer)kvoEvent.caseNewValue((Object)1);
        if (mode == 1) {
            this.mName.setTextColor(this.getResources().getColorStateList(R.color.selector_voice_filter_item_base_text_color));
            this.mBg.setBackgroundResource(R.drawable.shape_voice_filter_item_bg_base);
        } else {
            this.mName.setTextColor(this.getResources().getColorStateList(R.color.selector_voice_filter_item_text_color));
            this.mBg.setBackgroundResource(R.drawable.shape_voice_filter_item_bg);
        }
    }

    private void bindData() {
        this.mQueueTaskExecutor.execute(() -> this.mBinder.singleBindSourceTo((KvoSource)this.mPresenter.getChannel().getVoiceFilterService().data()), 0L);
    }

    private void unbindData() {
        this.mQueueTaskExecutor.execute(() -> this.mBinder.clearAllKvoConnections(), 0L);
    }

    public void update(int index, VoiceFilterConfig.VoiceFilterConfigData.VoiceFilterConfigItem info) {
        this.mIndex = index;
        this.mInfo = info;
        this.mName.setText((CharSequence)info.name);
        ImageLoader.loadImage((ImageView)this.mLogo, (String)info.url);
        this.bindData();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mInfo != null) {
            this.bindData();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unbindData();
    }

    public static interface OnVoiceFilterItemClickListener {
        public void onClick(int var1, int var2, int var3, int var4);
    }
}

