/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.topact;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;

public class RectFView
extends YYView {
    private Paint bigCirclePaint;
    private int startAngle = 0;
    public static final int RESOLUTION_2_DP = ResolutionUtils.dip2Px((float)2.0f);
    int[] colors = new int[]{0, -1, 0};

    public RectFView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.bigCirclePaint = new Paint();
        this.bigCirclePaint.setStrokeWidth((float)RESOLUTION_2_DP);
        this.bigCirclePaint.setStyle(Paint.Style.STROKE);
        this.bigCirclePaint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        ++this.startAngle;
        if (this.startAngle == 360) {
            this.startAngle = 0;
        }
        float[] position = new float[]{(float)this.startAngle * 1.0f / 360.0f, (float)(this.startAngle + 60) * 1.0f / 360.0f, (float)(this.startAngle + 120) * 1.0f / 360.0f};
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.startAngle > 240) {
            canvas.save();
            canvas.rotate(180.0f, (float)(width / 2), (float)(height / 2));
            int rotateAngle = this.startAngle - 180;
            position[0] = (float)rotateAngle * 1.0f / 360.0f;
            position[1] = (float)(rotateAngle + 60) * 1.0f / 360.0f;
            position[2] = (float)(rotateAngle + 120) * 1.0f / 360.0f;
        }
        SweepGradient linearGradient = new SweepGradient((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2), this.colors, position);
        this.bigCirclePaint.setShader((Shader)linearGradient);
        RectF r2 = new RectF();
        r2.left = RESOLUTION_2_DP;
        r2.right = this.getMeasuredWidth() - RESOLUTION_2_DP;
        r2.top = RESOLUTION_2_DP;
        r2.bottom = this.getMeasuredHeight() - RESOLUTION_2_DP;
        canvas.drawRoundRect(r2, 180.0f, 180.0f, this.bigCirclePaint);
        canvas.save();
        canvas.rotate(180.0f, (float)(width / 2), (float)(height / 2));
        canvas.drawRoundRect(r2, 180.0f, 180.0f, this.bigCirclePaint);
        if (this.getVisibility() == 0) {
            this.invalidate();
        }
    }
}

