/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.theme;

import android.text.TextUtils;
import androidx.lifecycle.MutableLiveData;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.hiyo.channel.base.bean.ThemeItemBean;
import java.util.HashMap;
import java.util.Map;

public enum ThemeResManager {
    INSTANCE;

    private Map<String, Integer> mTagThemeMap = new HashMap<String, Integer>();
    private Map<String, MutableLiveData<ThemeItemBean>> mPartyThemeIdMap = new HashMap<String, MutableLiveData<ThemeItemBean>>();

    public int getThemeByTag(String tagId) {
        int themeId = this.mTagThemeMap.get(tagId);
        return themeId;
    }

    public void setTagThemeMap(String tagId, int themeId) {
        this.mTagThemeMap.put(tagId, themeId);
    }

    public void setPartyTheme(String roomId, ThemeItemBean theme) {
        if (TextUtils.isEmpty((CharSequence)roomId)) {
            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setPartyTheme roomId is null", (Object[])new Object[0]);
            return;
        }
        MutableLiveData roomThemeLiveData = this.mPartyThemeIdMap.get(roomId);
        if (roomThemeLiveData == null) {
            roomThemeLiveData = new MutableLiveData();
            this.mPartyThemeIdMap.put(roomId, (MutableLiveData<ThemeItemBean>)roomThemeLiveData);
        }
        if (theme != null) {
            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setPartyTheme roomId:%s, theme:%s, url:%s", (Object[])new Object[]{roomId, theme.getThemeId(), theme.getUrl()});
            roomThemeLiveData.setValue((Object)theme);
        } else {
            roomThemeLiveData.setValue(null);
            FeatureLog.i((String)"FTVoiceRoomTheme", (String)"setPartyTheme roomId:%s, theme is null", (Object[])new Object[]{roomId});
        }
    }

    public ThemeItemBean getCurrentPartyTheme(String roomId) {
        if (FP.empty((CharSequence)roomId)) {
            return null;
        }
        MutableLiveData<ThemeItemBean> roomThemeLiveData = this.mPartyThemeIdMap.get(roomId);
        if (roomThemeLiveData == null) {
            return null;
        }
        ThemeItemBean themeItemBean = (ThemeItemBean)roomThemeLiveData.getValue();
        return themeItemBean;
    }
}

