/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.textgroup.gameplay.gameinvite;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.lifecycle.LifecycleOwner;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.architecture.Resource;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.ChannelPageContext;
import com.yy.hiyo.channel.component.textgroup.data.GamePlayBean;
import com.yy.hiyo.channel.component.textgroup.gameplay.BaseGamePresenter;
import com.yy.hiyo.channel.component.textgroup.gameplay.GamePlayTabPresenter;
import com.yy.hiyo.channel.component.textgroup.gameplay.IFunCallback;
import com.yy.hiyo.channel.component.textgroup.gameplay.IGamePlayCallback;
import com.yy.hiyo.channel.component.textgroup.gameplay.gameinvite.PkGameListPanel;
import com.yy.hiyo.channel.component.textgroup.gameplay.gameinvite.PkGameListViewModel;
import com.yy.hiyo.channel.component.textgroup.gameplay.gameinvite.PkGamePanelContext;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PkGameListPresenter
extends BaseGamePresenter {
    private static final String TAG = "PkGameListPresenter";
    @SuppressLint(value={"StaticFieldLeak"})
    private PkGameListPanel pkGameListPanel;
    private PkGamePanelContext lifecycle;
    private ChannelPageContext<AbsPage> mMvpContext;
    private IFunCallback mCallback;
    private IGamePlayCallback mGamePlayCallback;

    public PkGameListPresenter(ChannelPageContext<AbsPage> mContext, IFunCallback callback2) {
        this.mMvpContext = mContext;
        this.mCallback = callback2;
    }

    private void initData(PkGamePanelContext lifecycle) {
        PkGameListViewModel viewModel = new PkGameListViewModel();
        viewModel.onInit(lifecycle);
        viewModel.getDataSource().observe((LifecycleOwner)viewModel.getLifeCycleOwner(), listResource -> {
            if (listResource == null) {
                return;
            }
            switch (listResource.status) {
                case LOADING: {
                    this.pkGameListPanel.showLoading();
                    break;
                }
                case ERROR: {
                    this.pkGameListPanel.showError();
                    this.pkGameListPanel.hideAllStatus();
                    break;
                }
                case SUCCESS: {
                    this.pkGameListPanel.hideAllStatus();
                    if (listResource.data == null || ((List)listResource.data).isEmpty()) {
                        this.pkGameListPanel.showNoData();
                        break;
                    }
                    this.sortGame((Resource<List<GameInfo>>)listResource);
                    break;
                }
            }
        });
    }

    private void sortGame(final Resource<List<GameInfo>> listResource) {
        ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getMatchGamePlayInfo(new GameInfoModuleData.Matcher(){

            public boolean match(GamePlayInfoDBBean infoDBBean) {
                return true;
            }
        }, new GameInfoModuleData.MatchCallback(){

            public void onGetResult(List<GamePlayInfo> gamePlayInfos) {
                if (gamePlayInfos != null && gamePlayInfos.size() > 0) {
                    ArrayList<GamePlayBean> gamePlayBeanList = new ArrayList<GamePlayBean>();
                    for (GameInfo gameInfo : (List)listResource.data) {
                        GamePlayBean gamePlayBean = new GamePlayBean();
                        gamePlayBean.setGameInfo(gameInfo);
                        for (GamePlayInfo gamePlayInfo : gamePlayInfos) {
                            if (!gameInfo.getGid().equals(gamePlayInfo.getGameId())) continue;
                            gamePlayBean.setEndTs(gamePlayInfo.getLatestPlayTs());
                            break;
                        }
                        gamePlayBeanList.add(gamePlayBean);
                    }
                    Collections.sort(gamePlayBeanList);
                    ArrayList<GameInfo> sortGameList = new ArrayList<GameInfo>();
                    for (GamePlayBean gamePlayBean : gamePlayBeanList) {
                        if (gamePlayBean.getGameInfo() == null) continue;
                        sortGameList.add(gamePlayBean.getGameInfo());
                    }
                    PkGameListPresenter.this.pkGameListPanel.updateGameList(sortGameList);
                    if (PkGameListPresenter.this.mMvpContext.getChannel() != null && PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam() != null && !TextUtils.isEmpty((CharSequence)((CharSequence)PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam().getExtra("key_guide_game_id", (Object)""))) && !SettingFlags.getBoolean((String)"key_channel_game_high_light", (boolean)false)) {
                        PkGameListPresenter.this.findGuideGame((String)PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam().getExtra("key_guide_game_id", (Object)""), sortGameList);
                    }
                } else {
                    PkGameListPresenter.this.pkGameListPanel.updateGameList((List)listResource.data);
                    if (PkGameListPresenter.this.mMvpContext.getChannel() != null && PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam() != null && !TextUtils.isEmpty((CharSequence)((CharSequence)PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam().getExtra("key_guide_game_id", (Object)""))) && !SettingFlags.getBoolean((String)"key_channel_game_high_light", (boolean)false)) {
                        PkGameListPresenter.this.findGuideGame((String)PkGameListPresenter.this.mMvpContext.getChannel().getEnterParam().getExtra("key_guide_game_id", (Object)""), (List)listResource.data);
                    }
                }
            }
        });
    }

    @Override
    @Nullable
    public View getGamePanel() {
        this.pkGameListPanel = new PkGameListPanel((Context)this.mMvpContext.getContext());
        this.pkGameListPanel.setPanelCallback(this.getPanelCallback());
        return this.pkGameListPanel;
    }

    @Override
    public void onGameClick(@NotNull GameInfo gameInfo) {
        super.onGameClick(gameInfo);
        ChannelTrack.INSTANCE.onGameItemClick(gameInfo.gid);
    }

    @Override
    public void onDownloadFinishAndStartGame(@NotNull String gameId) {
        if (this.mMvpContext != null) {
            ((GamePlayTabPresenter)this.mMvpContext.getPresenter(GamePlayTabPresenter.class)).hideGameListPanel();
            if (this.mCallback != null) {
                this.mCallback.onClickGame(gameId, null);
            }
        }
    }

    public void onHidden() {
        if (this.lifecycle != null) {
            this.lifecycle.onDestroy();
        }
        this.pkGameListPanel = null;
        this.lifecycle = null;
        this.getMBinder().clearAllKvoConnections();
    }

    public void setGamePlayCallback(IGamePlayCallback callback2) {
        this.mGamePlayCallback = callback2;
    }

    private void findGuideGame(String gameId, List<GameInfo> gameInfoList) {
        if (gameId.isEmpty()) {
            return;
        }
        for (int i = 0; i < gameInfoList.size(); ++i) {
            if (!gameInfoList.get((int)i).gid.equals(gameId) || this.mGamePlayCallback == null) continue;
            this.mGamePlayCallback.findGuideGame(1, gameId, i);
            break;
        }
    }

    public void setGameHightLight(int position) {
        if (this.pkGameListPanel != null) {
            this.pkGameListPanel.setGameHighLight(position);
        }
    }

    public void scrollToGame(int position) {
        if (this.pkGameListPanel != null) {
            this.pkGameListPanel.scrollToGame(position);
        }
    }

    public void onShow() {
        if (this.pkGameListPanel != null) {
            this.lifecycle = new PkGamePanelContext((View)this.pkGameListPanel);
            this.initData(this.lifecycle);
        }
    }
}

