/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.setting.viewmodel;

import android.content.Context;
import androidx.lifecycle.MutableLiveData;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.component.setting.callback.IChannelBlackResetCallback;
import com.yy.hiyo.channel.component.setting.data.BlackMember;
import com.yy.hiyo.channel.component.setting.data.PageData;
import com.yy.hiyo.channel.component.setting.viewmodel.ChannelBlackListViewModel;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Page;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.GetChannelBlackListReq;
import net.ihago.channel.srv.mgr.GetChannelBlackListRes;
import net.ihago.channel.srv.mgr.ResetUserFromBlackListReq;
import net.ihago.channel.srv.mgr.ResetUserFromBlackListRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0004J&\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\nH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/yy/hiyo/channel/component/setting/viewmodel/ChannelBlackListViewModel;", "", "()V", "blackLiveData", "Landroidx/lifecycle/MutableLiveData;", "", "Lcom/yy/hiyo/channel/component/setting/data/BlackMember;", "limitCount", "", "netErrorStatusLiveData", "", "noMoreLiveData", "pageInfo", "Lcom/yy/hiyo/channel/component/setting/data/PageData;", "service", "Lcom/yy/hiyo/channel/base/service/IChannel;", "getBlackListData", "", "cid", "", "getBlackLiveData", "getNetErrorStatus", "removeBlack", "index", "", "uid", "callback", "Lcom/yy/hiyo/channel/component/setting/callback/IChannelBlackResetCallback;", "requestChannelSearchData", "isLoadMore", "Companion", "channel-components_release"})
public final class ChannelBlackListViewModel {
    private PageData pageInfo;
    private final MutableLiveData<Boolean> netErrorStatusLiveData = new MutableLiveData();
    private final MutableLiveData<Boolean> noMoreLiveData = new MutableLiveData();
    private final MutableLiveData<List<BlackMember>> blackLiveData = new MutableLiveData();
    private final long limitCount = Integer.MAX_VALUE;
    private IChannel service;
    private static final String TAG = "ChannelBlackListViewModel";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MutableLiveData<List<BlackMember>> getBlackLiveData() {
        return this.blackLiveData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getNetErrorStatus() {
        return this.netErrorStatusLiveData;
    }

    public final void getBlackListData(@NotNull String cid) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        if (this.service == null) {
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            this.service = iServiceManager != null && (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) != null ? iServiceManager.getChannel(cid) : null;
        }
        this.pageInfo = new PageData();
        this.requestChannelSearchData(cid, false);
    }

    private final void requestChannelSearchData(String cid, boolean isLoadMore) {
        if (!isLoadMore && !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            MLog.info((Object)TAG, (String)"requestChannelSearchData network error", (Object[])new Object[0]);
            this.netErrorStatusLiveData.setValue((Object)true);
            return;
        }
        if (isLoadMore) {
            PageData pageData = this.pageInfo;
            if (pageData == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
            }
            long l = pageData.getOffset();
            PageData pageData2 = this.pageInfo;
            if (pageData2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
            }
            if (l >= pageData2.getTotal()) {
                MLog.info((Object)TAG, (String)"requestChannelSearchData no more data", (Object[])new Object[0]);
                this.noMoreLiveData.setValue((Object)true);
                return;
            }
        }
        if (FP.empty((CharSequence)cid)) {
            this.netErrorStatusLiveData.setValue((Object)true);
            MLog.info((Object)TAG, (String)"requestChannelSearchData cid null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"requestChannelSearchData cid:%s", (Object[])new Object[]{cid});
        Page.Builder builder = new Page.Builder().limit(Long.valueOf(this.limitCount));
        PageData pageData = this.pageInfo;
        if (pageData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
        }
        Page.Builder builder2 = builder.offset(Long.valueOf(pageData.getOffset()));
        PageData pageData3 = this.pageInfo;
        if (pageData3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
        }
        Page.Builder builder3 = builder2.snap(Long.valueOf(pageData3.getSnap()));
        PageData pageData4 = this.pageInfo;
        if (pageData4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
        }
        Page page = builder3.total(Long.valueOf(pageData4.getTotal())).build();
        GetChannelBlackListReq req = new GetChannelBlackListReq.Builder().cid(cid).page(page).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetChannelBlackListRes>(this, cid){
            final /* synthetic */ ChannelBlackListViewModel this$0;
            final /* synthetic */ String $cid;

            public void onResponse(@NotNull GetChannelBlackListRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    PageData pageData = ChannelBlackListViewModel.access$getPageInfo$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    PageData $this$apply = pageData;
                    boolean bl3 = false;
                    Long l = message.page.offset;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"message.page.offset");
                    $this$apply.setOffset(l);
                    Long l2 = message.page.snap;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"message.page.snap");
                    $this$apply.setSnap(l2);
                    Long l3 = message.page.total;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"message.page.total");
                    $this$apply.setTotal(l3);
                    MLog.info((Object)"ChannelBlackListViewModel", (String)"requestChannelSearchData success, cid:%s, page:%s", (Object[])new Object[]{this.$cid, ChannelBlackListViewModel.access$getPageInfo$p(this.this$0)});
                    bl = false;
                    List memberList = new ArrayList<E>();
                    List list2 = message.user_info;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"message.user_info");
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        int n;
                        UserInfo it = (UserInfo)element$iv;
                        boolean bl4 = false;
                        BlackMember member = new BlackMember();
                        member.setBlack(true);
                        String string2 = it.avatar;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.avatar");
                        member.setAvatar(string2);
                        String string3 = it.birthday;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.birthday");
                        member.setBirthday(string3);
                        String string4 = it.last_login_location;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"it.last_login_location");
                        member.setLastLoginLocation(string4);
                        String string5 = it.nick;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"it.nick");
                        member.setNick(string5);
                        Long l4 = it.on_micro;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"it.on_micro");
                        member.setOnlineStatus(l4);
                        member.setSex((int)it.sex.longValue());
                        IChannel iChannel = ChannelBlackListViewModel.access$getService$p(this.this$0);
                        if (iChannel != null && (iChannel = iChannel.getRoleService()) != null) {
                            Long l5 = it.uid;
                            Intrinsics.checkExpressionValueIsNotNull((Object)l5, (String)"it.uid");
                            n = iChannel.getRoleCache(l5.longValue());
                        } else {
                            n = 5;
                        }
                        member.setRoleType(n);
                        Long l6 = it.uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l6, (String)"it.uid");
                        member.setUid(l6);
                        memberList.add(member);
                    }
                    ChannelBlackListViewModel.access$getBlackLiveData$p(this.this$0).setValue((Object)memberList);
                    MLog.info((Object)"ChannelBlackListViewModel", (String)"requestChannelSearchData success, cid:%s, data:%s", (Object[])new Object[]{this.$cid, memberList});
                } else {
                    MLog.info((Object)"ChannelBlackListViewModel", (String)"requestChannelSearchData fail, cid:%s, errorCode:%s", (Object[])new Object[]{this.$cid, code});
                    ChannelBlackListViewModel.access$getNetErrorStatusLiveData$p(this.this$0).setValue((Object)true);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ requestChannelSearchData.1 this$0;

                    public final void run() {
                        MLog.info((Object)"ChannelBlackListViewModel", (String)"requestChannelSearchData timeout, cid:%s", (Object[])new Object[]{this.this$0.$cid});
                        ChannelBlackListViewModel.access$getNetErrorStatusLiveData$p(this.this$0.this$0).setValue((Object)true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.info((Object)"ChannelBlackListViewModel", (String)"requestChannelSearchData fail, cid:%s, errorCode:%s", (Object[])new Object[]{this.$cid, code});
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(this){
                    final /* synthetic */ requestChannelSearchData.1 this$0;

                    public final void run() {
                        ChannelBlackListViewModel.access$getNetErrorStatusLiveData$p(this.this$0.this$0).setValue((Object)true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return false;
            }
            {
                this.this$0 = $outer;
                this.$cid = $captured_local_variable$1;
            }
        });
    }

    public final void removeBlack(int index, @NotNull String cid, long uid, @NotNull IChannelBlackResetCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)cid, (String)"cid");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        if (FP.empty((CharSequence)cid)) {
            MLog.info((Object)TAG, (String)"removeBlack cid null", (Object[])new Object[0]);
            return;
        }
        if (uid <= 0L) {
            MLog.info((Object)TAG, (String)"removeBlack uid null", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"removeBlack uid:%s, cid:%s", (Object[])new Object[]{uid, cid});
        ResetUserFromBlackListReq req = new ResetUserFromBlackListReq.Builder().cid(cid).uid(Long.valueOf(uid)).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<ResetUserFromBlackListRes>(uid, cid, callback2, index){
            final /* synthetic */ long $uid;
            final /* synthetic */ String $cid;
            final /* synthetic */ IChannelBlackResetCallback $callback;
            final /* synthetic */ int $index;

            public void onResponse(@NotNull ResetUserFromBlackListRes message, long code, @Nullable String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                super.onResponse((AndroidMessage)message, code, msg);
                if (ProtoManager.isSuccessCode((long)code)) {
                    MLog.info((Object)"ChannelBlackListViewModel", (String)"removeBlack success, uid:%s, cid:%s", (Object[])new Object[]{this.$uid, this.$cid});
                    this.$callback.onSuccess(this.$index);
                } else {
                    MLog.info((Object)"ChannelBlackListViewModel", (String)"removeBlack fail, uid:%s, cid:%s, errorCode:%s", (Object[])new Object[]{this.$uid, this.$cid, code});
                    this.$callback.onFail(code, msg);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)"ChannelBlackListViewModel", (String)"removeBlack timeout, uid:%s, cid:%s", (Object[])new Object[]{this.$uid, this.$cid});
                this.$callback.onFail(-1L, "timeout");
                return false;
            }

            public boolean retryWhenError(boolean canRetry, @Nullable String reason, int code) {
                MLog.info((Object)"ChannelBlackListViewModel", (String)"removeBlack fail, uid:%s, cid:%s, errorCode:%s", (Object[])new Object[]{this.$uid, this.$cid, code});
                this.$callback.onFail(code, reason);
                return false;
            }
            {
                this.$uid = $captured_local_variable$0;
                this.$cid = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
                this.$index = $captured_local_variable$3;
            }
        });
    }

    public static final /* synthetic */ PageData access$getPageInfo$p(ChannelBlackListViewModel $this) {
        PageData pageData = $this.pageInfo;
        if (pageData == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pageInfo");
        }
        return pageData;
    }

    public static final /* synthetic */ void access$setPageInfo$p(ChannelBlackListViewModel $this, PageData pageData) {
        $this.pageInfo = pageData;
    }

    public static final /* synthetic */ IChannel access$getService$p(ChannelBlackListViewModel $this) {
        return $this.service;
    }

    public static final /* synthetic */ void access$setService$p(ChannelBlackListViewModel $this, IChannel iChannel) {
        $this.service = iChannel;
    }

    public static final /* synthetic */ MutableLiveData access$getBlackLiveData$p(ChannelBlackListViewModel $this) {
        return $this.blackLiveData;
    }

    public static final /* synthetic */ MutableLiveData access$getNetErrorStatusLiveData$p(ChannelBlackListViewModel $this) {
        return $this.netErrorStatusLiveData;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/setting/viewmodel/ChannelBlackListViewModel$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

