/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.channel.R;
import java.util.Arrays;

public class StrokeTextView
extends YYTextView {
    private static final int HORIZENTAL = 0;
    private static final int VERTICAL = 1;
    private int[] mGradientColor;
    private int mStrokeWidth;
    private int mStrokeColor = -65536;
    private LinearGradient mGradient;
    private boolean gradientChanged;
    private int mTextColor;
    private TextPaint mPaint;
    private int mGradientOrientation;
    private boolean needStroke;

    public boolean isNeedStroke() {
        return this.needStroke;
    }

    public void setNeedStroke(boolean needStroke) {
        this.needStroke = needStroke;
        this.invalidate();
    }

    public StrokeTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public StrokeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StrokeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mPaint = this.getPaint();
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StrokeTextView);
            this.mStrokeColor = a.getColor(R.styleable.StrokeTextView_stv_strokeColor, -16777216);
            this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.StrokeTextView_stv_strokeWidth, 0);
            this.mGradientOrientation = a.getInt(R.styleable.StrokeTextView_stv_gradientOrientation, 0);
            this.setStrokeColor(this.mStrokeColor);
            this.setStrokeWidth(this.mStrokeWidth);
            this.setGradientOrientation(this.mGradientOrientation);
            a.recycle();
        }
    }

    public void setGradientOrientation(int orientation) {
        if (this.mGradientOrientation != orientation) {
            this.mGradientOrientation = orientation;
            this.gradientChanged = true;
            this.invalidate();
        }
    }

    public void setGradientColor(int[] gradientColor) {
        if (!Arrays.equals(gradientColor, this.mGradientColor)) {
            this.mGradientColor = gradientColor;
            this.gradientChanged = true;
            this.invalidate();
        }
    }

    public void setStrokeColor(int color2) {
        if (this.mStrokeColor != color2) {
            this.mStrokeColor = color2;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mStrokeWidth > 0 && this.needStroke) {
            this.mTextColor = this.getCurrentTextColor();
            this.mPaint.setStrokeWidth((float)this.mStrokeWidth);
            this.mPaint.setFakeBoldText(true);
            this.mPaint.setShadowLayer((float)this.mStrokeWidth, 0.0f, 0.0f, 0);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.setColor(this.mStrokeColor);
            this.mPaint.setShader(null);
            super.onDraw(canvas);
            if (this.gradientChanged) {
                if (this.mGradientColor != null) {
                    this.mGradient = this.getGradient();
                }
                this.gradientChanged = false;
            }
            if (this.mGradient != null) {
                this.mPaint.setShader((Shader)this.mGradient);
                this.mPaint.setColor(-1);
            } else {
                this.setColor(this.mTextColor);
            }
            this.mPaint.setStrokeWidth(0.0f);
            this.mPaint.setShadowLayer(0.0f, 0.0f, 0.0f, 0);
        }
        super.onDraw(canvas);
    }

    public void setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        this.invalidate();
    }

    private LinearGradient getGradient() {
        LinearGradient gradient = this.mGradientOrientation == 0 ? new LinearGradient(0.0f, 0.0f, (float)this.getWidth(), 0.0f, this.mGradientColor, null, Shader.TileMode.CLAMP) : new LinearGradient(0.0f, 0.0f, 0.0f, (float)this.getHeight(), this.mGradientColor, null, Shader.TileMode.CLAMP);
        return gradient;
    }

    private void setColor(int color2) {
        this.setTextColor(color2);
    }
}

