/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.seattip;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.widget.bubble.BubblePopupWindowManager;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.base.service.ISeatService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.seattip.FirstTimeInviteBubbleStrategy;
import com.yy.hiyo.channel.component.seat.seattip.PeopleEnterRoomBubbleStrategy;
import com.yy.hiyo.channel.component.seat.seattip.SeatTipStrategy;
import com.yy.hiyo.channel.component.seat.seattip.ShortTipUidBubbleStrategy;
import com.yy.hiyo.channel.component.seat.seattip.ShowTipsUidBubbleStrategy;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakRunnable;

public class SeatTipsPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private static final String TAG = "SeatTipsPresenter";
    private boolean isCheck = false;

    public void onPageAttach(@NonNull AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!this.isCheck) {
            this.isCheck = true;
            YYTaskExecutor.postToMainThread((Runnable)WeakRunnable.of((IDestroyable)this, this::beginToCheck));
        }
    }

    private void beginToCheck() {
        SeatTipStrategy[] sequenceStrategyChain;
        for (SeatTipStrategy strategy : sequenceStrategyChain = new SeatTipStrategy[]{new FirstTimeInviteBubbleStrategy(this), new ShowTipsUidBubbleStrategy(this), new PeopleEnterRoomBubbleStrategy(this), new ShortTipUidBubbleStrategy(this)}) {
            if (strategy.resolve()) break;
        }
    }

    public boolean showTipsByUidNow(long showTipsUid, String strTips) {
        return this.showTipsByUidNow(showTipsUid, strTips, 4);
    }

    public boolean showTipsByUidNow(long showTipsUid, String strTips, int textAlignment) {
        if (showTipsUid <= 0L) {
            MLog.info((Object)TAG, (String)"show tip uid less and equal 0, return.", (Object[])new Object[0]);
            return false;
        }
        SeatPresenter seatPresenter = (SeatPresenter)this.getPresenter(SeatPresenter.class);
        ISeatService seatService2 = this.getChannel().getSeatService();
        if (seatService2.isInSeat(showTipsUid) && seatPresenter != null) {
            return this.showTipsByIndexNow(seatService2.getSeatIndex(showTipsUid) - 1, strTips, textAlignment);
        }
        return false;
    }

    public boolean showTipsByIndexNow(int index, String strTips) {
        return this.showTipsByIndexNow(index, strTips, 4);
    }

    public boolean showTipsByIndexNow(int index, String strTips, int textAlignment) {
        SeatPresenter seatPresenter = (SeatPresenter)this.getPresenter(SeatPresenter.class);
        if (seatPresenter != null) {
            View seatView = seatPresenter.getItemView(index);
            if (seatView == null) {
                MLog.info((Object)TAG, (String)("seat View is null. index:" + index), (Object[])new Object[0]);
                return false;
            }
            int relate = 1;
            if (null != this.getChannel().getPluginService() && this.getChannel().getPluginService().getCurPluginData().mode == 300) {
                relate = 2;
            }
            BubblePopupWindowManager.showTopRightArrow((View)seatView, (Context)((IChannelPageContext)this.getMvpContext()).getContext(), (String)strTips, (int)ColorUtils.parseColor((String)"#fec200"), (long)3000L, (int)0, (int)ResolutionUtils.dip2Px((float)5.0f), (int)textAlignment, (int)relate);
            return true;
        }
        return false;
    }

    public boolean showTipsByIndexQueue() {
        return false;
    }
}

