/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.seat.bean;

import androidx.annotation.Keep;
import com.yy.base.utils.FP;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@Keep
public class SeatDataHolder {
    public boolean isOwnerOnline;
    public volatile List<Long> uidList;
    public volatile List<Long> statusList;

    public SeatDataHolder(boolean isOwnerOnline, List<Long> uidList, List<Long> statusList) {
        this.isOwnerOnline = isOwnerOnline;
        this.uidList = FP.empty(uidList) ? Collections.emptyList() : uidList;
        this.statusList = FP.empty(statusList) ? Collections.emptyList() : statusList;
    }

    public static boolean isEqual(@Nonnull SeatDataHolder from, @Nonnull SeatDataHolder to) {
        if (from == to) {
            return true;
        }
        return from.isOwnerOnline == to.isOwnerOnline && from.uidList.equals(to.uidList) && from.statusList.equals(to.statusList);
    }

    public void update(SeatDataHolder holder) {
        this.isOwnerOnline = holder.isOwnerOnline;
        this.uidList = holder.uidList;
        this.statusList = holder.statusList;
    }

    public String toString() {
        return "SeatDataHolder{, isOwnerOnline=" + this.isOwnerOnline + ", uidList=" + this.uidList + ", statusList=" + this.statusList + '}';
    }
}

