/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.roompush.notify;

import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.component.roompush.bean.RoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.SvgaPushBean;
import com.yy.hiyo.channel.component.roompush.callback.INotifyHandlerCallback;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import net.ihago.money.api.broadcast.BroadCastMsgType;
import net.ihago.money.api.broadcast.BroadCastPayloadType;
import net.ihago.money.api.broadcast.BroadCastUri;
import net.ihago.money.api.broadcast.MoneyBroadCast;
import net.ihago.money.api.broadcast.SvgaBroadCast;
import org.json.JSONException;
import org.json.JSONObject;

public class RoomPushNotifyHandler
implements INotifyDispatchService.INotifyHandler {
    private INotifyHandlerCallback mCallback;

    public void setOnNotifyHandlerCallback(INotifyHandlerCallback callback2) {
        this.mCallback = callback2;
    }

    public void onHandleNotify(Object notify2) {
        if (notify2 instanceof MoneyBroadCast) {
            MoneyBroadCast broadCast = (MoneyBroadCast)notify2;
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"\u6536\u5230\u5168\u670d\u5e7f\u64ad uri: %s", (Object[])new Object[]{broadCast.getUriValue()});
            String msg = "";
            String payload = "";
            SvgaBroadCast svgaBroadCast = null;
            if (broadCast.uri == BroadCastUri.kUriRoomIdOnline) {
                if (broadCast.roomid_online != null) {
                    msg = broadCast.roomid_online.msg;
                    payload = broadCast.roomid_online.broadcast_payload;
                    this.onReceiveOldPush(msg, payload);
                }
            } else if (broadCast.uri == BroadCastUri.kUriAllRoomOnline) {
                if (broadCast.all_room_online != null) {
                    msg = broadCast.all_room_online.msg;
                    payload = broadCast.all_room_online.broadcast_payload;
                    this.onReceiveOldPush(msg, payload);
                }
            } else if (broadCast.uri == BroadCastUri.kUriSvgaBroadCast) {
                svgaBroadCast = broadCast.svga_broadcast;
                this.onReceiveNewPush(svgaBroadCast);
            }
        }
    }

    private void onReceiveNewPush(SvgaBroadCast svgaBroadCast) {
        if (null != this.mCallback && svgaBroadCast != null) {
            this.mCallback.onReceivePush(SvgaPushBean.Companion.of(svgaBroadCast));
        }
    }

    private void onReceiveOldPush(String msg, String payload) {
        if (StringUtils.isEmpty((String)msg)) {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"notify, msg \u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        RoomPushBean.Builder builder = new RoomPushBean.Builder();
        boolean isParseSucess = this.parseMsg(msg, builder);
        if (!isParseSucess) {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"add push something wrong", (Object[])new Object[0]);
            return;
        }
        this.parsePayload(payload, builder);
        if (null != this.mCallback) {
            this.mCallback.onReceivePush(builder.build());
        }
    }

    private boolean parseMsg(String msg, RoomPushBean.Builder builder) {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"notify, msg: %s", (Object[])new Object[]{msg});
        try {
            JSONObject msgJson = JsonParser.obtainJSONObject((String)msg);
            int type = msgJson.optInt("type");
            if (type == BroadCastMsgType.kBroadCastMsgTxt.getValue()) {
                builder.type(1);
            } else if (type == BroadCastMsgType.kBroadCastMsgUserInfo.getValue()) {
                builder.type(2);
                this.praseUserInfo(builder, msgJson);
            } else if (type == BroadCastMsgType.kBroadCastMsgSvga.getValue()) {
                builder.type(4);
                this.praseSvga(builder, msgJson);
            } else if (type == BroadCastMsgType.kBroadCastMsgTxtCenter.getValue()) {
                builder.type(5);
            } else if (type == BroadCastMsgType.kBroadCastMsgSvgaUserInfo.getValue()) {
                builder.type(6);
                this.praseSvga(builder, msgJson);
                this.praseUserInfo(builder, msgJson);
            } else {
                FeatureLog.e((String)"FTVoiceRoomPush", (String)"notify, no match type", (Object[])new Object[0]);
                return false;
            }
            if (msgJson.has("lang_msg")) {
                JSONObject langJson = msgJson.optJSONObject("lang_msg");
                builder.color(langJson.optString("color", ""));
                builder.bgUrl(langJson.optString("background_url", ""));
                builder.content(langJson.optString("msg", ""));
                builder.mirrorUrl(langJson.optString("mirror_url", ""));
                builder.bgSvgaUrl(langJson.optString("background_svga", ""));
                builder.textSize(langJson.optInt("size", 13));
            }
            return true;
        }
        catch (JSONException e) {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"notify msg \u89e3\u6790\u9519\u8bef", (Object[])new Object[0]);
            return false;
        }
    }

    private void praseUserInfo(RoomPushBean.Builder builder, JSONObject msgJson) {
        if (msgJson.has("user_info")) {
            JSONObject userJson = msgJson.optJSONObject("user_info");
            builder.nick(userJson.optString("nick", ""));
            builder.avatar(userJson.optString("avatar", ""));
            builder.headFrameId(userJson.optString("head_frame_id", ""));
        }
    }

    private void praseSvga(RoomPushBean.Builder builder, JSONObject msgJson) {
        if (msgJson.has("svga_url")) {
            builder.svgaUrl(msgJson.optString("svga_url"));
        }
    }

    private void parsePayload(String payload, RoomPushBean.Builder builder) {
        if (StringUtils.isEmpty((String)payload)) {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"notify, payload \u4e3a\u7a7a", (Object[])new Object[0]);
            return;
        }
        try {
            JSONObject payloadJson = JsonParser.obtainJSONObject((String)payload);
            int type = payloadJson.optInt("type", -1);
            builder.broadcastSource(payloadJson.optString("broadcast_source", ""));
            builder.payloadType(type);
            if (type == BroadCastPayloadType.kBroadCastPayloadWebJump.getValue()) {
                if (payloadJson.has("web_jump")) {
                    JSONObject webJson = payloadJson.optJSONObject("web_jump");
                    builder.jumpUrl(webJson.optString("url", ""));
                }
            } else if (type == BroadCastPayloadType.kBroadCastPayloadVoiceChatInvite.getValue() && payloadJson.has("voice_chat")) {
                JSONObject roomJson = payloadJson.optJSONObject("voice_chat");
                builder.jumpRoomid(roomJson.optString("room_id", ""));
            }
        }
        catch (JSONException e) {
            FeatureLog.e((String)"FTVoiceRoomPush", (String)"notify payload \u89e3\u6790\u9519\u8bef", (Object[])new Object[0]);
        }
    }
}

