/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.roompush.itemview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.opensource.svgaplayer.hago.SVGAVideoEntity;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.roompush.bean.RoomPushBean;
import com.yy.hiyo.channel.component.roompush.callback.IItemViewCallback;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;

public class TypeGiftView
extends YYLinearLayout
implements View.OnClickListener {
    private Context mContext;
    private RecycleImageView mBgIv;
    private SVGAImageView mBgSvga;
    private CircleImageView mSenderAvatar;
    private YYTextView mSenderTv;
    private YYTextView mReceiverTv;
    private RecycleImageView mGiftIv;
    private YYTextView mCountTv;
    private RoomPushBean mBean;
    private CircleImageView receiverHeader;
    private CircleImageView receiverHeader2;
    private CircleImageView receiverHeader3;
    private IItemViewCallback mCallback;
    private List<CircleImageView> receiverViews = new ArrayList<CircleImageView>();

    public TypeGiftView(Context context, RoomPushBean bean2, IItemViewCallback callback2) {
        super(context);
        this.mContext = context;
        this.mBean = bean2;
        this.mCallback = callback2;
        this.createView();
    }

    private void createView() {
        TypeGiftView.inflate((Context)this.mContext, (int)R.layout.layout_roompush_type_gift_channel, (ViewGroup)this);
        this.mSenderAvatar = (CircleImageView)this.findViewById(R.id.iv_sender);
        this.mSenderTv = (YYTextView)this.findViewById(R.id.tv_sender);
        this.receiverHeader = (CircleImageView)this.findViewById(R.id.header_receiver);
        this.receiverHeader2 = (CircleImageView)this.findViewById(R.id.header_receiver2);
        this.receiverHeader3 = (CircleImageView)this.findViewById(R.id.header_receiver3);
        this.mReceiverTv = (YYTextView)this.findViewById(R.id.tv_receiver);
        this.mGiftIv = (RecycleImageView)this.findViewById(R.id.iv_gift);
        this.mCountTv = (YYTextView)this.findViewById(R.id.tv_count);
        this.receiverViews.add(this.receiverHeader);
        this.receiverViews.add(this.receiverHeader2);
        this.receiverViews.add(this.receiverHeader3);
        this.findViewById(R.id.root).setOnClickListener((View.OnClickListener)this);
        this.setData();
    }

    public void setData() {
        this.mBgIv = (RecycleImageView)this.findViewById(R.id.iv_bg);
        this.mBgSvga = (SVGAImageView)this.findViewById(R.id.svga_bg);
        if (this.mBean == null) {
            return;
        }
        if (this.mBean.getBgUrlType() == 2) {
            if (this.mBgSvga != null) {
                SvgaLoader.load((SVGAImageView)this.mBgSvga, (String)this.mBean.getBgUrl(), (ISvgaLoadCallback)new ISvgaLoadCallback(){

                    public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                        TypeGiftView.this.mBgSvga.startAnimation();
                        if (TypeGiftView.this.mBgIv != null) {
                            TypeGiftView.this.mBgIv.setVisibility(8);
                        }
                    }

                    public void onFailed(Exception e) {
                    }
                });
            }
        } else if (this.mBgIv != null) {
            this.mBgIv.setVisibility(0);
            ImageLoader.loadImage((ImageView)this.mBgIv, (String)(this.mBean.getBgUrl() + YYImageUtils.getThumbnailPostfix((int)320)));
        }
        this.loadHeader(this.mBean.getSendUid(), (RecycleImageView)this.mSenderAvatar);
        ImageLoader.loadImage((ImageView)this.mGiftIv, (String)(this.mBean.getGiftUrl() + YYImageUtils.getThumbnailPostfix((int)30)));
        if (this.mBean.getRecvUids() != null && this.mBean.getRecvUids().size() > 0) {
            for (int i = 0; i < this.mBean.getRecvUids().size(); ++i) {
                long uid = this.mBean.getRecvUids().get(i);
                if (i >= this.receiverViews.size()) break;
                this.loadHeader(uid, (RecycleImageView)this.receiverViews.get(i));
                this.receiverViews.get(i).setVisibility(0);
            }
        }
        this.mSenderTv.setText((CharSequence)this.mBean.getNick());
        String recvNick = this.mBean.getReceiverNick();
        if (this.mBean.getRecvUids() != null && this.mBean.getRecvUids().size() > 1) {
            recvNick = ResourceUtils.getString((int)R.string.tips_recv_all);
        }
        this.mReceiverTv.setText((CharSequence)recvNick);
        this.mCountTv.setText((CharSequence)("x" + String.valueOf(this.mBean.getGiftCount())));
    }

    private void loadHeader(long uid, final RecycleImageView imageView) {
        if (uid <= 0L || ServiceManagerProxy.getServiceManager() == null || ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class) == null) {
            return;
        }
        ((IUserInfoService)ServiceManagerProxy.getServiceManager().getService(IUserInfoService.class)).getUserInfo(uid, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfo) {
                if (FP.empty(userInfo)) {
                    return;
                }
                UserInfoBean use = userInfo.get(0);
                ImageLoader.loadImage((ImageView)imageView, (String)(use.getAvatar() + YYImageUtils.getThumbnailPostfix((int)20)), (int)AvatarUtils.getDefaultAvatar((int)use.getSex()));
            }

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponseError(int id2, String message, String response) {
            }
        });
    }

    public void onClick(View v) {
        if (v.getId() == R.id.root && null != this.mCallback) {
            this.mCallback.onClickItem(this.mBean);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mCallback = null;
    }
}

