/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.roompush.itemview;

import android.content.Context;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.headframe.HeadFrameImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.roompush.bean.RoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.TextHighLightConfig;
import com.yy.hiyo.channel.component.roompush.callback.IItemViewCallback;
import com.yy.hiyo.channel.component.roompush.itemview.BasePushView;
import net.ihago.money.api.broadcast.BroadCastPayloadType;

public class Type2View
extends BasePushView
implements View.OnClickListener {
    private Context mContext;
    private YYTextView mContentTv;
    private YYImageView mArrowIv;
    private HeadFrameImageView mAvatarIv;
    private RecycleImageView leftImg;
    private RoomPushBean mBean;
    private IItemViewCallback mCallback;

    public Type2View(Context context, RoomPushBean bean2, IItemViewCallback callback2) {
        super(context, bean2);
        this.mContext = context;
        this.mBean = bean2;
        this.mCallback = callback2;
        this.createView();
    }

    private void createView() {
        Type2View.inflate((Context)this.mContext, (int)this.getLayoutId(), (ViewGroup)this);
        this.mContentTv = (YYTextView)this.findViewById(R.id.tv_content);
        this.mArrowIv = (YYImageView)this.findViewById(R.id.iv_arrow);
        this.leftImg = (RecycleImageView)this.findViewById(R.id.left_img);
        this.mAvatarIv = (HeadFrameImageView)this.findViewById(R.id.iv_avatar);
        this.findViewById(R.id.root).setOnClickListener((View.OnClickListener)this);
        this.setData();
    }

    public int getLayoutId() {
        return R.layout.layout_roompush_type_2_channel;
    }

    @Override
    public void setData() {
        super.setData();
        if (this.mBean == null) {
            return;
        }
        if (this.mBean.getPayloadType() == BroadCastPayloadType.kBroadCastPayloadWebJump.getValue() || this.mBean.getPayloadType() == BroadCastPayloadType.kBroadCastPayloadVoiceChatInvite.getValue()) {
            this.mArrowIv.setVisibility(0);
        } else {
            this.mArrowIv.setVisibility(8);
        }
        if (this.mBean.getTextHighLightConfig() == null) {
            int bgColor = ColorUtils.parseColor((String)"#ffffff");
            if (!StringUtils.isEmpty((String)this.mBean.getColor())) {
                bgColor = ColorUtils.parseColor((String)this.mBean.getColor());
            }
            this.mContentTv.setTextColor(bgColor);
            String content = this.mBean.getContent();
            String nick = this.mBean.getNick();
            int index = -1;
            int length = 0;
            if (!TextUtils.isEmpty((CharSequence)nick) && !TextUtils.isEmpty((CharSequence)content)) {
                index = content.indexOf(nick);
                length = nick.length();
            }
            if (index != -1 && length > 0) {
                SpannableString spannableString = new SpannableString((CharSequence)content);
                spannableString.setSpan((Object)new ForegroundColorSpan(ColorUtils.parseColor((String)"#FAFE00")), index, index + length, 17);
                this.mContentTv.setText((CharSequence)spannableString);
            } else {
                this.mContentTv.setText((CharSequence)content);
            }
        } else {
            this.textHighLight(this.mBean.getTextHighLightConfig());
        }
        if (TextUtils.isEmpty((CharSequence)this.mBean.getLeftImgUrl())) {
            ImageLoader.loadImage((ImageView)this.mAvatarIv.getCircleImageView(), (String)(this.mBean.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)));
        } else {
            ImageLoader.loadImage((ImageView)this.leftImg, (String)(this.mBean.getLeftImgUrl() + YYImageUtils.getThumbnailPostfix((int)75)));
        }
        this.mContentTv.setSelected(true);
        int id2 = StringUtils.parseInt((String)this.mBean.getHeadFrameId());
        if (id2 > 0) {
            this.mAvatarIv.setHeadFrame(((IHonorService)ServiceManagerProxy.getServiceManager().getService(IHonorService.class)).getHeadFrameUrlFromCache(id2));
        }
    }

    private void textHighLight(TextHighLightConfig textHighLightConfig) {
        if (textHighLightConfig == null) {
            return;
        }
        String tipTxt = textHighLightConfig.getText();
        if (textHighLightConfig.getTextHighLights() != null && !textHighLightConfig.getTextHighLights().isEmpty()) {
            SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)tipTxt);
            for (TextHighLightConfig.TextHighLight textHighLight : textHighLightConfig.getTextHighLights()) {
                int start;
                String replace = textHighLight.getKey();
                String value = textHighLight.getValue();
                if (TextUtils.isEmpty((CharSequence)replace) || TextUtils.isEmpty((CharSequence)value) || (start = tipTxt.indexOf(replace)) < 0) continue;
                spannableString.replace(start, start + replace.length(), (CharSequence)value);
                spannableString.setSpan((Object)new ForegroundColorSpan(ColorUtils.parseColor((String)textHighLight.getColor())), start, start + value.length(), 17);
            }
            if (!TextUtils.isEmpty((CharSequence)spannableString)) {
                this.mContentTv.setText((CharSequence)spannableString);
                if (!TextUtils.isEmpty((CharSequence)textHighLightConfig.getTextColor())) {
                    this.mContentTv.setTextColor(ColorUtils.parseColor((String)textHighLightConfig.getTextColor()));
                }
                if (textHighLightConfig.getTextSize() != 10) {
                    this.mContentTv.setTextSize((float)textHighLightConfig.getTextSize());
                }
            }
        } else {
            this.mContentTv.setText((CharSequence)tipTxt);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.root && null != this.mCallback) {
            this.mCallback.onClickItem(this.mBean);
        }
    }
}

