/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.roompush;

import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageLifeCycle;
import com.yy.hiyo.channel.component.roompush.RoomPushMvp;
import com.yy.hiyo.channel.component.roompush.RoomPushUtils;
import com.yy.hiyo.channel.component.roompush.RoomPushView;
import com.yy.hiyo.channel.component.roompush.bean.BaseRoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.RoomPushBean;
import com.yy.hiyo.channel.component.roompush.bean.SvgaPushBean;
import com.yy.hiyo.channel.component.roompush.callback.INotifyHandlerCallback;
import com.yy.hiyo.channel.component.roompush.notify.RoomPushNotifyDispatchService;
import com.yy.hiyo.channel.component.roompush.notify.RoomPushNotifyHandler;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.webservice.WebEnvSettings;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import net.ihago.money.api.broadcast.BroadCastPayloadType;
import org.jetbrains.annotations.NotNull;

public class ChannelPushPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements RoomPushMvp.IPresenter,
RoomPushView.OnUILintener,
INotifyHandlerCallback,
IPageLifeCycle {
    private static final long PUSH_SHOWING_TIME = 4000L;
    private RoomPushView mView;
    private IMvpContext mMvpContext;
    private Queue<BaseRoomPushBean> pushQueue = new PriorityBlockingQueue<BaseRoomPushBean>();
    private YYFrameLayout pushLayer;
    private boolean isViewShowing = false;
    private RoomPushNotifyHandler mNotifyHandler;
    private RoomPushNotifyDispatchService mDispatchService;
    private boolean isMinimized = false;
    private Runnable hideTask = () -> this.hide(!this.isMinimized && RuntimeContext.sIsForeground);

    public void onInit(IChannelPageContext mvpContext) {
        super.onInit(mvpContext);
        this.mMvpContext = mvpContext;
        this.mDispatchService = new RoomPushNotifyDispatchService(this.getChannel().getChannelId());
        this.mNotifyHandler = new RoomPushNotifyHandler();
        this.mNotifyHandler.setOnNotifyHandlerCallback(this);
        this.mDispatchService.addHandler(this.mNotifyHandler);
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mDispatchService);
    }

    @Override
    public void addRoomPush(BaseRoomPushBean bean2) {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"add push, type: %s", (Object[])new Object[]{bean2.getType()});
        if (this.isDestroyed()) {
            MLog.error((Object)"FTVoiceRoomPush", (String)"addRoomPush presenter had destroy", (Object[])new Object[0]);
            return;
        }
        if (this.getChannel().getPluginService().getCurPluginData().mode == 1) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"add push but in Base Mode", (Object[])new Object[0]);
            return;
        }
        if (this.isMinimized || !RuntimeContext.sIsForeground) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"add push but wrong time. isMinimized: %s, sIsForeground: %s", (Object[])new Object[]{this.isMinimized, RuntimeContext.sIsForeground});
            return;
        }
        this.pushQueue.offer(bean2);
        this.next();
    }

    private synchronized void next() {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"try show, queue size: %s, isViewShowing: %b", (Object[])new Object[]{this.pushQueue.size(), this.isViewShowing});
        if (this.pushQueue.size() <= 0) {
            return;
        }
        if (!this.isViewShowing) {
            BaseRoomPushBean bean2 = this.pushQueue.poll();
            if (null != bean2) {
                if (!RoomPushUtils.isContainsType(bean2.getType())) {
                    FeatureLog.e((String)"FTVoiceRoomPush", (String)"no match type", (Object[])new Object[0]);
                    this.next();
                    return;
                }
                if (null == this.mView) {
                    this.mView = new RoomPushView(this.mMvpContext.getContext(), this.getRoomPushViewGroup());
                    this.mView.setRoomId(this.getChannel().getChannelId());
                    this.mView.setPresenter(this);
                    this.mView.setOnUIListener(this);
                }
                this.mView.show(bean2);
                if (bean2.getType() != 4 && bean2.getType() != 6 && bean2.getType() != 8) {
                    YYTaskExecutor.postToMainThread((Runnable)this.hideTask, (long)4000L);
                }
            } else {
                this.next();
            }
        }
    }

    private ViewGroup getRoomPushViewGroup() {
        if (this.pushLayer == null) {
            this.pushLayer = new YYFrameLayout(this.mMvpContext.getContext());
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            RelativeLayout layer = this.getWindow().getExtLayer();
            if (layer.getChildCount() > 0) {
                layer.addView((View)this.pushLayer, 1, lp);
            } else {
                layer.addView((View)this.pushLayer, lp);
            }
        }
        return this.pushLayer;
    }

    private void hide(boolean hasAnim) {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"try hide", (Object[])new Object[0]);
        if (null != this.mView && this.isViewShowing) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"hiding", (Object[])new Object[0]);
            this.mView.hide(hasAnim);
        }
    }

    @Override
    public void viewStatusChanged(boolean isShowing) {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"viewStatusChanged isShowing: %s, queueSize: %s", (Object[])new Object[]{isShowing, this.pushQueue.size()});
        this.isViewShowing = isShowing;
        if (!isShowing) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.hideTask);
            if (!this.pushQueue.isEmpty()) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChannelPushPresenter.this.next();
                    }
                }, (long)200L);
            }
        }
    }

    @Override
    public void onReceivePush(@NotNull BaseRoomPushBean bean2) {
        this.addRoomPush(bean2);
    }

    public void onClickItem(RoomPushBean bean2) {
        if (bean2.getPayloadType() == BroadCastPayloadType.kBroadCastPayloadWebJump.getValue()) {
            if (null != this.getMvpContext() && null != ((IChannelPageContext)this.getMvpContext()).getServiceManager()) {
                WebEnvSettings webEnvSettings = new WebEnvSettings();
                webEnvSettings.url = bean2.getJumpUrl();
                ((IWebService)((IChannelPageContext)this.getMvpContext()).getServiceManager().getService(IWebService.class)).loadUrl(webEnvSettings);
            }
        } else if (bean2.getPayloadType() == BroadCastPayloadType.kBroadCastPayloadVoiceChatInvite.getValue()) {
            EnterParam param2 = EnterParam.of((String)bean2.getJumpRoomid()).entry(18).entryInfo(new EntryInfo(FirstEntType.SUB_WINDOW, "1", null)).build();
            ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param2);
        } else {
            return;
        }
        RoomTrack.INSTANCE.reportBroadcastClick(this.getChannel().getChannelId(), String.valueOf(bean2.getType()));
    }

    public void onClickItem(SvgaPushBean svgaPushBean) {
        if (svgaPushBean == null || svgaPushBean.getJumpData() == null) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"onClickItem svga jumpdata is null", (Object[])new Object[0]);
            return;
        }
        if (svgaPushBean.getJumpData().getJumpType() == 1) {
            EnterParam param2 = EnterParam.of((String)svgaPushBean.getJumpData().getJumpUrl()).entry(18).entryInfo(new EntryInfo(FirstEntType.SUB_WINDOW, "1", null)).build();
            ((IRoomService)ServiceManagerProxy.getServiceManager().getService(IRoomService.class)).enterRoom(param2);
        } else if (svgaPushBean.getJumpData().getJumpType() == 2) {
            ((IYYUriService)ServiceManagerProxy.getServiceManager().getService(IYYUriService.class)).handleUriString(svgaPushBean.getJumpData().getJumpUrl());
        }
    }

    public void onAttach() {
        if (this.getPage().isPageVisible()) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"onMiniResume", (Object[])new Object[0]);
            this.isMinimized = false;
        }
    }

    public void onShown() {
        if (this.getPage().isPageVisible()) {
            FeatureLog.i((String)"FTVoiceRoomPush", (String)"onMiniResume", (Object[])new Object[0]);
            this.isMinimized = false;
        }
    }

    public void onHidden() {
        this.isMinimized = true;
        this.pushQueue.clear();
    }

    public void onDetach() {
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"onMinimized", (Object[])new Object[0]);
        this.isMinimized = true;
        this.pushQueue.clear();
    }

    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTVoiceRoomPush", (String)"onDestroy", (Object[])new Object[0]);
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.hideTask);
        this.hide(false);
        ((IChannelPageContext)this.getMvpContext()).getPageLifeDispatcher().removeLifeListener((IPageLifeCycle)this);
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mDispatchService);
        this.mDispatchService.removeHandler(this.mNotifyHandler);
        this.mView = null;
    }
}

