/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.wallet.base.giftbox.GiftSweepImageView;

public class ProfileCardButton
extends YYRelativeLayout {
    private RecycleImageView mIconView;
    private YYTextView mTextView;
    private GiftSweepImageView sweep;

    public ProfileCardButton(Context context) {
        super(context);
        this.createView(context);
    }

    public ProfileCardButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public ProfileCardButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(@NonNull Context context) {
        ProfileCardButton.inflate((Context)context, (int)R.layout.layout_profile_card_button_channel, (ViewGroup)this);
        this.sweep = (GiftSweepImageView)this.findViewById(R.id.sweep_img);
        this.mIconView = (RecycleImageView)this.findViewById(R.id.iv_icon);
        this.mTextView = (YYTextView)this.findViewById(R.id.tv_text);
        ClickScaleAnimProvider.apply((View)this);
    }

    public void startSweepTransAnim(boolean isSelf) {
        this.sweep.initAndStartRepeatTranslation(-1, ResolutionUtils.dip2Px((float)168.0f));
        RoomTrack.INSTANCE.onVoiceChatProfileCardAnimShow(isSelf);
    }

    @UiThread
    public void updateBackground(@DrawableRes int drawableShape) {
        this.setBackgroundResource(drawableShape);
    }

    @UiThread
    public void updateIcon(@DrawableRes int drawableIcon) {
        if (this.mIconView != null) {
            this.mIconView.setBackgroundResource(drawableIcon);
        }
    }

    @UiThread
    public void updateText(@ColorRes int textColor, @StringRes int text) {
        if (this.mTextView != null) {
            this.mTextView.setTextColor(ResourceUtils.getColor((int)textColor));
            this.mTextView.setText((CharSequence)ResourceUtils.getString((int)text));
        }
    }

    public void removeSweepAnim() {
        this.sweep.cancelTransAnim();
    }

    public void setTextSize(int textSize) {
        if (this.mTextView != null) {
            this.mTextView.setTextSize((float)textSize);
        }
    }

    public void setBoldStyle() {
        if (this.mTextView != null) {
            this.mTextView.setTypeface(Typeface.DEFAULT_BOLD);
        }
    }
}

