/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.profile.profilecard.widget;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;

public class ProfileCardBrowserView
extends YYConstraintLayout {
    private YYTextView mNumberView;
    private RecycleImageView mLeftIcon;
    private YYTextView mTextView;
    private int numberDigitsAfterPoint = 1;
    @DrawableRes
    private int mNumberRightIcon;
    private boolean mIsLevelPattern = false;

    public ProfileCardBrowserView(Context context) {
        super(context);
        this.createView(context);
    }

    public ProfileCardBrowserView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public ProfileCardBrowserView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        ProfileCardBrowserView.inflate((Context)context, (int)R.layout.layout_profile_card_browser_view_channel, (ViewGroup)this);
        this.mNumberView = (YYTextView)this.findViewById(R.id.tv_value);
        FontUtils.setFontType((TextView)this.mNumberView, (Typeface)FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.HagoNumber));
        this.mTextView = (YYTextView)this.findViewById(R.id.tv_title);
        this.mLeftIcon = (RecycleImageView)this.findViewById(R.id.iv_medal);
        this.mLeftIcon.setVisibility(8);
    }

    @UiThread
    public void updateNumber(long number) {
        if (this.mNumberView != null) {
            String formatNumber = StringUtils.getFormatedNumber((long)number, (int)this.numberDigitsAfterPoint);
            this.mNumberView.setText((CharSequence)(this.mIsLevelPattern ? "LV.".concat(formatNumber) : formatNumber));
            this.setLeftIconWhenNotEmptyText(this.mNumberRightIcon);
        }
    }

    @UiThread
    public void updateVIPNumber(long number) {
        if (this.mNumberView != null) {
            String formatNumber = StringUtils.getFormatedNumber((long)number, (int)this.numberDigitsAfterPoint);
            this.mNumberView.setText((CharSequence)(this.mIsLevelPattern ? "vip.".concat(formatNumber) : formatNumber));
            this.setLeftIconWhenNotEmptyText(this.mNumberRightIcon);
        }
    }

    @UiThread
    public void updateTitle(@StringRes int stringRes) {
        if (this.mTextView != null) {
            this.mTextView.setText(stringRes);
        }
    }

    @UiThread
    public void updateTitle(String title) {
        if (this.mTextView != null) {
            this.mTextView.setText((CharSequence)title);
        }
    }

    public void setBg(Drawable drawable2) {
        this.setBackground(drawable2);
    }

    public void setTextColor(int color2) {
        this.mTextView.setTextColor(color2);
        this.mNumberView.setTextColor(color2);
    }

    public void setNumberDigitsAfterPoint(int numberDigitsAfterPoint) {
        this.numberDigitsAfterPoint = numberDigitsAfterPoint;
    }

    public void setLeftIcon(@DrawableRes int icon) {
        this.mNumberRightIcon = icon;
        this.setLeftIconWhenNotEmptyText(icon);
    }

    public void updateIcon(Drawable drawable2) {
        this.mLeftIcon.setImageDrawable(drawable2);
    }

    private void setLeftIconWhenNotEmptyText(@DrawableRes int icon) {
        if (!FP.empty((CharSequence)this.mNumberView.getText()) && icon != 0) {
            this.mLeftIcon.setVisibility(0);
            this.mLeftIcon.setImageResource(icon);
        }
    }

    public void setLevelPattern(boolean isLevelPattern) {
        this.mIsLevelPattern = isLevelPattern;
    }
}

