/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play.activity;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.play.activity.OnRoomActivityItemClick;
import com.yy.hiyo.channel.component.play.activity.PrivilegeActData;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListAdapter;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListMvp;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import java.util.ArrayList;
import java.util.List;

public class RoomActivityListPanel
extends YYConstraintLayout
implements RoomActivityListMvp.IView {
    private static final String TAG = "RoomActivityListPanel";
    private RoomActivityListMvp.IPresenter mPresenter;
    private RecyclerView mActivityRv;
    private YYTextView mTitleTv;
    private View mPanelShade;
    private RoomActivityListAdapter mAdapter;
    private boolean destroyed;
    private int model;
    private PrivilegeActData mPrivilegeActData;
    private PrivilegeActData mRoomActData;

    public RoomActivityListPanel(Context context) {
        super(context);
        this.createView(context);
    }

    private void createView(Context context) {
        RoomActivityListPanel.inflate((Context)this.getContext(), (int)R.layout.voice_room_activity_list_panel_channel, (ViewGroup)this);
        this.mTitleTv = (YYTextView)this.findViewById(R.id.tv_title);
        this.mActivityRv = (RecyclerView)this.findViewById(R.id.rv_activity);
        this.mPanelShade = this.findViewById(R.id.panel_shade);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(context, 4);
        this.mActivityRv.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mAdapter = new RoomActivityListAdapter();
        this.mActivityRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

            public int getSpanSize(int i) {
                List<ActivityAction> activityActions;
                if (RoomActivityListPanel.this.mAdapter != null && (activityActions = RoomActivityListPanel.this.mAdapter.getDatas()) != null && !activityActions.isEmpty() && activityActions.get(i) instanceof PrivilegeActData) {
                    return 4;
                }
                return 1;
            }
        });
        this.setOnClickListener(v -> {
            if (this.mPresenter != null) {
                this.mPresenter.hidePanel();
            }
        });
    }

    @Override
    public View getPanel() {
        return this;
    }

    public void setModel(int model) {
        this.model = model;
        if (model == 1) {
            this.setBackgroundColor(-1);
            this.mPanelShade.setVisibility(8);
            int color2 = ColorUtils.parseColor((String)"#999999");
            this.mTitleTv.setTextColor(color2);
            this.mAdapter.setColor(color2);
        } else {
            this.setBackgroundColor(ColorUtils.parseColor((String)"#e6272735"));
            this.mPanelShade.setVisibility(0);
            this.mTitleTv.setTextColor(-1);
            this.mAdapter.setColor(ResourceUtils.getColor((int)R.color.color_80ffffff));
        }
    }

    @Override
    public void setActivityList(List<ActivityAction> actionList, List<ActivityAction> activityActionList) {
        if (this.mAdapter != null) {
            ArrayList<ActivityAction> actAllList = new ArrayList<ActivityAction>();
            if (actionList != null && !actionList.isEmpty()) {
                actAllList.add(this.getRoomActData());
                actAllList.addAll(actionList);
            }
            if (activityActionList != null && !activityActionList.isEmpty()) {
                actAllList.add(this.getPrivilege());
                actAllList.addAll(activityActionList);
            }
            this.mAdapter.setData(actAllList);
        }
    }

    private PrivilegeActData getPrivilege() {
        if (this.mPrivilegeActData == null) {
            this.mPrivilegeActData = new PrivilegeActData(ResourceUtils.getString((int)R.string.tips_privilege_tittle));
        }
        return this.mPrivilegeActData;
    }

    private PrivilegeActData getRoomActData() {
        if (this.mRoomActData == null) {
            this.mRoomActData = new PrivilegeActData(ResourceUtils.getString((int)R.string.tips_act_tittle));
        }
        return this.mRoomActData;
    }

    @Override
    public void setOnItemClick(OnRoomActivityItemClick click) {
        this.mAdapter.setOnItemClick(click);
    }

    @Override
    public void setTitleVisibility(int visibility) {
        this.mTitleTv.setVisibility(visibility);
    }

    public void setPresenter(RoomActivityListMvp.IPresenter presenter) {
        this.mPresenter = presenter;
        if (this.mPresenter != null) {
            this.mPresenter.setIView(this);
        }
    }

    public void destroy() {
        this.destroyed = true;
        if (this.mActivityRv != null) {
            this.mActivityRv.setAdapter(null);
            if (this.mActivityRv.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.mActivityRv.getParent()).removeView((View)this.mActivityRv);
            }
        }
        this.setOnClickListener(null);
        this.mPresenter = null;
    }
}

