/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.play;

import android.content.Context;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.ui.widget.tablayout.MsgView;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityListMvp;
import com.yy.hiyo.channel.component.play.RoomGameAndActivityPageAdapter;
import com.yy.hiyo.channel.component.play.activity.RoomActivityListPanel;
import com.yy.hiyo.channel.component.play.common.TabPageItem;
import com.yy.hiyo.channel.component.play.game.GameListPanel;
import com.yy.hiyo.channel.component.redpoint.ChannelGameRedPointManager;
import com.yy.hiyo.channel.component.redpoint.ChannelRedPointManager;
import java.util.ArrayList;
import java.util.List;

public class RoomGameAndActivityListPanel
extends YYConstraintLayout
implements RoomGameAndActivityListMvp.IView {
    private SlidingTabLayout mTabs;
    private YYViewPager mViewPager;
    private YYTextView mTitle;
    private RoomGameAndActivityListMvp.IPresenter mPresenter;
    RoomGameAndActivityPageAdapter mPageAdapter;
    private List<TabPageItem> mTabItems = new ArrayList<TabPageItem>(2);

    public RoomGameAndActivityListPanel(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        RoomGameAndActivityListPanel.inflate((Context)this.getContext(), (int)R.layout.voice_room_game_and_activity_list_panel_channel, (ViewGroup)this);
        this.mViewPager = (YYViewPager)this.findViewById(R.id.view_pager);
        this.mTabs = (SlidingTabLayout)this.findViewById(R.id.tabs);
        this.mTitle = (YYTextView)this.findViewById(R.id.tv_title);
        this.mPageAdapter = new RoomGameAndActivityPageAdapter(this.mTabItems);
        this.mViewPager.setAdapter((PagerAdapter)this.mPageAdapter);
        this.mTabs.setViewPager((ViewPager)this.mViewPager);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (((TabPageItem)RoomGameAndActivityListPanel.this.mTabItems.get(position)).getView() instanceof RoomActivityListPanel) {
                    ChannelTrack.INSTANCE.onActTabClick();
                }
                if (((TabPageItem)RoomGameAndActivityListPanel.this.mTabItems.get(position)).getView() instanceof GameListPanel) {
                    ChannelTrack.INSTANCE.onGameTabClick();
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setTabItemList(List<TabPageItem> tabItems) {
        this.mTabItems = tabItems;
        if (this.mTabItems.size() == 1) {
            this.mTabs.setVisibility(8);
            this.mTitle.setVisibility(0);
            this.mTitle.setText((CharSequence)tabItems.get(0).getTabTitle());
        } else {
            this.mTabs.setVisibility(0);
            this.mTitle.setVisibility(8);
        }
        this.mPageAdapter.updateData(this.mTabItems);
        this.mTabs.notifyDataSetChanged();
        this.showActivityRedPoint();
    }

    private void showActivityRedPoint() {
        if (this.mTabs == null) {
            return;
        }
        for (TabPageItem tabPageItem : this.mTabItems) {
            int radio;
            MsgView dot;
            boolean hasShowRed;
            int index;
            if (tabPageItem.getView() instanceof RoomActivityListPanel) {
                index = this.mTabItems.indexOf(tabPageItem);
                if (!this.isNoNeedAB()) {
                    MLog.debug((Object)"ActivityRedPoint", (String)"showActivityRedPoint a not right country:%s", (Object[])new Object[]{SystemUtils.getHagoCountry()});
                    this.mTabs.hideMsg(index);
                    return;
                }
                hasShowRed = ChannelRedPointManager.INSTANCE.checkAllReadState(true);
                if (!hasShowRed) {
                    dot = this.mTabs.getMsgView(index);
                    radio = ResolutionUtils.dip2Px((float)6.0f);
                    dot.setWidth(radio);
                    dot.setHeight(radio);
                    this.mTabs.showDot(index);
                    continue;
                }
                this.mTabs.hideMsg(index);
                continue;
            }
            if (!(tabPageItem.getView() instanceof GameListPanel)) continue;
            index = this.mTabItems.indexOf(tabPageItem);
            if (!this.isNoNeedAB()) {
                MLog.debug((Object)"ChannelGameRedDot", (String)"showActivityRedPoint a not right country:%s", (Object[])new Object[]{SystemUtils.getHagoCountry()});
                this.mTabs.hideMsg(index);
                return;
            }
            hasShowRed = ChannelGameRedPointManager.INSTANCE.checkAllReadState(true);
            if (!hasShowRed) {
                dot = this.mTabs.getMsgView(index);
                radio = ResolutionUtils.dip2Px((float)6.0f);
                dot.setWidth(radio);
                dot.setHeight(radio);
                this.mTabs.showDot(index);
                continue;
            }
            this.mTabs.hideMsg(index);
        }
    }

    private boolean isNoNeedAB() {
        String countryCode = AccountUtil.registerCountry();
        return "AE".equalsIgnoreCase(countryCode) || "VN".equalsIgnoreCase(countryCode) || "TH".equalsIgnoreCase(countryCode) || "SA".equalsIgnoreCase(countryCode) || "EG".equalsIgnoreCase(countryCode) || "BR".equalsIgnoreCase(countryCode) || "IN".equalsIgnoreCase(countryCode) || "ID".equalsIgnoreCase(countryCode);
    }

    public void setPresenter(RoomGameAndActivityListMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void showContent() {
    }

    @Override
    public void checkRoomActivityReadStatus() {
        this.showActivityRedPoint();
    }

    public void setModel(int model) {
        if (model == 1) {
            this.mTabs.setBackgroundColor(-1);
            this.mTitle.setBackgroundColor(-1);
            int color2 = ColorUtils.parseColor((String)"#999999");
            this.mTitle.setTextColor(color2);
        } else {
            this.mViewPager.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_f105272735));
            this.mTabs.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_f105272735));
            this.mTitle.setBackgroundColor(ResourceUtils.getColor((int)R.color.color_f105272735));
        }
    }
}

