/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.playlist;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.playlist.IPlaylistUICallback;
import com.yy.hiyo.channel.component.music.playlist.PlaylistAdapter;
import java.util.ArrayList;
import java.util.List;

public class PlaylistPage
extends YYFrameLayout
implements View.OnClickListener {
    private Context mContext;
    private YYTextView editTv;
    private YYTextView titleTv;
    private YYTextView deleteTv;
    private YYTextView selectAllTv;
    private YYTextView searchTv;
    private YYLinearLayout addMusicLayout;
    private YYLinearLayout selectAllLayout;
    private RecyclerView playRv;
    private PlaylistAdapter mAdapter;
    private List<MusicPlaylistDBBean> mList;
    private CommonStatusLayout statusLayout;
    private IPlaylistUICallback mCallback;

    public PlaylistPage(Context context, IPlaylistUICallback callback2) {
        super(context);
        this.mContext = context;
        this.mCallback = callback2;
        this.createView();
        this.setData();
    }

    private void createView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_music_playlist_channel, (ViewGroup)this, true);
        this.selectAllLayout = (YYLinearLayout)this.findViewById(R.id.layout_selectall);
        this.addMusicLayout = (YYLinearLayout)this.findViewById(R.id.layout_add_music);
        this.searchTv = (YYTextView)this.findViewById(R.id.tv_search);
        this.editTv = (YYTextView)this.findViewById(R.id.tv_edit);
        this.titleTv = (YYTextView)this.findViewById(R.id.tv_title);
        this.deleteTv = (YYTextView)this.findViewById(R.id.tv_delete);
        this.selectAllTv = (YYTextView)this.findViewById(R.id.tv_selectall);
        this.statusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.selectAllTv.setOnClickListener((View.OnClickListener)this);
        this.editTv.setOnClickListener((View.OnClickListener)this);
        this.deleteTv.setOnClickListener((View.OnClickListener)this);
        this.searchTv.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_back).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.tv_add_music).setOnClickListener((View.OnClickListener)this);
        this.playRv = (RecyclerView)this.findViewById(R.id.rv_playlist);
        this.playRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext));
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.mContext, 1);
        itemDecoration.setDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_playlist_divider));
        this.playRv.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.mList = new ArrayList<MusicPlaylistDBBean>();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.tv_edit) {
            if (null != this.mAdapter) {
                this.mAdapter.changeMode();
                if (this.mAdapter.isSelectMode()) {
                    this.editTv.setText(R.string.cancel);
                    this.selectAllLayout.setVisibility(0);
                    this.addMusicLayout.setVisibility(8);
                    this.selectAllTv.setSelected(false);
                    this.setDeleteBtn(0);
                } else {
                    this.editTv.setText(R.string.btn_playlist_edit);
                    this.selectAllLayout.setVisibility(8);
                    this.addMusicLayout.setVisibility(0);
                    for (MusicPlaylistDBBean bean2 : this.mList) {
                        bean2.setSelected(false);
                    }
                }
            }
        } else if (v.getId() == R.id.iv_back) {
            if (null != this.mCallback) {
                this.mCallback.clickBack();
            }
        } else if (v.getId() == R.id.tv_add_music) {
            if (null != this.mCallback) {
                this.mCallback.clickAddMusic();
            }
        } else if (v.getId() == R.id.tv_selectall) {
            this.selectAllOrUnselect();
        } else if (v.getId() == R.id.tv_delete) {
            ArrayList<MusicPlaylistDBBean> deleteList = new ArrayList<MusicPlaylistDBBean>();
            for (MusicPlaylistDBBean bean3 : this.mList) {
                if (!bean3.isSelected()) continue;
                deleteList.add(bean3);
            }
            if (null != this.mCallback) {
                this.mCallback.deleteMusic(deleteList);
            }
        } else if (v.getId() == R.id.tv_search && null != this.mCallback && null != this.mAdapter) {
            this.mCallback.clickSearch(this.mAdapter.isSelectMode());
        }
    }

    public void setData() {
        this.editTv.setText(R.string.btn_playlist_edit);
        this.selectAllLayout.setVisibility(8);
        this.addMusicLayout.setVisibility(0);
        MusicHelper.requestPlaylist(new MusicHelper.PlaylistCallback(){

            @Override
            public void playlistGetted(List<MusicPlaylistDBBean> playList) {
                if (null != playList && !playList.isEmpty()) {
                    int playingIndex = -1;
                    for (int i = 0; i < playList.size(); ++i) {
                        playList.get(i).setSelected(false);
                        if (null == MusicHelper.getPlayingBean() || !playList.get(i).getMusicPath().equals(MusicHelper.getPlayingBean().getMusicPath())) continue;
                        playingIndex = i;
                    }
                    PlaylistPage.this.statusLayout.hideAllStatus();
                    PlaylistPage.this.searchTv.setVisibility(0);
                    PlaylistPage.this.findViewById(R.id.divider_search).setVisibility(0);
                    PlaylistPage.this.editTv.setVisibility(0);
                    PlaylistPage.this.playRv.setVisibility(0);
                    PlaylistPage.this.titleTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_playlist, (Object[])new Object[]{playList.size()}));
                    PlaylistPage.this.mList.clear();
                    PlaylistPage.this.mList.addAll(playList);
                    PlaylistPage.this.mAdapter = new PlaylistAdapter(PlaylistPage.this.mContext, PlaylistPage.this.mList, PlaylistPage.this.mCallback);
                    PlaylistPage.this.playRv.setAdapter((RecyclerView.Adapter)PlaylistPage.this.mAdapter);
                    if (-1 != playingIndex) {
                        PlaylistPage.this.playRv.scrollToPosition(playingIndex);
                    }
                } else {
                    PlaylistPage.this.statusLayout.showNoDataCenter();
                    PlaylistPage.this.statusLayout.findViewById(R.id.status_frame).setBackgroundColor(ResourceUtils.getColor((int)R.color.transparent));
                    PlaylistPage.this.searchTv.setVisibility(8);
                    PlaylistPage.this.findViewById(R.id.divider_search).setVisibility(8);
                    PlaylistPage.this.editTv.setVisibility(8);
                    PlaylistPage.this.playRv.setVisibility(8);
                    PlaylistPage.this.titleTv.setText(R.string.title_playlist_none);
                    YYImageView mStatusIcon = (YYImageView)PlaylistPage.this.findViewById(R.id.icon_status);
                    YYTextView mStatusText = (YYTextView)PlaylistPage.this.findViewById(R.id.text_status);
                    mStatusIcon.setBackgroundResource(R.drawable.playlist_empty);
                    mStatusText.setTextColor(ResourceUtils.getColor((int)R.color.white));
                    mStatusText.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_playlist_nomusic));
                }
            }
        });
    }

    public void clickItemSelect(MusicPlaylistDBBean bean2) {
        if (null != bean2) {
            bean2.setSelected(!bean2.isSelected());
            this.itemSelectChanged();
        }
    }

    private void selectAllOrUnselect() {
        if (null != this.mList) {
            boolean isPreAllSelected = true;
            for (MusicPlaylistDBBean bean2 : this.mList) {
                if (bean2.isSelected()) continue;
                isPreAllSelected = false;
                bean2.setSelected(true);
            }
            if (isPreAllSelected) {
                for (MusicPlaylistDBBean bean2 : this.mList) {
                    bean2.setSelected(false);
                }
            }
            if (isPreAllSelected) {
                this.selectAllTv.setSelected(false);
                this.setDeleteBtn(0);
            } else {
                this.selectAllTv.setSelected(true);
                this.setDeleteBtn(this.mList.size());
            }
            this.notifyDataSetChanged();
        }
    }

    public void itemSelectChanged() {
        int selectCount = 0;
        for (MusicPlaylistDBBean tempBean : this.mList) {
            if (!tempBean.isSelected()) continue;
            ++selectCount;
        }
        this.selectAllTv.setSelected(selectCount == this.mList.size());
        this.setDeleteBtn(selectCount);
        this.notifyDataSetChanged();
    }

    public void notifyDataSetChanged() {
        if (null != this.mAdapter) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void setDeleteBtn(int count) {
        if (0 == count) {
            this.deleteTv.setText(R.string.btn_delete_music_selected_none);
            this.deleteTv.setAlpha(0.2f);
            this.deleteTv.setEnabled(false);
        } else {
            this.deleteTv.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_delete_music, (Object[])new Object[]{count}));
            this.deleteTv.setAlpha(1.0f);
            this.deleteTv.setEnabled(true);
        }
    }
}

