/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.playlist;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.ChannelMsgDef;
import com.yy.hiyo.channel.component.music.MusicHelper;
import com.yy.hiyo.channel.component.music.addmusic.ChannelAddMusicMsgDef;
import com.yy.hiyo.channel.component.music.playlist.IPlaylistUICallback;
import com.yy.hiyo.channel.component.music.playlist.PlaylistWindow;
import com.yy.hiyo.channel.component.music.searchmusic.ChannelSearchMusicMsgDef;
import java.util.List;

public class PlaylistController
extends DefaultController
implements IPlaylistUICallback {
    private PlaylistWindow mWindow;

    public PlaylistController(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.CHANNEL_ENTERED, (INotify)this);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == ChannelMsgDef.OPEN_MUSIC_PLAYLIST) {
            this.showWindow(true);
        } else if (msg.what == ChannelMsgDef.CLOSE_MUSIC_PLAYLIST) {
            this.closeWindow();
        } else if (msg.what == ChannelMsgDef.OPEN_MUSIC_PLAYLIST_WITHOUT_ANIM) {
            this.showWindow(false);
            if (MusicHelper.getMusicStatus() == 0 && MusicHelper.getPlaylistSize() > 0) {
                Message message = Message.obtain();
                message.what = ChannelMsgDef.PLAY_MUSIC;
                List<MusicPlaylistDBBean> list2 = MusicHelper.getPlayList();
                if (!FP.empty(list2)) {
                    message.obj = list2.get(0);
                }
                this.sendMessage(message);
            }
        } else if (msg.what == ChannelMsgDef.MUSIC_CHANGE) {
            if (null != this.mWindow && null != this.mWindow.getPage()) {
                this.mWindow.getPage().notifyDataSetChanged();
            }
        } else if (msg.what == ChannelMsgDef.DELETE_MUSIC_FROM_SEARCH && msg.obj instanceof List) {
            List list3 = (List)msg.obj;
            MusicHelper.setPlayList(list3);
            if (null != this.mWindow && null != this.mWindow.getPage()) {
                this.mWindow.getPage().itemSelectChanged();
            }
        }
    }

    private void showWindow(boolean isAnim) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.mWindow = new PlaylistWindow(this.mContext, this);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, isAnim);
    }

    private void closeWindow() {
        if (null != this.mWindow) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (abstractWindow == this.mWindow) {
            this.mWindow = null;
        }
    }

    @Override
    public void clickItemSong(MusicPlaylistDBBean bean2) {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u5217\u8868\u70b9\u51fb\u64ad\u653e\u97f3\u4e50\uff1a%s", (Object[])new Object[]{bean2.getMusicName()});
        if (!bean2.isFileExist()) {
            ToastUtils.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.tips_music_unvailable), (int)0);
            return;
        }
        Message msg = Message.obtain();
        msg.what = ChannelMsgDef.PLAY_MUSIC;
        msg.obj = bean2;
        this.sendMessage(msg);
        this.closeWindow();
    }

    @Override
    public void clickItemSelect(MusicPlaylistDBBean bean2) {
        if (null != this.mWindow && null != this.mWindow.getPage()) {
            this.mWindow.getPage().clickItemSelect(bean2);
        }
    }

    @Override
    public void deleteMusic(final List<MusicPlaylistDBBean> list2) {
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_delete_music_dialog), (CharSequence)ResourceUtils.getString((int)R.string.dialog_ok), (CharSequence)ResourceUtils.getString((int)R.string.str_button_cancel), true, false, new OkCancelDialogListener(){

            public void onCancel() {
                PlaylistController.this.mDialogLinkManager.dismissDialog();
            }

            public void onOk() {
                PlaylistController.this.mDialogLinkManager.dismissDialog();
                FeatureLog.i((String)"FTChannelBgm", (String)"\u5220\u9664\u97f3\u4e50 size\uff1a%s", (Object[])new Object[]{list2.size()});
                MyBox musicPlaylistMyBox = ((IDBService)PlaylistController.this.getServiceManager().getService(IDBService.class)).boxForCurUser(MusicPlaylistDBBean.class);
                if (musicPlaylistMyBox != null) {
                    musicPlaylistMyBox.deleteItems(list2);
                    if (null != MusicHelper.getPlayingBean()) {
                        for (MusicPlaylistDBBean bean2 : list2) {
                            if (!bean2.getMusicPath().equals(MusicHelper.getPlayingBean().getMusicPath())) continue;
                            PlaylistController.this.sendMessage(BaseMsgDef.STOP_VOICE_ROOM_MUSIC);
                            break;
                        }
                    }
                    MusicHelper.reloadList();
                    if (null != PlaylistController.this.mWindow && null != PlaylistController.this.mWindow.getPage()) {
                        PlaylistController.this.mWindow.getPage().setData();
                    }
                }
            }
        });
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    @Override
    public void clickAddMusic() {
        this.sendMessage(ChannelAddMusicMsgDef.OPEN_ADD_MUSIC_PAGE);
    }

    @Override
    public void clickSearch(boolean isSelectModel) {
        FeatureLog.i((String)"FTChannelBgm", (String)"\u70b9\u51fb\u97f3\u4e50\u641c\u7d22\u754c\u9762", (Object[])new Object[0]);
        Message message = Message.obtain();
        message.what = ChannelSearchMusicMsgDef.OPEN_SEARCH_MUSIC;
        message.obj = MusicHelper.getPlayList();
        message.arg1 = isSelectModel ? 2 : 1;
        this.sendMessage(message);
    }

    @Override
    public void clickBack() {
        this.closeWindow();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationIdDef.CHANNEL_ENTERED) {
            this.closeWindow();
        }
    }
}

