/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic.utils;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import com.yy.base.logger.MLog;
import java.io.File;

public class SingleMediaScanner
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final String TAG = "SingleMediaScanner";
    private MediaScannerConnection mConnection;
    private File mFile;
    private ScanListener mListener;

    public SingleMediaScanner(Context context, File file, ScanListener listener2) {
        this.mListener = listener2;
        this.mFile = file;
        this.mConnection = new MediaScannerConnection(context, (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.mConnection.connect();
    }

    public void onMediaScannerConnected() {
        if (this.mFile != null) {
            MLog.info((Object)TAG, (String)"onMediaScannerConnected mFile.getAbsolutePath()=%s", (Object[])new Object[]{this.mFile.getAbsolutePath()});
            if (this.mConnection != null) {
                this.mConnection.scanFile(this.mFile.getAbsolutePath(), null);
            }
        }
    }

    public void onScanCompleted(String path, Uri uri) {
        MLog.info((Object)TAG, (String)"onScanCompleted path=%s", (Object[])new Object[]{path});
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
        if (this.mListener != null) {
            this.mListener.onScanFinish();
        }
    }

    public void stopScan() {
        if (this.mConnection != null) {
            this.mConnection.disconnect();
        }
    }

    public static interface ScanListener {
        public void onScanFinish();
    }
}

