/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic.utils;

import android.app.Activity;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import androidx.annotation.NonNull;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicPresenter;
import com.yy.hiyo.channel.component.music.addmusic.utils.SingleMediaScanner;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum ScanMusicManager {
    INSTANCE;

    private static final String TAG = "ScanMusicManager";
    private List<String> musicSuffixList = new ArrayList<String>(Arrays.asList("wav", "mp3", "aac", "m4a"));
    private SingleMediaScanner mScanner;

    public List<MusicPlaylistDBBean> getMusicData(Context context) {
        ArrayList<MusicPlaylistDBBean> list2 = new ArrayList<MusicPlaylistDBBean>();
        HashMap<String, Integer> musicNameMap = new HashMap<String, Integer>();
        try {
            Cursor cursor = context.getContentResolver().query(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, null, null, null, "is_music");
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String displayName;
                    MusicPlaylistDBBean bean2 = new MusicPlaylistDBBean();
                    long size = cursor.getLong(cursor.getColumnIndexOrThrow("_size"));
                    if (size < 0x100000L || StringUtils.isEmpty((String)(displayName = cursor.getString(cursor.getColumnIndexOrThrow("_display_name"))))) continue;
                    String suffix = displayName.substring(displayName.lastIndexOf(".") + 1);
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)TAG, (String)"MusicPlaylistDBBean=%s, displayName=%s, suffix=%s", (Object[])new Object[]{bean2, displayName, suffix});
                    }
                    if (!this.musicSuffixList.contains(suffix)) continue;
                    String musicName = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                    if (musicNameMap.containsKey(musicName)) {
                        int count = (Integer)musicNameMap.get(musicName);
                        musicNameMap.put(musicName, count + 1);
                        musicName = musicName + "(" + count + ")";
                    } else {
                        musicNameMap.put(musicName, 1);
                    }
                    bean2.setMusicName(musicName);
                    bean2.setSinger(cursor.getString(cursor.getColumnIndexOrThrow("artist")));
                    bean2.setMusicPath(cursor.getString(cursor.getColumnIndexOrThrow("_data")));
                    bean2.setContentUri(ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)cursor.getLong(cursor.getColumnIndex("_id"))).toString());
                    bean2.setDuration((long)cursor.getInt(cursor.getColumnIndexOrThrow("duration")));
                    list2.add(bean2);
                }
                cursor.close();
            }
        }
        catch (Exception e) {
            MLog.info((Object)TAG, (String)"getMusicData exception=%s", (Object[])new Object[]{e});
        }
        return list2;
    }

    public void updateMedia(final Context context, final AddMusicPresenter.IUpdateMediaCallback callback2) {
        PermissionHelper.checkStoragePermission((Activity)((Activity)context), (IPermissionListener)new SimplePermissionListener(){

            public void onPermissionGranted(@NonNull String[] permission) {
                ScanMusicManager.this.updateMediaInternal(context, callback2);
            }
        });
    }

    public void updateMediaInternal(Context context, final AddMusicPresenter.IUpdateMediaCallback callback2) {
        if (context == null) {
            return;
        }
        final long startTimestamp = System.currentTimeMillis();
        String path = Environment.getExternalStorageDirectory().getAbsolutePath();
        if (!StringUtils.isEmpty((String)path)) {
            MLog.info((Object)TAG, (String)"path = %s", (Object[])new Object[]{path});
            File file = new File(path);
            this.mScanner = new SingleMediaScanner(context, file, new SingleMediaScanner.ScanListener(){

                @Override
                public void onScanFinish() {
                    MLog.info((Object)ScanMusicManager.TAG, (String)"onScanFinish time=%d", (Object[])new Object[]{System.currentTimeMillis() - startTimestamp});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.updateMediaSucceed();
                            }
                            ScanMusicManager.this.mScanner = null;
                        }
                    });
                }
            });
        }
    }

    public void stopScan() {
        MLog.info((Object)TAG, (String)"stopScan", (Object[])new Object[0]);
        if (this.mScanner != null) {
            this.mScanner.stopScan();
            this.mScanner = null;
        }
    }
}

