/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.music.addmusic;

import android.content.Context;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import androidx.annotation.NonNull;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.music.addmusic.IAddMusicAdapterCallback;
import com.yy.hiyo.channel.component.music.playlist.PlaylistAdapter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddMusicAdapter
extends PlaylistAdapter {
    private IAddMusicAdapterCallback mCallback;
    private String mKeyword;

    public AddMusicAdapter(Context context, List<MusicPlaylistDBBean> list2, IAddMusicAdapterCallback callback2) {
        this.mContext = context;
        this.mList = list2;
        this.mCallback = callback2;
    }

    public void setKeyword(String keyword) {
        this.mKeyword = keyword;
    }

    @Override
    public void onBindViewHolder(final @NonNull PlaylistAdapter.NormalHolder holder, final int position) {
        final MusicPlaylistDBBean bean2 = (MusicPlaylistDBBean)this.mList.get(position);
        holder.nameTv.setText((CharSequence)bean2.getMusicName());
        if (!StringUtils.isEmpty((String)bean2.getSinger())) {
            holder.contentTv.setText((CharSequence)bean2.getSinger());
        } else {
            holder.contentTv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_unknown));
        }
        if (this.isSelectMode) {
            holder.selectIv.setVisibility(0);
            holder.selectIv.setSelected(bean2.isSelected());
        } else {
            holder.selectIv.setVisibility(8);
        }
        holder.nameTv.setTextColor(Color.parseColor((String)"#ffffff"));
        holder.contentTv.setTextColor(Color.parseColor((String)"#80ffffff"));
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AddMusicAdapter.this.isSelectMode) {
                    boolean isSelected = bean2.isSelected();
                    holder.selectIv.setSelected(!isSelected);
                    bean2.setSelected(!isSelected);
                }
                if (AddMusicAdapter.this.mCallback != null) {
                    AddMusicAdapter.this.mCallback.doSelectAction(bean2.isSelected(), position);
                }
            }
        });
        if (this.mKeyword != null) {
            String name = bean2.getMusicName();
            SpannableString spannableString = new SpannableString((CharSequence)name);
            try {
                Pattern pattern = Pattern.compile(this.mKeyword, 2);
                Matcher matcher = pattern.matcher(name);
                while (matcher.find()) {
                    String key = matcher.group();
                    spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#fed778")), matcher.start(), matcher.start() + key.length(), 33);
                }
            }
            catch (Exception e) {
                MLog.info((Object)"AddMusicAdapter", (String)e.toString(), (Object[])new Object[0]);
            }
            holder.nameTv.setText((CharSequence)spannableString);
        }
    }
}

