/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.mention.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.mention.bean.MentionData;
import java.util.ArrayList;
import java.util.List;

public class MentionListAdapter
extends RecyclerView.Adapter<MentionViewHolder> {
    private List<MentionData> mData = new ArrayList<MentionData>();
    private IMentionItemListener mMentionItemListener;

    public void setData(List<MentionData> data2) {
        if (data2 != null && data2.size() > 0) {
            this.mData.clear();
            this.mData.addAll(data2);
        }
        this.notifyDataSetChanged();
    }

    public void setMentionItemListener(IMentionItemListener listener2) {
        this.mMentionItemListener = listener2;
    }

    @NonNull
    public MentionViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = View.inflate((Context)viewGroup.getContext(), (int)R.layout.item_mention_list, null);
        MentionViewHolder viewHolder = new MentionViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MentionViewHolder mentionViewHolder, int i) {
        final MentionData mentionData = this.mData.get(i);
        mentionViewHolder.nick.setText((CharSequence)mentionData.getNick());
        ImageLoader.loadImage((ImageView)mentionViewHolder.avatar, (String)mentionData.getAvatar(), (int)R.drawable.icon_avatar_default_male);
        if (15 == mentionData.getRole()) {
            mentionViewHolder.role.setVisibility(0);
            mentionViewHolder.role.setImageResource(R.drawable.icon_group_host);
        } else if (10 == mentionData.getRole()) {
            mentionViewHolder.role.setVisibility(0);
            mentionViewHolder.role.setImageResource(R.drawable.icon_group_administrator);
        } else if (5 == mentionData.getRole()) {
            mentionViewHolder.role.setVisibility(0);
            mentionViewHolder.role.setImageResource(R.drawable.icon_group_member);
        } else {
            mentionViewHolder.role.setVisibility(8);
        }
        mentionViewHolder.content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MentionListAdapter.this.mMentionItemListener != null) {
                    MentionListAdapter.this.mMentionItemListener.onItemClick(mentionData.getNick(), mentionData.getUid(), mentionData.isRobot(), mentionData.getRobotInsId());
                }
            }
        });
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public static interface IMentionItemListener {
        public void onItemClick(String var1, long var2, boolean var4, String var5);
    }

    static class MentionViewHolder
    extends RecyclerView.ViewHolder {
        CircleImageView avatar;
        TextView nick;
        RecycleImageView role;
        LinearLayout content;

        public MentionViewHolder(@NonNull View itemView) {
            super(itemView);
            this.avatar = (CircleImageView)itemView.findViewById(R.id.avatar);
            this.nick = (TextView)itemView.findViewById(R.id.nick_name);
            this.role = (RecycleImageView)itemView.findViewById(R.id.iv_role);
            this.content = (LinearLayout)itemView.findViewById(R.id.ll_mention_list);
        }
    }
}

