/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.mention.ui;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.bottombar.InputDialog;
import com.yy.hiyo.channel.component.mention.bean.MentionData;
import com.yy.hiyo.channel.component.mention.ui.MentionListAdapter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MentionInputDialog
extends InputDialog {
    private RecyclerView mRvMention;
    private MentionListAdapter mAdapter;
    private IInputDialogListener mListener;
    private View mView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_mention_list, null);

    public MentionInputDialog(@NotNull Context mContext, final IChannel channel) {
        super(mContext);
        this.mAdapter = new MentionListAdapter();
        this.mAdapter.setMentionItemListener(new MentionListAdapter.IMentionItemListener(){

            @Override
            public void onItemClick(String nick, long uid, boolean isRobot, String robotInsId) {
                if (MentionInputDialog.this.mListener != null) {
                    MentionInputDialog.this.mListener.onShowNick(nick, uid, isRobot, robotInsId);
                    if (channel != null) {
                        RoomTrack.INSTANCE.reportAtListClick(channel.getChannelId(), String.valueOf(channel.getRoleService().getMyRoleCache()));
                    }
                }
            }
        });
        this.mRvMention = (RecyclerView)this.mView.findViewById(R.id.rv_mention);
        this.mRvMention.setAdapter((RecyclerView.Adapter)this.mAdapter);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mRvMention.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
    }

    public void setListener(IInputDialogListener listener2) {
        this.mListener = listener2;
    }

    public void showMentionList(List<MentionData> list2, IChannel channel) {
        this.getMExtLayout().removeAllViews();
        if (list2 == null) {
            this.getMExtLayout().setVisibility(8);
            return;
        }
        if (channel != null) {
            RoomTrack.INSTANCE.reportAtListShow(channel.getChannelId(), String.valueOf(channel.getRoleService().getMyRoleCache()));
        }
        this.getMExtLayout().setVisibility(0);
        this.getMExtLayout().addView(this.mView);
        this.mAdapter.setData(list2);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mRvMention.getLayoutParams();
        int paddingHeight = 0;
        if (this.getMContentView() != null) {
            paddingHeight += this.getMContentView().getHeight();
        }
        if (this.mAdapter.getItemCount() <= 5) {
            layoutParams.gravity = 80;
            this.mView.setPadding(0, 0, 0, paddingHeight);
            this.mView.setBackgroundResource(R.color.transparent);
        } else {
            layoutParams.gravity = 48;
            this.mView.setPadding(0, 0, 0, paddingHeight);
            this.mView.setBackgroundResource(R.color.white);
        }
        this.findViewById(R.id.fl_mention_out).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MentionInputDialog.this.dismiss();
            }
        });
    }

    public static interface IInputDialogListener {
        public void onShowNick(String var1, long var2, boolean var4, String var5);
    }
}

