/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online.data;

import androidx.collection.LongSparseArray;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.CommonCallback;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.common.DataTransform;
import com.yy.appbase.common.DataTransformGroup;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.channel.base.bean.OnlineInfo;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.online.data.DefaultOnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.data.OnlinePageData;
import com.yy.hiyo.channel.component.invite.online.data.PotentialOnlineDataProvider;
import com.yy.hiyo.proto.ProtoManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/yy/hiyo/channel/component/invite/online/data/PotentialOnlineDataProvider;", "Lcom/yy/hiyo/channel/component/invite/online/data/DefaultOnlineDataProvider;", "channel", "Lcom/yy/hiyo/channel/base/service/IChannel;", "(Lcom/yy/hiyo/channel/base/service/IChannel;)V", "fetchOnlineData", "", "page", "Lcom/yy/hiyo/proto/ProtoManager$Page;", "callback", "Lcom/yy/appbase/common/DataCallback;", "Lcom/yy/hiyo/channel/component/invite/online/data/OnlinePageData;", "Companion", "channel-components_release"})
public final class PotentialOnlineDataProvider
extends DefaultOnlineDataProvider {
    @NotNull
    public static final String TAG = "PotentialOnlineDataProvider";
    public static final Companion Companion = new Companion(null);

    @Override
    public void fetchOnlineData(@Nullable ProtoManager.Page page, @Nullable DataCallback<OnlinePageData> callback2) {
        IChannel iChannel = this.mChannel;
        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"mChannel");
        iChannel.getRoleService().getPotentialOnlineUserList(page, new IRoleService.IGetOnlineUserListCallBack(this, page, callback2){
            final /* synthetic */ PotentialOnlineDataProvider this$0;
            final /* synthetic */ ProtoManager.Page $page;
            final /* synthetic */ DataCallback $callback;

            public void onSuccess(@NotNull String channel, @NotNull ProtoManager.Page resultPage, @NotNull OnlineInfo data2) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Intrinsics.checkParameterIsNotNull((Object)resultPage, (String)"resultPage");
                Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)"PotentialOnlineDataProvider", (String)("onlineUids = " + data2.getOnlineUids()), (Object[])new Object[0]);
                    MLog.info((Object)"PotentialOnlineDataProvider", (String)("potentialUids = " + data2.getPotentialMap()), (Object[])new Object[0]);
                }
                List onlineBeanList = new ArrayList<E>();
                if (data2.getOnlineUids() != null) {
                    for (Long uid : data2.getOnlineUids()) {
                        if (uid <= 0L) continue;
                        LongSparseArray longSparseArray = data2.getPotentialMap();
                        Long l = uid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"uid");
                        if (!longSparseArray.containsKey(l.longValue())) continue;
                        long l2 = AccountUtil.getUid();
                        if (uid == l2) continue;
                        OnlineBean onlineBean = new OnlineBean();
                        onlineBean.uid = uid;
                        onlineBean.isVipSeat = data2.getVips() != null && data2.getVips().contains(uid);
                        onlineBean.wearingInfos = this.this$0.provideWearingInfos((List)data2.getWearingsMap().get(uid.longValue()));
                        onlineBean.mUserTagInfoList = ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).getUserTagsFromConfig((List)data2.getUserCardMap().get(uid.longValue()));
                        IChannel iChannel = this.this$0.mChannel;
                        Intrinsics.checkExpressionValueIsNotNull((Object)iChannel, (String)"mChannel");
                        onlineBean.isAnchor = iChannel.getRoleService().isAnchor(uid.longValue());
                        Object object = data2.getPotentialMap().get(uid.longValue(), (Object)0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"data.potentialMap[uid, 0]");
                        onlineBean.potentialFlag = ((Number)object).intValue();
                        onlineBeanList.add(onlineBean);
                    }
                }
                MutableLiveData mutableLiveData = this.this$0.mOnlineCount;
                Intrinsics.checkExpressionValueIsNotNull((Object)mutableLiveData, (String)"mOnlineCount");
                mutableLiveData.setValue((Object)onlineBeanList.size());
                OnlinePageData pageData = new OnlinePageData(this.$page, onlineBeanList);
                if (FP.empty((Collection)onlineBeanList)) {
                    this.this$0.onDataReady(pageData, (DataCallback<OnlinePageData>)this.$callback);
                } else {
                    DataTransformGroup.Companion.of((Object)onlineBeanList).add((DataTransform)new DataTransform<List<OnlineBean>>(this){
                        final /* synthetic */ fetchOnlineData.1 this$0;

                        public void transform(@NotNull List<OnlineBean> data2, @NotNull CommonCallback callback2) {
                            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
                            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
                            this.this$0.this$0.requestUserInfos(data2, callback2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }).add((DataTransform)new DataTransform<List<OnlineBean>>(this){
                        final /* synthetic */ fetchOnlineData.1 this$0;

                        public void transform(@NotNull List<OnlineBean> data2, @NotNull CommonCallback callback2) {
                            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
                            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
                            this.this$0.this$0.requestRoleType(data2, callback2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }).add((DataTransform)new DataTransform<List<OnlineBean>>(this){
                        final /* synthetic */ fetchOnlineData.1 this$0;

                        public void transform(@NotNull List<OnlineBean> data2, @NotNull CommonCallback callback2) {
                            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
                            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
                            this.this$0.this$0.requestIsMember(data2, callback2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }).add((DataTransform)new DataTransform<List<OnlineBean>>(this){
                        final /* synthetic */ fetchOnlineData.1 this$0;

                        public void transform(@NotNull List<OnlineBean> data2, @NotNull CommonCallback callback2) {
                            Intrinsics.checkParameterIsNotNull(data2, (String)"data");
                            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
                            this.this$0.this$0.requestNickColor(data2, callback2);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }).transform(new CommonCallback(this, pageData){
                        final /* synthetic */ fetchOnlineData.1 this$0;
                        final /* synthetic */ OnlinePageData $pageData;

                        public void onFinish() {
                            this.this$0.this$0.onDataReady(this.$pageData, (DataCallback<OnlinePageData>)this.this$0.$callback);
                        }
                        {
                            this.this$0 = $outer;
                            this.$pageData = $captured_local_variable$1;
                        }
                    });
                }
            }

            public void onError(@NotNull String channel, int errorCode, @NotNull String errorTips, @NotNull Exception e) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                    Intrinsics.checkParameterIsNotNull((Object)errorTips, (String)"errorTips");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    DataCallback dataCallback = this.$callback;
                    if (dataCallback == null) break block0;
                    dataCallback.onResult(null);
                }
            }
            {
                this.this$0 = $outer;
                this.$page = $captured_local_variable$1;
                this.$callback = $captured_local_variable$2;
            }
        });
    }

    public PotentialOnlineDataProvider(@NotNull IChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        super(channel);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/invite/online/data/PotentialOnlineDataProvider$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

