/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.online;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.base.ui.widget.DimBgPanel;
import com.yy.hiyo.channel.component.invite.base.IPanelPage;
import com.yy.hiyo.channel.component.invite.online.OnlineListWithInvite;
import com.yy.hiyo.channel.component.invite.online.OnlineListWithPotentialGuide;
import com.yy.hiyo.channel.component.invite.online.OnlinePagerAdapter;
import com.yy.hiyo.channel.component.invite.online.handler.OnlineInviteHandler;
import com.yy.hiyo.channel.component.invite.online.search.OnlineUserSearchReporter;
import com.yy.hiyo.channel.component.invite.online.search.OnlineUserSearchUiCallback;
import com.yy.hiyo.channel.component.invite.online.search.ui.OnlineUserSearchDialog;
import com.yy.hiyo.mvp.base.ICustomView;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.mvp.base.PageMvpContext;
import java.util.ArrayList;
import java.util.List;

public class OnlineListPanel
extends DimBgPanel
implements ICustomView {
    private PageMvpContext mMvpContext;
    private View mTopBgView;
    private SlidingTabLayout mTabView;
    private RecycleImageView mSearchView;
    private YYViewPager mViewPager;
    private YYLinearLayout mContentView;
    private OnlineUserSearchDialog mSearchDialog;
    private OnlineInviteHandler mOnlineInviteHandler;
    private List<IPanelPage> mPanelPages = new ArrayList<IPanelPage>();
    private OnlineUserSearchUiCallback mSearchUiCallback;
    private boolean hasShowSearchIconPermission = false;
    private IOnPotentialTabSelectListener onPotentialTabSelectListener;

    public OnlineListPanel(Context context, IMvpContext mvpContext) {
        super(context);
        this.mMvpContext = PageMvpContext.Companion.of((View)this);
        this.setShowAnim(this.createBottomShowAnimation());
        this.setHideAnim(this.createBottomHideAnimation());
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.room_online_list_channel, (ViewGroup)this, false);
        this.mTopBgView = view.findViewById(R.id.top_bg);
        this.mTabView = (SlidingTabLayout)view.findViewById(R.id.st_tab);
        this.mSearchView = (RecycleImageView)view.findViewById(R.id.search_iv);
        this.mViewPager = (YYViewPager)view.findViewById(R.id.vp_view_pager);
        this.mContentView = (YYLinearLayout)view.findViewById(R.id.ll_content);
        this.mTopBgView.getLayoutParams().height = (int)((float)ResolutionUtils.getScreenHeight((Context)this.getContext()) * 2.0f / 5.0f);
        this.setContent(view);
        this.initListener();
    }

    public void setInviteHandler(OnlineInviteHandler inviteHandler) {
        this.mOnlineInviteHandler = inviteHandler;
    }

    private void initListener() {
        this.mTopBgView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OnlineListPanel.this.hide(true);
            }
        });
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                if (position >= 0 && position < OnlineListPanel.this.mPanelPages.size() && OnlineListPanel.this.mPanelPages.get(position) instanceof OnlineListWithPotentialGuide && OnlineListPanel.this.onPotentialTabSelectListener != null) {
                    OnlineListPanel.this.onPotentialTabSelectListener.onPotentialTabSelect();
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mSearchView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OnlineListPanel.this.getContext() instanceof FragmentActivity) {
                    ((FragmentActivity)OnlineListPanel.this.getContext()).getWindow().setSoftInputMode(48);
                    OnlineListPanel.this.mSearchDialog = new OnlineUserSearchDialog((FragmentActivity)OnlineListPanel.this.getContext(), new OnlineUserSearchUiCallback(){

                        @Override
                        public void onDialogDismiss() {
                            OnlineListPanel.this.mSearchDialog = null;
                        }

                        @Override
                        public void onProfileClick(long uid) {
                            if (OnlineListPanel.this.mSearchUiCallback != null) {
                                OnlineListPanel.this.mSearchUiCallback.onProfileClick(uid);
                            }
                        }
                    });
                    OnlineListPanel.this.mSearchDialog.showDialog();
                    OnlineUserSearchReporter.INSTANCE.onSearchIconClick();
                }
            }
        });
    }

    public void showInviteItem(boolean show) {
        OnlineListWithInvite inviteView = this.getInviteView();
        if (inviteView == null) {
            return;
        }
        if (show) {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)500.0f));
            this.mContentView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)355.0f));
            this.mContentView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        inviteView.setInviteClickListener(v -> this.mOnlineInviteHandler.openFriendPanel());
        inviteView.showInvite(show);
    }

    @Override
    protected void onShow() {
        super.onShow();
        for (IPanelPage panelPage : this.mPanelPages) {
            panelPage.onShow();
        }
    }

    protected void onHidden() {
        super.onHidden();
        for (IPanelPage panelPage : this.mPanelPages) {
            panelPage.onHide();
        }
        this.mPanelPages.clear();
        this.mSearchDialog = null;
    }

    public void setPages(@NonNull List<PageData> pages) {
        this.mPanelPages.clear();
        ArrayList<View> pageList = new ArrayList<View>();
        String[] titles = new String[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            PageData pageData = pages.get(i);
            pageList.add(pageData.page.getPage());
            Long onlineCount = (Long)pageData.onlineCount.getValue();
            long count = onlineCount != null ? onlineCount : 0L;
            titles[i] = StringUtils.format((String)ResourceUtils.getString((int)pageData.title), (Object[])new Object[]{String.valueOf(count)});
            this.bindOnlineCount(pageData, i);
            this.mPanelPages.add(pageData.page);
        }
        OnlinePagerAdapter pagerAdapter = new OnlinePagerAdapter(pageList);
        this.mViewPager.setAdapter((PagerAdapter)pagerAdapter);
        this.mTabView.setViewPager(this.mViewPager, titles);
        this.mTabView.setCurrentTab(0);
    }

    private void bindOnlineCount(PageData pageData, int index) {
        pageData.onlineCount.observe((LifecycleOwner)this.mMvpContext.getLifecycleOwner(), onlineCount -> {
            long count = onlineCount != null ? onlineCount : 0L;
            TextView onlineTitle = this.mTabView.getTitleView(index);
            if (onlineTitle != null) {
                onlineTitle.setText((CharSequence)StringUtils.format((String)ResourceUtils.getString((int)pageData.title), (Object[])new Object[]{String.valueOf(count)}));
            }
            if (pageData.page instanceof OnlineListWithInvite) {
                this.showOnlineSearchIconIfNeed(count);
            }
        });
    }

    private void showOnlineSearchIconIfNeed(long onlineCount) {
        MLog.info((Object)"OnlineListPanel", (String)"onlineCount: %s , have permission: %s", (Object[])new Object[]{onlineCount, this.hasShowSearchIconPermission});
        if (!this.hasShowSearchIconPermission) {
            this.mSearchView.setVisibility(8);
            return;
        }
        int minOnlineCountConfig = 100;
        if (this.mOnlineInviteHandler != null) {
            minOnlineCountConfig = this.mOnlineInviteHandler.getMinOnlineCountConfig();
        }
        MLog.info((Object)"OnlineListPanel", (String)"min online count: %s", (Object[])new Object[]{minOnlineCountConfig});
        if (onlineCount >= (long)minOnlineCountConfig) {
            this.mSearchView.setVisibility(0);
            OnlineUserSearchReporter.INSTANCE.onSearchIconShow();
        } else {
            this.mSearchView.setVisibility(8);
        }
    }

    public void setHasShowSearchIconPermission(boolean hasShowSearchIconPermission) {
        this.hasShowSearchIconPermission = hasShowSearchIconPermission;
    }

    public OnlineListWithInvite getInviteView() {
        for (IPanelPage panelPage : this.mPanelPages) {
            if (!(panelPage instanceof OnlineListWithInvite)) continue;
            return (OnlineListWithInvite)panelPage;
        }
        return null;
    }

    public void setOnPotentialTabSelectListener(IOnPotentialTabSelectListener onPotentialTabSelectListener) {
        this.onPotentialTabSelectListener = onPotentialTabSelectListener;
    }

    public void setSearchUiCallback(OnlineUserSearchUiCallback searchUiCallback) {
        this.mSearchUiCallback = searchUiCallback;
    }

    public static class PageData {
        @StringRes
        public int title;
        public IPanelPage page;
        public LiveData<Long> onlineCount;

        public PageData(int title, IPanelPage page, LiveData<Long> onlineCount) {
            this.title = title;
            this.page = page;
            this.onlineCount = onlineCount;
        }
    }

    public static interface IOnPotentialTabSelectListener {
        public void onPotentialTabSelect();
    }
}

