/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.viewholder;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.ShareChannelIdDef;

public class PlatFormInviteViewHolder
extends BaseItemBinder.ViewHolder<PlatformShareData>
implements View.OnClickListener {
    private LinearLayout llRoot;
    private OnPlatformShareListener platformShareListener;

    public PlatFormInviteViewHolder(LinearLayout itemView) {
        super((View)itemView);
        this.llRoot = itemView;
    }

    public void setData(PlatformShareData data2) {
        super.setData((Object)data2);
        this.llRoot.removeAllViews();
        if (data2 == null && data2.getChannelList() != null) {
            return;
        }
        for (BaseShareChannel channel : data2.getChannelList()) {
            if (channel.getId() != 5 && channel.getId() != 3 && channel.getId() != 2) continue;
            this.addChannel(channel);
        }
        this.addView(R.id.share_platform_report, R.drawable.share_report, R.string.short_tips_share_report);
    }

    public void setPlatformShareListener(OnPlatformShareListener platformShareListener) {
        this.platformShareListener = platformShareListener;
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (this.platformShareListener == null) {
            return;
        }
        if (id2 == R.id.share_platform_report) {
            this.platformShareListener.onReportClick();
        } else {
            int channelId = ShareChannelIdDef.getChannelIdByViewId((int)id2);
            if (channelId != -1) {
                this.platformShareListener.onPlatformShare(channelId);
            }
        }
    }

    private void addChannel(BaseShareChannel channel) {
        if (channel == null) {
            return;
        }
        int idResId = 0;
        int iconResId = 0;
        switch (channel.getId()) {
            case 2: {
                idResId = R.id.share_platform_whatsapp;
                iconResId = R.drawable.select_share_whatsapp_bg;
                break;
            }
            case 5: {
                idResId = R.id.share_platform_facebook;
                iconResId = R.drawable.select_share_fb_bg;
                break;
            }
            case 3: {
                idResId = R.id.share_platform_instagram;
                iconResId = R.drawable.select_share_ins_bg;
                break;
            }
            case 1: {
                idResId = R.id.share_platform_line;
                iconResId = R.drawable.select_share_line_bg;
                break;
            }
            case 6: {
                idResId = R.id.share_platform_messenger;
                iconResId = R.drawable.select_share_messenger_bg;
                break;
            }
            case 9: {
                idResId = R.id.share_platform_vk;
                iconResId = R.drawable.select_share_vk_bg;
                break;
            }
            case 10: {
                idResId = R.id.share_copy_link;
                iconResId = R.drawable.select_share_copy_bg;
                break;
            }
            case 13: {
                idResId = R.id.share_native;
                iconResId = R.drawable.select_share_native_bg;
                break;
            }
        }
        this.addView(idResId, iconResId, channel.getNameResId());
    }

    private void addView(int idResId, int iconResId, int nameResId) {
        if (idResId > 0) {
            YYLinearLayout llContent = new YYLinearLayout(this.llRoot.getContext());
            llContent.setOrientation(1);
            int ivSize = ResolutionUtils.dip2Px((float)50.0f);
            int verMargin = ResolutionUtils.dip2Px((float)10.0f);
            int horMargin = ResolutionUtils.dip2Px((float)10.0f);
            YYImageView ivChannel = new YYImageView(this.llRoot.getContext());
            ivChannel.setId(idResId);
            ivChannel.setBackgroundResource(iconResId);
            YYTextView textView = new YYTextView(this.llRoot.getContext());
            textView.setSingleLine();
            textView.setTextSize(12.0f);
            textView.setTextColor(ColorUtils.parseColor((String)"#999999"));
            textView.setText((CharSequence)ResourceUtils.getString((int)nameResId));
            llContent.addView((View)ivChannel, ivSize, ivSize);
            llContent.addView((View)textView);
            llContent.setId(idResId);
            this.llRoot.addView((View)llContent);
            LinearLayout.LayoutParams lpIv = (LinearLayout.LayoutParams)ivChannel.getLayoutParams();
            lpIv.gravity = 1;
            LinearLayout.LayoutParams lpTv = (LinearLayout.LayoutParams)textView.getLayoutParams();
            lpTv.width = -1;
            lpTv.topMargin = ResolutionUtils.dip2Px((float)6.0f);
            textView.setGravity(1);
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)llContent.getLayoutParams();
            lp.topMargin = verMargin;
            lp.bottomMargin = verMargin;
            lp.leftMargin = horMargin;
            lp.rightMargin = horMargin;
            lp.width = ResolutionUtils.dip2Px((float)80.0f);
            llContent.setOnClickListener((View.OnClickListener)this);
        }
    }

    public static BaseItemBinder getItemBinder(final OnPlatformShareListener platformShareListener) {
        return new BaseItemBinder<PlatformShareData, PlatFormInviteViewHolder>(){

            @NonNull
            protected PlatFormInviteViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                YYLinearLayout llRoot = new YYLinearLayout(parent.getContext());
                llRoot.setOrientation(0);
                int paddingLR = ResolutionUtils.dip2Px((float)5.0f);
                llRoot.setPadding(paddingLR, 0, paddingLR, 0);
                ViewGroup.LayoutParams rootLP = new ViewGroup.LayoutParams(-2, -2);
                llRoot.setLayoutParams(rootLP);
                PlatFormInviteViewHolder viewHolder = new PlatFormInviteViewHolder((LinearLayout)llRoot);
                viewHolder.setPlatformShareListener(platformShareListener);
                return viewHolder;
            }
        };
    }

    public static interface OnPlatformShareListener {
        public void onPlatformShare(int var1);

        public void onReportClick();
    }
}

