/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.viewholder;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.appbase.extensions.ViewExtensionsKt;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.util.StatusUtil;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.invite.friend.view.InviteFollowView;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.relation.base.data.RelationInfo;
import com.yy.hiyo.relation.base.follow.view.IFollowClickInterceptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FriendViewHolder
extends BaseItemBinder.ViewHolder<InviteFriendData> {
    private View rootView;
    private CircleImageView avatarIv;
    private YYTextView nameTv;
    private YYTextView fromTv;
    private YYTextView statusTv;
    private InviteFollowView followTv;
    private YYView onlineView;
    private YYView typeIcon;
    private YYView topDivider;
    private OnItemClickListener itemInviteClickListener;
    private IChannel mChannel;

    public FriendViewHolder(View itemView, IChannel channel) {
        super(itemView);
        this.rootView = itemView;
        this.avatarIv = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
        this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
        this.fromTv = (YYTextView)itemView.findViewById(R.id.tv_from);
        this.statusTv = (YYTextView)itemView.findViewById(R.id.tv_status);
        this.followTv = (InviteFollowView)itemView.findViewById(R.id.tv_follow);
        this.onlineView = (YYView)itemView.findViewById(R.id.v_status);
        this.typeIcon = (YYView)itemView.findViewById(R.id.type_icon);
        this.topDivider = (YYView)itemView.findViewById(R.id.top_divider);
        ViewExtensionsKt.setRobotoMedium((TextView)this.statusTv);
        ViewExtensionsKt.setRobotoMedium((TextView)this.nameTv);
        ViewExtensionsKt.setRobotoRegular((TextView)this.fromTv);
        this.mChannel = channel;
    }

    public void setData(final InviteFriendData data2) {
        super.setData((Object)data2);
        this.followTv.bindFollowStatus(data2.mFriend.getUid());
        this.nameTv.setText((CharSequence)data2.mFriend.getNick());
        ImageLoader.loadBitmap((ImageView)this.avatarIv, (String)(data2.mFriend.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (int)AvatarUtils.getDefaultAvatar((int)data2.mFriend.getSex()));
        Drawable drawable2 = null;
        if (data2.channelMode == 1) {
            drawable2 = StatusUtil.getStatusBadge((int)data2.mFriend.getStatus());
            if (this.getLayoutPosition() == 1) {
                this.topDivider.setVisibility(0);
            } else {
                this.topDivider.setVisibility(8);
            }
        } else if (data2.mFriend.isOnline()) {
            drawable2 = data2.mFriend.isInGame() ? ResourceUtils.getDrawable((int)R.drawable.shape_in_game) : (data2.mFriend.isMatching() ? ResourceUtils.getDrawable((int)R.drawable.shape_in_team) : ResourceUtils.getDrawable((int)R.drawable.shape_online));
        }
        this.onlineView.setBackgroundDrawable(drawable2);
        this.updateTypeIcon(data2);
        this.updateBtn(data2);
        this.updateInviteState(data2.inviteState);
        long type = data2.mFriend.getType();
        if (type == 0L) {
            String nick = data2.mFriend.getAlias();
            if (nick != null && nick.length() > 12) {
                nick = nick.substring(0, 12) + "...";
            }
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_fb, (Object[])new Object[]{nick}));
        } else if (type == 1L) {
            String nick = data2.mFriend.getAlias();
            if (nick != null && nick.length() > 12) {
                nick = nick.substring(0, 12) + "...";
            }
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.xx_on_contact, (Object[])new Object[]{nick}));
        } else if (type == 7L) {
            this.fromTv.setVisibility(0);
            this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_follow_each_people));
        } else if (type == 11L) {
            if (data2.mFriend.getPartyGamePlayType() == 0L) {
                this.fromTv.setVisibility(8);
            } else if (this.mChannel == null || ServiceManagerProxy.getService(IGameInfoService.class) == null || this.mChannel.getPluginService() == null || this.mChannel.getPluginService().getCurPluginData() == null) {
                this.fromTv.setVisibility(8);
            } else {
                String gid = this.mChannel.getPluginService().getCurPluginData().getPluginId();
                GameInfo info = ((IGameInfoService)ServiceManagerProxy.getService(IGameInfoService.class)).getGameInfoByGid(gid);
                String gameName = info.getGname();
                if (TextUtils.isEmpty((CharSequence)gameName)) {
                    this.fromTv.setVisibility(8);
                } else {
                    if (data2.mFriend.getPartyGamePlayType() == 1L) {
                        this.fromTv.setVisibility(0);
                        this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_play_each_other, (Object[])new Object[]{gameName}));
                    } else if (data2.mFriend.getPartyGamePlayType() == 2L) {
                        this.fromTv.setVisibility(0);
                        this.fromTv.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_play_each_other_always, (Object[])new Object[]{gameName}));
                    } else {
                        this.fromTv.setVisibility(8);
                    }
                    this.reportLatentFriendShow(data2);
                }
            }
        } else {
            this.fromTv.setVisibility(8);
        }
        this.statusTv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if ((data2.inviteState == 3 || data2.inviteState == 1) && FriendViewHolder.this.itemInviteClickListener != null) {
                    FriendViewHolder.this.itemInviteClickListener.onInviteClicked(data2);
                }
            }
        });
        this.rootView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FriendViewHolder.this.itemInviteClickListener != null) {
                    FriendViewHolder.this.itemInviteClickListener.onInfoClicked(data2);
                }
            }
        });
        this.followTv.setClickInterceptor(new IFollowClickInterceptor(){

            public boolean interceptor(@NotNull RelationInfo followStatus) {
                if (FriendViewHolder.this.mChannel != null && FriendViewHolder.this.mChannel.getPluginService() != null && FriendViewHolder.this.mChannel.getPluginService().getCurPluginData() != null) {
                    String gid = FriendViewHolder.this.mChannel.getPluginService().getCurPluginData().getPluginId();
                    RoomTrack.INSTANCE.onLatentFollowFriendClick(gid, data2);
                }
                return false;
            }
        });
    }

    private void reportLatentFriendShow(InviteFriendData data2) {
        if (this.mChannel != null && this.mChannel.getPluginService() != null && this.mChannel.getPluginService().getCurPluginData() != null) {
            String gid = this.mChannel.getPluginService().getCurPluginData().getPluginId();
            RoomTrack.INSTANCE.onLatentFollowFriendShow(gid, data2);
        }
    }

    private void updateTypeIcon(InviteFriendData data2) {
        if (data2.mFriend.getbHagoFriend() == 1L || data2.mFriend.isOnline()) {
            this.onlineView.setVisibility(0);
            this.typeIcon.setVisibility(8);
            return;
        }
        switch ((int)data2.mFriend.getType()) {
            case 0: {
                this.onlineView.setVisibility(8);
                this.typeIcon.setVisibility(0);
                this.typeIcon.setBackgroundResource(R.drawable.icon_invite_type_fb);
                break;
            }
            case 1: {
                this.onlineView.setVisibility(8);
                this.typeIcon.setVisibility(0);
                this.typeIcon.setBackgroundResource(R.drawable.icon_invite_type_contact);
                break;
            }
            default: {
                this.onlineView.setVisibility(0);
                this.typeIcon.setVisibility(8);
            }
        }
    }

    private void updateBtn(InviteFriendData data2) {
        if (data2.mFriend.getbHagoFriend() == 1L) {
            this.followTv.setShown(false);
        } else {
            this.followTv.setShown(true);
        }
    }

    private void updateInviteState(int inviteState) {
        if (inviteState == 2) {
            this.updateStatusBtn("Invited", R.string.btn_invite_friend_invited);
            this.statusTv.setBackgroundResource(R.drawable.shape_invite_friend_status_disable);
            this.statusTv.setTextColor(ResourceUtils.getColor((int)R.color.white));
        } else if (inviteState == 3) {
            this.updateStatusBtn("Notify", R.string.btn_invite_friend_notifyable);
            this.statusTv.setBackgroundResource(R.drawable.shape_fff9e5_24dp_round);
            this.statusTv.setTextColor(Color.parseColor((String)"#FFC102"));
        } else if (inviteState == 4) {
            this.updateStatusBtn("Notified", R.string.btn_invite_friend_notified);
            this.statusTv.setBackgroundResource(R.drawable.shape_invite_friend_status_disable);
            this.statusTv.setTextColor(ResourceUtils.getColor((int)R.color.white));
        } else {
            this.updateStatusBtn("Invite", R.string.btn_invite_friend_invitable);
            this.statusTv.setBackgroundResource(R.drawable.shape_invite_friend_status_invitable);
            this.statusTv.setTextColor(ResourceUtils.getColor((int)R.color.white));
        }
    }

    private void updateStatusBtn(String enResid, int nResid) {
        if (StringUtils.equalsIgnoreCase((String)SystemUtils.getLang(), (String)"en")) {
            this.statusTv.setText((CharSequence)enResid);
        } else {
            this.statusTv.setText(nResid);
        }
    }

    public void setItemInviteClickListener(OnItemClickListener itemInviteClickListener) {
        this.itemInviteClickListener = itemInviteClickListener;
    }

    public static BaseItemBinder getItemBinder(final OnItemClickListener inviteClickListener, final IChannel channel) {
        return new BaseItemBinder<InviteFriendData, FriendViewHolder>(){

            @NonNull
            protected FriendViewHolder onCreateViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent) {
                View itemView = inflater.inflate(R.layout.item_invite_friend, parent, false);
                FriendViewHolder viewHolder = new FriendViewHolder(itemView, channel);
                viewHolder.setItemInviteClickListener(inviteClickListener);
                return viewHolder;
            }
        };
    }

    public void onPartialUpdate(InviteFriendData item, List<Object> payloads) {
        super.onPartialUpdate((Object)item, payloads);
        if (FP.empty(payloads)) {
            return;
        }
        if (payloads.get(0) instanceof Integer) {
            this.updateInviteState((Integer)payloads.get(0));
        }
    }

    public static interface OnItemClickListener {
        public void onInviteClicked(InviteFriendData var1);

        public void onInfoClicked(InviteFriendData var1);
    }
}

