/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend.behavior;

import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.util.RegionUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.invite.InvitePresenter;
import com.yy.hiyo.channel.component.invite.callback.IInviteAllCallback;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.behavior.AbsFriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.share.ChannelPlatformShareDataProvider;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.dataprovider.ShareDataProvider;
import java.util.List;
import net.ihago.room.srv.follow.EPath;
import net.ihago.room.srv.follow.InviteFansReq;
import net.ihago.room.srv.follow.InviteFansRes;
import okhttp3.Call;

public class DefaultFriendInviteBehavior
extends AbsFriendInviteBehavior {
    private static final String TAG = "FTVoiceRoomDefaultFriendInviteBehavior";
    private PlatformShareData mPlatformShareData;
    private ChannelPlatformShareDataProvider mShareDataProvider;
    private InvitePresenter.InviteClickListener listener;

    public DefaultFriendInviteBehavior(IMvpContext mvpContext, InvitePresenter.InviteClickListener listener2) {
        super(mvpContext);
        this.listener = listener2;
    }

    @Override
    public void onInviteFriend(final InviteFriendData data2, final IInviteFriendCallback callback2) {
        MLog.info((Object)TAG, (String)"onInviteFriend, uid=%d", (Object[])new Object[]{data2.mFriend.getUid()});
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canInvite()) {
            if (callback2 != null) {
                callback2.onFail(2);
            }
            return;
        }
        if (this.listener != null && data2.mFriend != null) {
            this.listener.onInvite(data2.mFriend.getUid());
        }
        if (this.getInviteData().inviteInterceptor != null && !this.getInviteData().inviteInterceptor.canCrossRegionInvite()) {
            ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(data2.mFriend.getUid(), new OnProfileListCallback(){

                public void onError(Call call, Exception e, int id2) {
                    if (callback2 != null) {
                        callback2.onFail(3);
                    }
                }

                public void onResponseError(int id2, String message, String response) {
                    if (callback2 != null) {
                        callback2.onFail(3);
                    }
                }

                public void onUISuccess(List<UserInfoBean> userInfo) {
                    if (FP.empty(userInfo)) {
                        if (callback2 != null) {
                            callback2.onFail(3);
                        }
                        return;
                    }
                    UserInfoBean targetUserInfo = userInfo.get(0);
                    String userRegion = targetUserInfo.getRegion();
                    String channelRegion = DefaultFriendInviteBehavior.this.getInviteData().channelRegion;
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"channelRegion=%s,userRegion=%s", (Object[])new Object[]{channelRegion, userRegion});
                    if (!FP.empty((CharSequence)userRegion) && RegionUtils.isNotSame((String)channelRegion, (String)userRegion)) {
                        if (callback2 != null) {
                            callback2.onFail(4);
                        }
                    } else {
                        DefaultFriendInviteBehavior.this.realInviteFriend(data2, callback2);
                    }
                }
            });
        } else {
            this.realInviteFriend(data2, callback2);
        }
    }

    private void realInviteFriend(final InviteFriendData data2, final IInviteFriendCallback callback2) {
        this.getInviteData().tokenProvider.getToken((DataCallback<String>)((DataCallback)token -> ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.getInviteData().ownerUid, new OnProfileCallback((String)token){
            final /* synthetic */ String val$token;
            {
                this.val$token = string2;
            }

            public void onSuccess(int id2, List<UserInfoKS> userInfoKSList) {
                if (FP.empty(userInfoKSList)) {
                    MLog.error((Object)DefaultFriendInviteBehavior.TAG, (String)"onInviteFriend get owner info error, list empty", (Object[])new Object[0]);
                    if (callback2 != null) {
                        callback2.onFail(3);
                    }
                    return;
                }
                YYTaskExecutor.execute(() -> {
                    Pair pair = ImDataFactory.INSTANCE.sendVioceRoomInviteMsg(data22.mFriend.getUid(), data22.mFriend.getAvatar(), data22.mFriend.getNick(), DefaultFriendInviteBehavior.this.getInviteData().channelId, DefaultFriendInviteBehavior.this.getInviteData().channelName, ((UserInfoKS)userInfoKSList.get((int)0)).avatar, this.val$token, DefaultFriendInviteBehavior.this.getInviteData().isSameCity, DefaultFriendInviteBehavior.this.getInviteData().sameCityInfo != null ? DefaultFriendInviteBehavior.this.getInviteData().sameCityInfo.getLocationTude() : "", DefaultFriendInviteBehavior.this.getFamilyDetailUrl(DefaultFriendInviteBehavior.this.getInviteData().channelId), data22.msg, DefaultFriendInviteBehavior.this.getInviteData().channelSource, data22.transKey, data22.transInfo, DefaultFriendInviteBehavior.this.getInviteData().pluginId);
                    ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                });
                if (callback2 != null) {
                    callback2.onSuccess();
                }
            }

            public void onFail(int id2, String msg, String response) {
                MLog.error((Object)DefaultFriendInviteBehavior.TAG, (String)("onInviteFriend get owner info error, " + msg), (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onFail(3);
                }
            }
        })));
    }

    @Override
    public void inviteAllFans(final String channelId, final String pid, final IInviteAllCallback callback2) {
        MLog.info((Object)TAG, (String)"inviteAllFans, channelId=%s, pid=%s", (Object[])new Object[]{channelId, pid});
        if (!TextUtils.isEmpty((CharSequence)pid)) {
            InviteFansReq req = new InviteFansReq.Builder().pid(pid).path(Integer.valueOf(EPath.PATH_CHANNEL.getValue())).build();
            ProtoManager.getInstance().sendHttp(channelId, (AndroidMessage)req, (IProtoCallback)new IProtoCallback<InviteFansRes>(){

                public void onResponse(@NonNull InviteFansRes message, long code, String msg) {
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"onResponse, code=%s, msg=%s", (Object[])new Object[]{code, msg});
                    if (ProtoManager.isSuccessCode((long)code)) {
                        if (callback2 != null) {
                            callback2.onSuccess(channelId, pid);
                        }
                    } else if (callback2 != null) {
                        callback2.onError((int)code);
                    }
                }

                public boolean retryWhenTimeout(boolean canRetry) {
                    if (callback2 != null) {
                        callback2.onError(-1);
                    }
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"retryWhenTimeout, canRetry=%s", (Object[])new Object[]{canRetry});
                    return false;
                }

                public boolean retryWhenError(boolean canRetry, String reason, int code) {
                    if (callback2 != null) {
                        callback2.onError(code);
                    }
                    MLog.info((Object)DefaultFriendInviteBehavior.TAG, (String)"retryWhenError, canRetry=%s, reason=%s, code=%s", (Object[])new Object[]{canRetry, reason, code});
                    return false;
                }
            });
        }
    }

    @Override
    public void onPlatformShare(int platformId) {
        super.onPlatformShare(platformId);
        if (platformId == 10) {
            RoomTrack.INSTANCE.reportCopyLinkInviteClick(this.getInviteData().channelId);
        } else {
            RoomTrack.INSTANCE.reportPlatformInviteClick(this.getInviteData().channelId, platformId);
        }
    }

    @Override
    public String getInviteTitle() {
        return ResourceUtils.getString((int)R.string.short_title_channel_invite_to_channel);
    }

    @Override
    public ShareDataProvider getShareDataProvider() {
        if (this.mShareDataProvider == null) {
            this.mShareDataProvider = new ChannelPlatformShareDataProvider();
            this.mShareDataProvider.setShareData(this.getPlatformShareData());
        }
        return this.mShareDataProvider;
    }

    @Override
    public PlatformShareData getPlatformShareData() {
        if (this.mPlatformShareData == null) {
            this.mPlatformShareData = new PlatformShareData();
            this.mPlatformShareData.setInviteData(this.getInviteData());
            List channelList = ((IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage(() -> "voice_room_enter_invite");
            this.mPlatformShareData.setChannelList(channelList);
        }
        return this.mPlatformShareData;
    }
}

