/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite.friend;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.GroupInviteListContactEntranceConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRecyclerViewKt;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.component.invite.base.IPanelPage;
import com.yy.hiyo.channel.component.invite.callback.IInviteAllCallback;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.FriendListCallback;
import com.yy.hiyo.channel.component.invite.friend.FriendListPageContext;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.data.BindFriendsBean;
import com.yy.hiyo.channel.component.invite.friend.data.BindFriendsModel;
import com.yy.hiyo.channel.component.invite.friend.data.FriendDataProvider;
import com.yy.hiyo.channel.component.invite.friend.data.NotifyFansData;
import com.yy.hiyo.channel.component.invite.friend.data.TitleBean;
import com.yy.hiyo.channel.component.invite.friend.share.PlatformShareData;
import com.yy.hiyo.channel.component.invite.friend.viewholder.BindFriendsViewHolder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.FriendViewHolder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.ListTitleViewHolder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.NotifyFansItemBinder;
import com.yy.hiyo.channel.component.invite.friend.viewholder.PlatformViewHolder;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.RelationNumInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.drakeet.multitype.ItemViewBinder;
import me.drakeet.multitype.MultiTypeAdapter;
import net.ihago.room.srv.follow.ECode;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"ViewConstructor"})
public class FriendListPage
extends YYFrameLayout
implements IPanelPage,
FriendViewHolder.OnItemClickListener,
PlatformViewHolder.OnPlatformShareListener,
NotifyFansItemBinder.OnItemClickListener,
View.OnClickListener {
    private IMvpContext mMvpContext;
    private CommonStatusLayout mStatusLayout;
    private RecyclerView mRecyclerView;
    private SmartRefreshLayout mRefreshLayout;
    private List<Object> mList = new ArrayList<Object>();
    private MultiTypeAdapter mAdapter;
    private FriendListCallback mListCallback;
    private FriendDataProvider mFriendDataProvider;
    private FriendInviteBehavior mFriendInviteBehavior;
    private IChannel mChannel;
    private BindFriendsModel mBindFriendsVM;
    private RelationNumInfo mRelationNumInfo;
    private GroupInviteListContactEntranceConfig mEntranceConfig;
    private int mFollowSizeThreshold = 0;
    private boolean mHasEntrance = false;
    private boolean mFbIsReportShow = false;
    private boolean mFbIsReportClick = false;
    private boolean mContactIsReportShow = false;
    private boolean mContactIsReportClick = false;
    private Observer mBindObserver = type -> {
        MLog.info((Object)"cpt", (String)("onChanged: \u76d1\u542c\u56de\u8c03 " + type), (Object[])new Object[0]);
        switch (type) {
            case 0: {
                this.hideContactEntrance(false);
                if (this.mFbIsReportClick) break;
                this.mFbIsReportClick = true;
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_succ").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "1").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
                break;
            }
            case 1: {
                this.hideContactEntrance(true);
                if (this.mContactIsReportClick) break;
                this.mContactIsReportClick = true;
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_succ").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "2").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
                break;
            }
            case 2: 
            case 4: {
                this.loadData();
                break;
            }
        }
    };

    public FriendListPage(@NotNull IMvpContext mvpContext, IChannel channel) {
        super(mvpContext.getContext());
        this.mMvpContext = new FriendListPageContext((View)this);
        this.mChannel = channel;
        this.createViews();
        this.mAdapter = new MultiTypeAdapter(this.mList);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.registerViewHolder();
        this.mBindFriendsVM = (BindFriendsModel)this.mMvpContext.getViewModel(BindFriendsModel.class);
        this.mBindFriendsVM.setContext((Activity)mvpContext.getContext());
        this.mBindFriendsVM.checkFacebook();
        this.mBindFriendsVM.checkContact();
    }

    private void createViews() {
        FriendListPage.inflate((Context)this.getContext(), (int)R.layout.dialog_invite_list_page_channel, (ViewGroup)this);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.status_layout);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refresh_layout);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.rv_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        if (this.mRecyclerView.getItemAnimator() instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        }
        this.mRefreshLayout.setEnableRefresh(false);
        this.mRefreshLayout.setEnableLoadMore(false);
    }

    public void setFriendDataProvider(FriendDataProvider friendDataProvider) {
        this.mFriendDataProvider = friendDataProvider;
    }

    public void setFriendInviteBehavior(FriendInviteBehavior friendInviteBehavior) {
        this.mFriendInviteBehavior = friendInviteBehavior;
    }

    public void setListCallback(FriendListCallback listCallback) {
        this.mListCallback = listCallback;
    }

    private void registerViewHolder() {
        this.mAdapter.register(PlatformShareData.class, (ItemViewBinder)PlatformViewHolder.getItemBinder(this, this.mChannel));
        this.mAdapter.register(TitleBean.class, ListTitleViewHolder.Companion.getItemBinder());
        this.mAdapter.register(BindFriendsBean.class, BindFriendsViewHolder.Companion.getItemBinder(this));
        this.mAdapter.register(InviteFriendData.class, (ItemViewBinder)FriendViewHolder.getItemBinder(this, this.mChannel));
        this.mAdapter.register(NotifyFansData.class, (ItemViewBinder)new NotifyFansItemBinder(this));
    }

    private void hideContactEntrance(boolean isContact) {
        if (this.mAdapter == null && this.mAdapter.getItems() == null) {
            return;
        }
        int index = -1;
        int contactIndex = -1;
        for (int i = 0; i < this.mAdapter.getItems().size(); ++i) {
            Object data2 = this.mAdapter.getItems().get(i);
            if (!(data2 instanceof BindFriendsBean)) continue;
            if (index == -1) {
                index = i;
            }
            if (!isContact || !"phone".equals(((BindFriendsBean)data2).getType())) continue;
            contactIndex = i;
        }
        if (isContact) {
            index = contactIndex;
        }
        if (index != -1) {
            this.mAdapter.getItems().remove(index);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    private void loadData() {
        if (this.mFriendDataProvider == null) {
            return;
        }
        this.mStatusLayout.showLoading();
        if (this.mChannel.getPluginService().getCurPluginData().mode == 1) {
            this.mRelationNumInfo = ((IRelationService)ServiceManagerProxy.getInstance().getService(IRelationService.class)).getRelationNum(AccountUtil.getUid(), true, null);
            this.mEntranceConfig = (GroupInviteListContactEntranceConfig)UnifyConfig.INSTANCE.fetchConfigData(BssCode.GROUP_INVITE_ENTRANCE_CONFIG, null);
            if (this.mEntranceConfig != null) {
                this.mFollowSizeThreshold = this.mEntranceConfig.getFollowSize();
            }
            this.mHasEntrance = this.mRelationNumInfo.getFollowNum() < (long)this.mFollowSizeThreshold;
        }
        this.mFriendDataProvider.fetchFriendData(this.mChannel.getPluginService().getCurPluginData().mode, (DataCallback<List<InviteFriendData>>)((DataCallback)result -> {
            this.mStatusLayout.hideLoading();
            this.mList.clear();
            this.mFriendInviteBehavior.getSendFamilyCallPermission((DataCallback<Boolean>)((DataCallback)hasPermission -> {
                PlatformShareData platformShareData = this.mFriendInviteBehavior.getPlatformShareData();
                boolean canSendFamilyCall = false;
                if (hasPermission != null) {
                    canSendFamilyCall = hasPermission;
                }
                platformShareData.setCanSendFamilyCall(canSendFamilyCall);
                this.mList.add(platformShareData);
                boolean handleResult = this.handleClassify((List<InviteFriendData>)result);
                if (FP.empty((Collection)result)) {
                    if (this.mChannel.getPluginService().getCurPluginData().mode == 1) {
                        if (!this.mHasEntrance || !this.mBindFriendsVM.hasContactEntrance() && !this.mBindFriendsVM.hasFbEntrance()) {
                            this.mStatusLayout.showNoData();
                        }
                    } else {
                        this.mStatusLayout.showNoData();
                    }
                } else if (handleResult) {
                    this.mList.addAll((Collection<Object>)result);
                }
                YYRecyclerViewKt.notifyDataSetChangedSafe((RecyclerView.Adapter)this.mAdapter, (RecyclerView)this.mRecyclerView);
            }));
        }));
    }

    private boolean handleClassify(List<InviteFriendData> result) {
        ArrayList<InviteFriendData> hagoFriendList = new ArrayList<InviteFriendData>();
        ArrayList<InviteFriendData> unHagoFriendList = new ArrayList<InviteFriendData>();
        if (this.mChannel.getPluginService().getCurPluginData().mode == 1) {
            if (this.mHasEntrance) {
                int position = 0;
                if (this.mBindFriendsVM.hasFbEntrance()) {
                    BindFriendsBean bindFriendsBean = new BindFriendsBean();
                    bindFriendsBean.setPosition(position);
                    this.mList.add(bindFriendsBean);
                    ++position;
                    if (!this.mFbIsReportShow) {
                        this.mFbIsReportShow = true;
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_show").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "1").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
                    }
                }
                if (this.mBindFriendsVM.hasContactEntrance()) {
                    BindFriendsBean bpht = new BindFriendsBean();
                    bpht.setType("phone");
                    bpht.setPosition(position);
                    this.mList.add(bpht);
                    if (!this.mContactIsReportShow) {
                        this.mContactIsReportShow = true;
                        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_show").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "2").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
                    }
                }
            }
            if (result != null && !result.isEmpty()) {
                for (InviteFriendData data2 : result) {
                    if (data2.mFriend.getbHagoFriend() == 1L) {
                        hagoFriendList.add(data2);
                        continue;
                    }
                    if (data2.mFriend.getType() == 1L && this.mBindFriendsVM.hasContactEntrance()) continue;
                    unHagoFriendList.add(data2);
                }
            }
            if (!hagoFriendList.isEmpty()) {
                this.mList.add(new TitleBean("Contact"));
                this.mList.addAll(hagoFriendList);
            }
            if (!unHagoFriendList.isEmpty()) {
                this.mList.add(new TitleBean("Suggest Friends"));
                this.mList.addAll(unHagoFriendList);
            }
        }
        return hagoFriendList.isEmpty() && unHagoFriendList.isEmpty();
    }

    private boolean isBaseChannel() {
        return this.mChannel.getPluginService().getCurPluginData().mode == 1;
    }

    @Override
    public void onInviteClicked(final InviteFriendData data2) {
        if (data2 == null || data2.mFriend == null) {
            return;
        }
        if (data2.inviteState == 3 && this.mChannel != null) {
            RoomTrack.INSTANCE.reportInviteOfflineClick(this.mChannel.getChannelId(), data2.mFriend.getUid());
        }
        if (this.mChannel != null && data2.mFriend != null) {
            String userType = "3";
            if (this.mChannel.getSeatService().isInSeat(AccountUtil.getUid())) {
                boolean isOwner = this.mChannel.getRoleService().isMeOwner();
                userType = isOwner ? "1" : "2";
            }
            RoomTrack.INSTANCE.onInviteFriendClick(this.mChannel.getChannelId(), userType, data2.mFriend.getUid() + "", "8");
            if (this.mChannel.getPluginService() != null && this.mChannel.getPluginService().getCurPluginData() != null) {
                RoomTrack.INSTANCE.onLatentInviteFriendClick(this.mChannel.getPluginService().getCurPluginData().getPluginId(), data2);
            }
        }
        if (this.mFriendInviteBehavior != null) {
            this.mFriendInviteBehavior.onInviteFriend(data2, new IInviteFriendCallback(){

                @Override
                public void onSuccess() {
                    data2.inviteState = data2.inviteState == 1 ? 2 : 4;
                    int index = FriendListPage.this.mList.indexOf(data2);
                    if (index >= 0 && index < FriendListPage.this.mList.size() && FriendListPage.this.mRecyclerView != null) {
                        if (FriendListPage.this.mRecyclerView.isComputingLayout()) {
                            FriendListPage.this.mAdapter.notifyItemChanged(index);
                        } else {
                            FriendListPage.this.mRecyclerView.post(() -> FriendListPage.this.mAdapter.notifyItemChanged(index));
                        }
                    }
                    if (FriendListPage.this.mListCallback != null) {
                        FriendListPage.this.mListCallback.onInviteFriendSuccess(data2.mFriend.getUid());
                    }
                }

                @Override
                public void onFail(int code) {
                    if (code == 4) {
                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_cross_region_invite_channel, (int)0);
                    }
                }
            });
        }
    }

    @Override
    public void onInfoClicked(InviteFriendData data2) {
        if (data2 == null || data2.mFriend == null) {
            return;
        }
        if (this.mListCallback != null) {
            this.mListCallback.onAvatarClick(data2);
        }
    }

    @Override
    public void onPlatformShare(int channelId) {
        if (this.mFriendInviteBehavior != null) {
            this.mFriendInviteBehavior.onPlatformShare(channelId);
        }
        if (this.mListCallback != null) {
            this.mListCallback.onPlatformShareClick(channelId);
        }
    }

    @Override
    public void onSendFamilyCall() {
        if (this.mListCallback != null) {
            this.mListCallback.onSendFamilyCallClick();
        }
    }

    @Override
    public void onNotifyFansClick(final NotifyFansData data2) {
        if (data2.getInviteState() == 3) {
            final String cid = this.mChannel.getChannelId();
            final String pluginId = this.mChannel.getPluginService().getCurPluginData().getPluginId();
            this.mFriendInviteBehavior.inviteAllFans(cid, pluginId, new IInviteAllCallback(){

                @Override
                public void onSuccess(@NotNull String channelId, @NotNull String pid) {
                    if (StringUtils.equal((String)channelId, (String)cid) && StringUtils.equal((String)pid, (String)pluginId)) {
                        int index;
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_success);
                        data2.setInviteState(4);
                        if (FriendListPage.this.mList != null && FriendListPage.this.mAdapter != null && (index = FriendListPage.this.mList.indexOf(data2)) >= 0 && index < FriendListPage.this.mList.size()) {
                            FriendListPage.this.mAdapter.notifyItemChanged(index);
                        }
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click_result_back").put("result_type", "1").put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
                }

                @Override
                public void onError(int code) {
                    if (code == ECode.ErrNotifyExceedOneDayLimit.getValue()) {
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_limit_one_day);
                    } else if (code == ECode.ErrNotifyTooBusy.getValue()) {
                        ToastUtils.showToast((Context)FriendListPage.this.mMvpContext.getContext(), (int)R.string.short_tips_notify_limit_too_busy);
                    }
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click_result_back").put("result_type", "2").put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
                }
            });
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "one_invite_but_click").put("gid", pluginId).put("room_id", cid).put("room_model", RadioUtils.INSTANCE.getMVideoMode()));
        }
    }

    @Override
    public void onShow() {
        this.loadData();
        this.mBindFriendsVM.getMFbStateChange().observe((LifecycleOwner)this.mMvpContext.getLifecycleOwner(), this.mBindObserver);
        this.mBindFriendsVM.getMContactStateChange().observe((LifecycleOwner)this.mMvpContext.getLifecycleOwner(), this.mBindObserver);
        if (this.mChannel == null) {
            return;
        }
        if (this.mChannel.getRoleService().isMeOwner() || this.mChannel.getRoleService().isMeAnchor()) {
            RoomTrack.INSTANCE.onVoiceRoomOwnerInviteListShow(this.mChannel.getChannelId(), RadioUtils.INSTANCE.getMVideoMode());
        }
    }

    @Override
    public void onHide() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mMvpContext.onDestroy();
    }

    @Override
    public View getPage() {
        return this;
    }

    public void onClick(View v) {
        switch (v.getTag().toString()) {
            case "fb": {
                this.mBindFriendsVM.facebookAction();
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_click").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "1").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
                break;
            }
            case "phone": {
                this.mBindFriendsVM.contactAction((Activity)this.mMvpContext.getContext());
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028823").put("function_id", "enable_click").put("room_id", this.mChannel.getChannelId()).put("user_role", String.valueOf(RoomTrack.INSTANCE.getUserRole(this.mChannel.getChannelId()))).put("enable_type", "2").put("gid", this.mChannel.getBaseRoomGameService().getGameContextData().getGameId()));
            }
        }
    }
}

