/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.invite;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.common.DataCallback;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.invite.InviteFriendData;
import com.yy.appbase.kvo.FindFriend;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IBaseEnvService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.appbase.ui.widget.tablayout.OnTabSelectListener;
import com.yy.appbase.unifyconfig.config.ShareTeamUpConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.channel.base.bean.HonorBean;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.component.familygroup.familycall.FamilyCallPresenter;
import com.yy.hiyo.channel.component.invite.InvitePageProvider;
import com.yy.hiyo.channel.component.invite.InvitePanel;
import com.yy.hiyo.channel.component.invite.base.OnlineBean;
import com.yy.hiyo.channel.component.invite.callback.IInviteFriendCallback;
import com.yy.hiyo.channel.component.invite.friend.FriendListCallback;
import com.yy.hiyo.channel.component.invite.friend.FriendListPage;
import com.yy.hiyo.channel.component.invite.friend.behavior.DefaultFriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.behavior.FriendInviteBehavior;
import com.yy.hiyo.channel.component.invite.friend.data.AbsTokenProvider;
import com.yy.hiyo.channel.component.invite.friend.data.FriendDataProvider;
import com.yy.hiyo.channel.component.invite.friend.data.InviteData;
import com.yy.hiyo.channel.component.invite.friend.data.InviteInterceptor;
import com.yy.hiyo.channel.component.invite.friend.share.RadioShareReport;
import com.yy.hiyo.channel.component.invite.online.OnlineListCallback;
import com.yy.hiyo.channel.component.invite.online.OnlineListComponent;
import com.yy.hiyo.channel.component.invite.online.OnlineListPanel;
import com.yy.hiyo.channel.component.invite.online.OnlineListWithInvite;
import com.yy.hiyo.channel.component.invite.online.OnlineListWithPotentialGuide;
import com.yy.hiyo.channel.component.invite.online.OnlineTrack;
import com.yy.hiyo.channel.component.invite.online.data.DefaultOnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.data.OnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.data.PotentialOnlineDataProvider;
import com.yy.hiyo.channel.component.invite.online.handler.NoInviteHandler;
import com.yy.hiyo.channel.component.invite.online.handler.OnlineInviteHandler;
import com.yy.hiyo.channel.component.invite.online.search.OnlineUserSearchReporter;
import com.yy.hiyo.channel.component.invite.online.search.OnlineUserSearchUiCallback;
import com.yy.hiyo.channel.component.invite.voiceroom.SeatInviteHandler;
import com.yy.hiyo.channel.component.profile.profilecard.base.ProfileCardPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ShareChannelIdDef;
import com.yy.hiyo.user.base.profilecard.OpenProfileFrom;
import com.yy.hiyo.user.base.service.IUserLevelDataService;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;

public class InvitePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>> {
    private static final String TAG = "FTVoiceRoomInvitePresenter";
    @SuppressLint(value={"StaticFieldLeak"})
    protected BasePanel mCurrPanel;
    private OnlineListCallback mOnlineListCallback;
    private FriendListCallback mFriendListCallback;
    protected OnlineDataProvider mOnlineDataProvider;
    protected OnlineDataProvider mPotentialProvider;
    private FriendDataProvider mFriendDataProvider;
    private OnlineUserSearchUiCallback mSearchUiCallback;

    public void showOnlineListPanel() {
        if (this.isOwnerOrMaster() || this.getChannel().getRoleService().isMeAnchor()) {
            this.showOnlineListPanel(new SeatInviteHandler((IChannel)this.getChannel()));
        } else {
            this.showOnlineListPanel(new NoInviteHandler());
        }
    }

    public void onPageAttach(@NotNull AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach && ((IChannelPageContext)this.getMvpContext()).getEnterChannelParams().entry == 178) {
            this.showFriendInvitePanel(null);
            long enterUid = ((IChannelPageContext)this.getMvpContext()).getEnterChannelParams().enterUid;
            if (enterUid == 0L) {
                return;
            }
            this.sendInvite(enterUid);
        }
    }

    public void showOnlineListPanel(@NonNull OnlineInviteHandler onlineInviteHandler) {
        boolean isBaseMode;
        MLog.info((Object)TAG, (String)"showOnlineListPanel", (Object[])new Object[0]);
        if (this.getWindow() == null) {
            MLog.error((Object)TAG, (String)"window is null", (Object[])new Object[0]);
            return;
        }
        if (this.mCurrPanel != null) {
            this.getWindow().getPanelLayer().hidePanel(this.mCurrPanel, true);
        }
        OnlineListPanel onlineListPanel = new OnlineListPanel((Context)((IChannelPageContext)this.getMvpContext()).getContext(), this.getMvpContext());
        boolean bl = isBaseMode = this.getPluginMode() == 1;
        if (isBaseMode) {
            onlineListPanel.setHasShowSearchIconPermission(true);
        } else {
            boolean isOwnerOrMaster = this.getChannel().getRoleService().isOwnerOrMaster(AccountUtil.getUid());
            onlineListPanel.setHasShowSearchIconPermission(isOwnerOrMaster);
        }
        onlineListPanel.setInviteHandler(onlineInviteHandler);
        onlineListPanel.setPages(this.getOnlinePages(onlineInviteHandler));
        onlineListPanel.setOnPotentialTabSelectListener(() -> OnlineTrack.reportPotentialTabSelect(this.getPluginMode(), this.getPluginId(), this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 15));
        onlineListPanel.setSearchUiCallback(this.getSearchUiCallback());
        this.getWindow().getPanelLayer().showPanel((BasePanel)onlineListPanel, true);
        this.mCurrPanel = onlineListPanel;
        OnlineUserSearchReporter.INSTANCE.setChannel((IChannel)this.getChannel());
    }

    private List<OnlineListPanel.PageData> getOnlinePages(@NonNull OnlineInviteHandler onlineInviteHandler) {
        ArrayList<OnlineListPanel.PageData> pageList = new ArrayList<OnlineListPanel.PageData>();
        OnlineListWithInvite listWithInvite = new OnlineListWithInvite((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        OnlineListComponent onlinePage = new OnlineListComponent(this.getMvpContext());
        onlinePage.setInviteHandler(onlineInviteHandler);
        onlinePage.setDataProvider(this.getOnlineDataProvider());
        onlinePage.setListCallback(this.getOnlineListCallback());
        listWithInvite.addOnlineListView(onlinePage);
        pageList.add(new OnlineListPanel.PageData(R.string.tab_online_user_num, listWithInvite, this.getOnlineDataProvider().getOnlineCount()));
        if (this.isOwnerOrMaster() && this.getPluginMode() != 1) {
            OnlineListWithPotentialGuide potentialPage = new OnlineListWithPotentialGuide((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            OnlineListComponent potentialOnline = new OnlineListComponent(this.getMvpContext());
            potentialOnline.setInviteHandler(onlineInviteHandler);
            potentialOnline.setDataProvider(this.getPotentialDataProvider());
            potentialOnline.setListCallback(new OnlineListCallback(){

                @Override
                public void onAvatarClick(OnlineBean onlineBean) {
                    InvitePresenter.this.openProfileCard(onlineBean.uid, true, OpenProfileFrom.FROM_ONLINE);
                    OnlineTrack.reportPotentialItemClick(InvitePresenter.this.getPluginMode(), InvitePresenter.this.getPluginId(), InvitePresenter.this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 15);
                }

                @Override
                public void onMedalClick(HonorBean honorBean, long ownerUid) {
                    ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).onMedalClick(honorBean.getId(), ownerUid);
                }

                @Override
                @javax.annotation.Nullable
                public IMvpContext getMvpContext() {
                    return InvitePresenter.this.getMvpContext();
                }
            });
            potentialPage.addOnlineListView(potentialOnline);
            pageList.add(new OnlineListPanel.PageData(R.string.tab_potential_online_user_num, potentialPage, this.getPotentialDataProvider().getOnlineCount()));
        }
        return pageList;
    }

    public void showOnlineInvitePanel(@NonNull OnlineInviteHandler onlineInviteHandler) {
        this.showOnlineInvitePanel(onlineInviteHandler, new DefaultFriendInviteBehavior(this.getMvpContext(), null));
    }

    public void showOnlineInvitePanel(@NonNull OnlineInviteHandler onlineInviteHandler, @NonNull FriendInviteBehavior friendInviteBehavior) {
        this.showOnlineInvitePanel(onlineInviteHandler, friendInviteBehavior, null);
    }

    public void showOnlineInvitePanel(@NonNull OnlineInviteHandler onlineInviteHandler, @NonNull FriendInviteBehavior friendInviteBehavior, OnTabSelectListener tabSelectListener) {
        this.showOnlineInvitePanel(onlineInviteHandler, friendInviteBehavior, tabSelectListener, null);
    }

    public void showOnlineInvitePanel(final @NonNull OnlineInviteHandler onlineInviteHandler, final @NonNull FriendInviteBehavior friendInviteBehavior, final OnTabSelectListener tabSelectListener, BasePanel.IPanelListener panelListener2) {
        MLog.info((Object)TAG, (String)"showOnlineInvitePanel", (Object[])new Object[0]);
        this.showInvitePanel(new InvitePageProvider(){

            @Override
            public List<InvitePanel.PageData> getPages(@NonNull IMvpContext mvpContext) {
                ArrayList<InvitePanel.PageData> pageDataList = new ArrayList<InvitePanel.PageData>();
                OnlineListComponent onlineListComponent = new OnlineListComponent(InvitePresenter.this.getMvpContext());
                onlineListComponent.setInviteHandler(onlineInviteHandler);
                onlineListComponent.setDataProvider(InvitePresenter.this.getOnlineDataProvider());
                onlineListComponent.setListCallback(InvitePresenter.this.getOnlineListCallback());
                pageDataList.add(new InvitePanel.PageData(onlineInviteHandler.getInviteTitle(), onlineListComponent));
                FriendListPage friendListPage = new FriendListPage(InvitePresenter.this.getMvpContext(), (IChannel)InvitePresenter.this.getChannel());
                friendInviteBehavior.attachBaseInviteData(InvitePresenter.this.buildInviteData());
                friendListPage.setFriendInviteBehavior(friendInviteBehavior);
                friendListPage.setFriendDataProvider(InvitePresenter.this.getFriendDataProvider());
                friendListPage.setListCallback(InvitePresenter.this.getFriendListCallback());
                pageDataList.add(new InvitePanel.PageData(ResourceUtils.getString((int)R.string.short_title_channel_invite_to_channel), friendListPage));
                return pageDataList;
            }

            @Override
            public OnTabSelectListener getTabSelectListener() {
                return tabSelectListener;
            }
        }, panelListener2);
    }

    public void showFriendInvitePanel(InviteClickListener listener2) {
        this.showFriendInvitePanel(new DefaultFriendInviteBehavior(this.getMvpContext(), listener2), null);
    }

    public void showFriendInvitePanel(final @NonNull FriendInviteBehavior friendInviteBehavior, BasePanel.IPanelListener panelListener2) {
        MLog.info((Object)TAG, (String)"showFriendInvitePanel", (Object[])new Object[0]);
        this.showInvitePanel(new InvitePageProvider(){

            @Override
            public List<InvitePanel.PageData> getPages(@NonNull IMvpContext mvpContext) {
                ArrayList<InvitePanel.PageData> pageDataList = new ArrayList<InvitePanel.PageData>();
                FriendListPage friendListPage = new FriendListPage(InvitePresenter.this.getMvpContext(), (IChannel)InvitePresenter.this.getChannel());
                friendInviteBehavior.attachBaseInviteData(InvitePresenter.this.buildInviteData());
                friendListPage.setFriendInviteBehavior(friendInviteBehavior);
                friendListPage.setListCallback(InvitePresenter.this.getFriendListCallback());
                friendListPage.setFriendDataProvider(InvitePresenter.this.getFriendDataProvider());
                String inviteTitle = friendInviteBehavior.getInviteTitle();
                if (InvitePresenter.this.getChannelDetailInfo().baseInfo.isAmongUs()) {
                    inviteTitle = ResourceUtils.getString((int)R.string.among_us_invite_title);
                }
                pageDataList.add(new InvitePanel.PageData(inviteTitle, friendListPage));
                return pageDataList;
            }

            @Override
            public OnTabSelectListener getTabSelectListener() {
                return null;
            }
        }, panelListener2);
    }

    private void showInvitePanel(InvitePageProvider pageProvider, BasePanel.IPanelListener panelListener2) {
        if (null == this.getCurrentWindow()) {
            MLog.error((Object)TAG, (String)"window is null", (Object[])new Object[0]);
            return;
        }
        if (this.mCurrPanel != null) {
            this.getCurrentWindow().getPanelLayer().hidePanel(this.mCurrPanel, true);
        }
        InvitePanel panel2 = new InvitePanel(this.getMvpContext(), pageProvider);
        panel2.setListener(panelListener2);
        this.getCurrentWindow().getPanelLayer().showPanel((BasePanel)panel2, true);
        this.mCurrPanel = panel2;
    }

    private DefaultWindow getCurrentWindow() {
        return (DefaultWindow)((IBaseEnvService)ServiceManagerProxy.getServiceManager().getService(IBaseEnvService.class)).getBaseAEnv().getWindowManager().getCurrentWindow();
    }

    private OnlineListCallback getOnlineListCallback() {
        if (this.mOnlineListCallback == null) {
            this.mOnlineListCallback = new OnlineListCallback(){

                @Override
                public void onAvatarClick(OnlineBean onlineBean) {
                    InvitePresenter.this.openProfileCard(onlineBean.uid, true, OpenProfileFrom.FROM_ONLINE);
                }

                @Override
                public void onMedalClick(HonorBean honorBean, long ownerUid) {
                    ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).onMedalClick(honorBean.getId(), ownerUid);
                }

                @Override
                @javax.annotation.Nullable
                public IMvpContext getMvpContext() {
                    return InvitePresenter.this.getMvpContext();
                }
            };
        }
        return this.mOnlineListCallback;
    }

    private FriendListCallback getFriendListCallback() {
        if (this.mFriendListCallback == null) {
            this.mFriendListCallback = new FriendListCallback(){

                @Override
                public void onAvatarClick(InviteFriendData data2) {
                    InvitePresenter.this.openProfileCard(data2.mFriend.getUid(), false, OpenProfileFrom.FROM_INVITE);
                }

                @Override
                public void onPlatformShareClick(int channelId) {
                    if (channelId != -1 && channelId != 10 && ChannelDefine.isRadioMode((int)InvitePresenter.this.getChannel().getPluginService().getCurPluginData().mode) && ((IIntlShareService)ServiceManagerProxy.getServiceManager().getService(IIntlShareService.class)).checkAppInstalled(channelId)) {
                        UserInfoKS myUserInfo = ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(AccountUtil.getUid(), null);
                        String content = ResourceUtils.getString((int)R.string.short_tips_share_msg, (Object[])new Object[]{myUserInfo.getNick()});
                        if (ServiceManagerProxy.getService(IPublicScreenService.class) != null && ((IPublicScreenModulePresenter)InvitePresenter.this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter() != null) {
                            BaseImMsg thxMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalAvatarTextMsg(InvitePresenter.this.getChannelId(), (CharSequence)content, ((IChannelPageContext)InvitePresenter.this.getMvpContext()).getChannel().getRoleService().getMyRoleCache(), myUserInfo.getUid(), myUserInfo.getAvatar(), 2);
                            thxMsg.setMsgState(1);
                            ((IPublicScreenModulePresenter)InvitePresenter.this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsgAndSendToServer(thxMsg);
                        }
                    }
                    InvitePresenter.this.reportSharePlatform(channelId);
                }

                @Override
                public void onInviteFriendSuccess(long uid) {
                    InvitePresenter.this.reportInviteFriend(uid);
                    new RadioShareReport((IChannel)InvitePresenter.this.getChannel()).onShareSuccess(13);
                }

                @Override
                public void onSendFamilyCallClick() {
                    ((FamilyCallPresenter)InvitePresenter.this.getPresenter(FamilyCallPresenter.class)).showFamilyCallPanel(1);
                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60080028").put("function_id", "entry_click"));
                }
            };
        }
        return this.mFriendListCallback;
    }

    private OnlineUserSearchUiCallback getSearchUiCallback() {
        if (this.mSearchUiCallback == null) {
            this.mSearchUiCallback = new OnlineUserSearchUiCallback(){

                @Override
                public void onProfileClick(long uid) {
                    InvitePresenter.this.openProfileCard(uid, true, OpenProfileFrom.FROM_ONLINE);
                }
            };
        }
        return this.mSearchUiCallback;
    }

    private void reportSharePlatform(int channelId) {
        MLog.debug((Object)TAG, (String)("reportSharePlatform platformID = " + channelId), (Object[])new Object[0]);
        if (!ChannelDefine.isBaseMode((int)this.getChannel().getPluginService().getCurPluginData().mode) && channelId != -1 && channelId != 10) {
            int platformId = this.getPlatformId(channelId);
            if (platformId != -1) {
                AbsPlatformAdapter platform = ThirdPartyPlatformHelper.getInstance().getPlatform(platformId);
                if (platform != null && platform.isPlatformInstall()) {
                    ((IUserLevelDataService)ServiceManagerProxy.getService(IUserLevelDataService.class)).reportShare2Platform(this.getChannelId(), ShareChannelIdDef.getChannelNameById((int)channelId));
                }
            } else {
                ((IUserLevelDataService)ServiceManagerProxy.getService(IUserLevelDataService.class)).reportShare2Platform(this.getChannelId(), ShareChannelIdDef.getChannelNameById((int)channelId));
            }
        }
    }

    private void reportInviteFriend(long uid) {
        MLog.debug((Object)TAG, (String)("reportInviteFriend uid = " + uid), (Object[])new Object[0]);
        if (!ChannelDefine.isBaseMode((int)this.getChannel().getPluginService().getCurPluginData().mode)) {
            ((IUserLevelDataService)ServiceManagerProxy.getService(IUserLevelDataService.class)).reportShare2Friend(this.getChannelId(), uid);
        }
    }

    private int getPlatformId(int channelId) {
        int platformId = -1;
        switch (channelId) {
            case 7: {
                platformId = 14;
                break;
            }
            case 1: {
                platformId = 1;
                break;
            }
            case 2: {
                platformId = 2;
                break;
            }
            case 3: {
                platformId = 3;
                break;
            }
            case 11: {
                platformId = 9;
                break;
            }
        }
        return platformId;
    }

    protected OnlineDataProvider getOnlineDataProvider() {
        if (this.mOnlineDataProvider == null) {
            this.mOnlineDataProvider = new DefaultOnlineDataProvider((IChannel)this.getChannel());
        }
        return this.mOnlineDataProvider;
    }

    private OnlineDataProvider getPotentialDataProvider() {
        if (this.mPotentialProvider == null) {
            this.mPotentialProvider = new PotentialOnlineDataProvider((IChannel)this.getChannel());
        }
        return this.mPotentialProvider;
    }

    private FriendDataProvider getFriendDataProvider() {
        if (this.mFriendDataProvider == null) {
            this.mFriendDataProvider = new FriendDataProvider((IChannel)this.getChannel());
        }
        return this.mFriendDataProvider;
    }

    private InviteData buildInviteData() {
        InviteData inviteData = new InviteData();
        inviteData.pluginId = this.getPluginId();
        inviteData.channelId = this.getChannelId();
        inviteData.channelName = this.getChannelName();
        inviteData.setRoomType(this.getPluginMode());
        if (this.getChannel() != null && this.getChannel().getPluginService().getCurPluginData() != null) {
            inviteData.setSecondRoomType(this.getChannel().getPluginService().getCurPluginData());
        }
        inviteData.channelCover = this.buildChannelCover(inviteData.roomType);
        if (inviteData.roomType == 4) {
            inviteData.bannerUrl = ShareTeamUpConfig.Companion.getImg(this.getPluginId());
        }
        inviteData.onlineCount = this.getChannelOnlineCount();
        inviteData.uid = AccountUtil.getUid();
        inviteData.ownerUid = this.getChannelDetailInfo().baseInfo.ownerUid;
        inviteData.isSameCity = this.getChannelDetailInfo().baseInfo.isSameCity;
        inviteData.sameCityInfo = this.getChannelDetailInfo().baseInfo.sameCityInfo;
        inviteData.channelRegion = this.getChannelDetailInfo().baseInfo.region.region;
        inviteData.isFamily = this.getChannelDetailInfo().baseInfo.isFamily();
        inviteData.familyService = this.getChannel().getFamilyService();
        inviteData.tokenProvider = new AbsTokenProvider(){

            @Override
            public void fetchToken(final @NotNull DataCallback<String> cb) {
                if (InvitePresenter.this.isDestroyed()) {
                    cb.onResult((Object)"");
                    return;
                }
                InvitePresenter.this.getChannel().getDataService().getInviteEnterToken(new IDataService.IGetInviteTokenCallBack(){

                    public void onSuccess(String cid, String enterToken) {
                        cb.onResult((Object)enterToken);
                    }

                    public void onError(String cid, int errorCode, String errorTips, Exception e) {
                        MLog.error((Object)InvitePresenter.TAG, (String)"getInviteEnterToken error, code=%d, msg=%d", (Object[])new Object[]{errorCode, errorTips});
                        cb.onResult((Object)"");
                    }
                });
            }
        };
        inviteData.inviteInterceptor = new InviteInterceptor(){

            @Override
            public boolean canCrossRegionInvite() {
                return InvitePresenter.this.getChannel().getPluginService().getCurPluginData().mode == 14;
            }

            @Override
            public boolean canInvite() {
                if (InvitePresenter.this.isDestroyed()) {
                    return false;
                }
                if (InvitePresenter.this.isChannelPrivate() && !InvitePresenter.this.isAmongUs() && !InvitePresenter.this.isOwnerOrMaster() && !InvitePresenter.this.getChannel().getRoleService().isMeAnchor()) {
                    OkDialog dialog2 = new OkDialog((CharSequence)ResourceUtils.getString((int)R.string.short_tips_private_channel_invite), true, new OkDialogListener(){

                        public void onOk() {
                        }
                    });
                    dialog2.setShowCancel(false);
                    ((IChannelPageContext)InvitePresenter.this.getMvpContext()).getDialogLinkManager().showDialog((BaseDialog)dialog2);
                    return false;
                }
                return true;
            }
        };
        inviteData.channelSource = this.getChannelDetailInfo().baseInfo.source;
        return inviteData;
    }

    private boolean isAmongUs() {
        return this.getChannelDetailInfo().baseInfo.isAmongUs();
    }

    public void hidePanel() {
        if (null == this.getWindow()) {
            MLog.error((Object)TAG, (String)"window is null", (Object[])new Object[0]);
            return;
        }
        if (this.mCurrPanel != null) {
            this.getWindow().getPanelLayer().hidePanel(this.mCurrPanel, true);
        }
    }

    private void openProfileCard(long uid, boolean inChannel, OpenProfileFrom from) {
        if (this.isDestroyed()) {
            return;
        }
        ((ProfileCardPresenter)this.getPresenter(ProfileCardPresenter.class)).showProfileCard(uid, inChannel, from);
    }

    protected boolean isOwnerOrMaster() {
        return this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 15 || this.getChannel().getRoleService().getRoleCache(AccountUtil.getUid()) == 10;
    }

    private long getChannelOnlineCount() {
        return this.getChannelDetailInfo().dynamicInfo.onlines;
    }

    private boolean isChannelPrivate() {
        return this.getChannelDetailInfo().baseInfo.isPrivate;
    }

    public boolean isBaseMode() {
        return this.getChannel().getPluginService().getCurPluginData().getMode() == 1;
    }

    private String buildChannelCover(int roomType) {
        String cover = "";
        if (roomType == 2) {
            cover = this.getChannelDetailInfo().baseInfo.roomAvatar;
        } else if (roomType == 3) {
            cover = this.getChannelDetailInfo().baseInfo.avatar;
        }
        if (StringUtils.isEmpty((String)cover) || "https://o-static.ihago.net/ikxd/22e01f3a0ae739ace0d43f4216037839/groupframe.png".equals(cover)) {
            UserInfoBean userInfo;
            long uid = this.getChannel().getOwnerUid();
            if (this.getChannelDetailInfo().baseInfo.showUid != 0L) {
                uid = this.getChannelDetailInfo().baseInfo.showUid;
            }
            if ((userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid, null)) != null) {
                cover = userInfo.getAvatar();
            }
        }
        return cover;
    }

    public void copyShareLink() {
        DefaultFriendInviteBehavior behavior = new DefaultFriendInviteBehavior(this.getMvpContext(), null);
        behavior.attachBaseInviteData(this.buildInviteData());
        behavior.onPlatformShare(10);
    }

    public void inviteDir(long uid, final String transKey, final String transInfo, final @Nullable ICommonCallback<Boolean> callback2) {
        MLog.info((Object)TAG, (String)"inviteDir uid:%s, key:%s, trans:%s", (Object[])new Object[]{uid, transKey, transInfo});
        final DefaultFriendInviteBehavior defaultFriendInviteBehavior = new DefaultFriendInviteBehavior(this.getMvpContext(), null);
        defaultFriendInviteBehavior.attachBaseInviteData(this.buildInviteData());
        ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(uid, new OnProfileListCallback(){

            public void onUISuccess(List<UserInfoBean> userInfo) {
                FindFriend friend = FindFriend.transform((UserInfoBean)userInfo.get(0));
                InviteFriendData inviteFriendData = new InviteFriendData(friend);
                inviteFriendData.transInfo = transInfo;
                inviteFriendData.transKey = transKey;
                defaultFriendInviteBehavior.onInviteFriend(inviteFriendData, new IInviteFriendCallback(){

                    @Override
                    public void onSuccess() {
                        if (callback2 != null) {
                            callback2.onSuccess((Object)true, new Object[0]);
                        }
                    }

                    @Override
                    public void onFail(int code) {
                        MLog.error((Object)InvitePresenter.TAG, (String)"inviteDir onFail code:%s", (Object[])new Object[]{code});
                        if (callback2 != null) {
                            callback2.onFail(code, "", new Object[0]);
                        }
                    }
                });
            }

            public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                String s = StringUtils.formatWitUSLocal((String)"inviteDir onError call:%s, e:%s, id:%s", (Object[])new Object[]{call, e, id2});
                MLog.error((Object)InvitePresenter.TAG, (String)s, (Object[])new Object[0]);
                callback2.onFail(-1, s, new Object[0]);
            }

            public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                String s = StringUtils.formatWitUSLocal((String)"inviteDir onResponseErro message:%s, resp:%s", (Object[])new Object[]{message, response});
                MLog.error((Object)InvitePresenter.TAG, (String)s, (Object[])new Object[0]);
                callback2.onFail(-2, s, new Object[0]);
            }
        });
    }

    private void sendInvite(long enterUid) {
        DefaultFriendInviteBehavior inviteBehavior = new DefaultFriendInviteBehavior(this.getMvpContext(), null);
        inviteBehavior.attachBaseInviteData(this.buildInviteData());
        UserInfoBean userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(enterUid, null);
        FindFriend friend = FindFriend.transform((UserInfoBean)userInfo);
        InviteFriendData inviteFriendData = new InviteFriendData(friend);
        inviteBehavior.onInviteFriend(inviteFriendData, null);
    }

    public static interface InviteClickListener {
        public void onInvite(long var1);
    }
}

