/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.hat;

import android.os.SystemClock;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.base.bean.HatChangeNotifyData;
import com.yy.hiyo.channel.base.service.IGfPrivilegeService;
import com.yy.hiyo.channel.component.hat.HatDataModel;
import com.yy.hiyo.channel.component.hat.HatService;
import com.yy.hiyo.channel.component.hat.IChannelHatService;
import com.yy.hiyo.channel.component.hat.data.HatConfigInfo;
import com.yy.hiyo.channel.component.hat.data.UserHatData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.privilege.GetHatCfgRes;
import net.ihago.money.api.privilege.GetRoomSeatHatsRes;
import net.ihago.money.api.privilege.HatInfo;
import net.ihago.money.api.privilege.UserHatInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0011H\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020\u0019H\u0002J\b\u0010!\u001a\u00020\u0019H\u0002J\b\u0010\"\u001a\u00020\u0019H\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\u001e\u0010$\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110&2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\"\u0010'\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010\t2\u0006\u0010)\u001a\u00020\u0011H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/yy/hiyo/channel/component/hat/HatService;", "Lcom/yy/hiyo/channel/component/hat/IChannelHatService;", "()V", "callback", "Lcom/yy/hiyo/channel/component/hat/IChannelHatService$IChannelHatCallback;", "channelId", "", "confList", "", "Lcom/yy/hiyo/channel/component/hat/data/HatConfigInfo;", "dataModel", "Lcom/yy/hiyo/channel/component/hat/HatDataModel;", "getDataModel", "()Lcom/yy/hiyo/channel/component/hat/HatDataModel;", "dataModel$delegate", "Lkotlin/Lazy;", "expireCheckTimeSecs", "", "expireRunnable", "Ljava/lang/Runnable;", "usersHatCacheMap", "", "Lcom/yy/hiyo/channel/component/hat/data/UserHatData;", "version", "checkHatExpire", "", "destroy", "getConfigById", "id", "getUserHat", "uid", "initChannel", "postCheckRunnable", "refreshUserConfData", "removeUnSeatUidsCache", "reqConfig", "reqUserHatInfos", "uids", "", "updateCache", "userHatData", "expireTime", "Companion", "channel-components_release"})
public final class HatService
implements IChannelHatService {
    private String version = "";
    private List<HatConfigInfo> confList;
    private Map<Long, UserHatData> usersHatCacheMap;
    private String channelId;
    private IChannelHatService.IChannelHatCallback callback;
    private final Lazy dataModel$delegate;
    private long expireCheckTimeSecs;
    private final Runnable expireRunnable;
    @NotNull
    public static final String TAG = "HatService";
    public static final Companion Companion = new Companion(null);

    private final HatDataModel getDataModel() {
        Lazy lazy = this.dataModel$delegate;
        HatService hatService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (HatDataModel)lazy.getValue();
    }

    @Override
    public void initChannel(@NotNull String channelId, @NotNull IChannelHatService.IChannelHatCallback callback2) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        YYTaskExecutor.removeTask((Runnable)this.expireRunnable);
        MLog.info((Object)TAG, (String)("initChannel " + channelId), (Object[])new Object[0]);
        CharSequence charSequence = this.channelId;
        boolean bl = false;
        if (charSequence.length() > 0 && RuntimeContext.sIsDebuggable) {
            throw (Throwable)new RuntimeException("already has init channel " + this.channelId);
        }
        this.channelId = channelId;
        this.callback = callback2;
        ((IGfPrivilegeService)ServiceManagerProxy.getService(IGfPrivilegeService.class)).registerHatNotify((Function1)new Function1<HatChangeNotifyData, Unit>(this){
            final /* synthetic */ HatService this$0;

            public final void invoke(@NotNull HatChangeNotifyData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getVersion(), (Object)HatService.access$getVersion$p(this.this$0)) ^ true) {
                    HatService.access$reqConfig(this.this$0);
                }
                HatService.access$updateCache(this.this$0, it.getUid(), it.getShowHat() ? HatService.access$getConfigById(this.this$0, it.getHatId()) : null, it.getExpireTime());
            }
            {
                this.this$0 = hatService;
                super(1);
            }
        });
        charSequence = this.version;
        bl = false;
        if (charSequence.length() == 0) {
            this.reqConfig();
        }
        this.reqUserHatInfos(callback2.getSeats(), channelId);
        this.postCheckRunnable();
    }

    @Override
    @NotNull
    public UserHatData getUserHat(long uid) {
        if (!this.usersHatCacheMap.containsKey(uid)) {
            this.usersHatCacheMap.put(uid, new UserHatData(0L, null));
        }
        UserHatData userHatData = this.usersHatCacheMap.get(uid);
        if (userHatData == null) {
            Intrinsics.throwNpe();
        }
        return userHatData;
    }

    private final void reqUserHatInfos(List<Long> uids, String channelId) {
        this.getDataModel().getUsersGiftEffects(uids, channelId, (Function1<? super GetRoomSeatHatsRes, Unit>)((Function1)new Function1<GetRoomSeatHatsRes, Unit>(this){
            final /* synthetic */ HatService this$0;

            public final void invoke(@NotNull GetRoomSeatHatsRes it) {
                Iterator<Map.Entry<K, V>> iterator;
                block4: {
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        iterator = it.infos;
                        if (iterator == null) break block3;
                        Map map = iterator;
                        boolean bl = false;
                        iterator = map.entrySet().iterator();
                        if (iterator != null) break block4;
                    }
                    return;
                }
                Iterator<Map.Entry<K, V>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator2.next();
                    K k = next.getKey();
                    Intrinsics.checkExpressionValueIsNotNull(k, (String)"next.key");
                    long l = ((Number)k).longValue();
                    Object object = ((UserHatInfo)next.getValue()).info;
                    HatConfigInfo hatConfigInfo = HatService.access$getConfigById(this.this$0, object != null && (object = ((HatInfo)object).id) != null ? (Long)object : 0L);
                    Long l2 = ((UserHatInfo)next.getValue()).expired_ts;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"next.value.expired_ts");
                    HatService.access$updateCache(this.this$0, l, hatConfigInfo, l2);
                }
            }
            {
                this.this$0 = hatService;
                super(1);
            }
        }));
    }

    private final void updateCache(long uid, HatConfigInfo userHatData, long expireTime) {
        UserHatData userHatData2;
        if (this.usersHatCacheMap.containsKey(uid)) {
            UserHatData userHatData3 = this.usersHatCacheMap.get(uid);
            if (userHatData3 == null) {
                Intrinsics.throwNpe();
            }
            UserHatData userHatData4 = userHatData3;
            boolean bl = false;
            boolean bl2 = false;
            UserHatData $this$apply = userHatData4;
            boolean bl3 = false;
            $this$apply.setValue("kvo_expired_time", expireTime);
            $this$apply.setValue("kvo_config", userHatData);
            userHatData2 = userHatData4;
        } else {
            userHatData2 = new UserHatData(expireTime, userHatData);
        }
        UserHatData data2 = userHatData2;
        MLog.info((Object)TAG, (String)("reqUserHatInfos uid " + uid + " ,data " + userHatData), (Object[])new Object[0]);
        this.usersHatCacheMap.put(uid, data2);
    }

    private final void reqConfig() {
        this.getDataModel().getHatEffectConfs(this.version, (Function1<? super GetHatCfgRes, Unit>)((Function1)new Function1<GetHatCfgRes, Unit>(this){
            final /* synthetic */ HatService this$0;

            public final void invoke(@NotNull GetHatCfgRes it) {
                boolean bl;
                Map map;
                Iterator<Map.Entry<K, V>> iterator;
                block6: {
                    block5: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        Boolean bl2 = it.ver_same;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"it.ver_same");
                        if (bl2.booleanValue()) {
                            MLog.info((Object)"HatService", (String)("reqConfig res return " + it.ver_same + "  version " + it.cfg.version), (Object[])new Object[0]);
                            return;
                        }
                        String string2 = it.cfg.version;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.cfg.version");
                        HatService.access$setVersion$p(this.this$0, string2);
                        HatService.access$getConfList$p(this.this$0).clear();
                        iterator = it.cfg.infos;
                        if (iterator == null) break block5;
                        map = iterator;
                        bl = false;
                        iterator = map.entrySet().iterator();
                        if (iterator != null) break block6;
                    }
                    return;
                }
                Iterator<Map.Entry<K, V>> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    if ((HatInfo)((Map.Entry)iterator2.next()).getValue() == null) continue;
                    bl = false;
                    boolean bl3 = false;
                    Map $this$apply = map;
                    boolean bl4 = false;
                    List list2 = HatService.access$getConfList$p(this.this$0);
                    Long l = ((HatInfo)$this$apply).id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"id");
                    long l2 = l;
                    String string3 = ((HatInfo)$this$apply).url;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url");
                    String string4 = ((HatInfo)$this$apply).svga;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"svga");
                    String string5 = ((HatInfo)$this$apply).url_h5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"url_h5");
                    Long l3 = ((HatInfo)$this$apply).series_id;
                    Intrinsics.checkExpressionValueIsNotNull((Object)l3, (String)"series_id");
                    list2.add(new HatConfigInfo(l2, string3, string4, string5, l3));
                    MLog.info((Object)"HatService", (String)("reqConfig id  " + ((HatInfo)$this$apply).id + " url " + ((HatInfo)$this$apply).url + " , svga " + ((HatInfo)$this$apply).svga), (Object[])new Object[0]);
                }
                HatService.access$refreshUserConfData(this.this$0);
            }
            {
                this.this$0 = hatService;
                super(1);
            }
        }));
    }

    private final void refreshUserConfData() {
        MLog.info((Object)TAG, (String)"refreshUserConfData", (Object[])new Object[0]);
        Object object = this.usersHatCacheMap;
        boolean bl = false;
        Iterator<Map.Entry<Long, UserHatData>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getValue();
            bl = false;
            boolean bl2 = false;
            UserHatData it = (UserHatData)((Object)object);
            boolean bl3 = false;
            HatConfigInfo hatConfigInfo = it.getHatConfig();
            it.setValue("kvo_config", this.getConfigById(hatConfigInfo != null ? hatConfigInfo.getId() : 0L));
        }
    }

    private final HatConfigInfo getConfigById(long id2) {
        Object v0;
        block1: {
            Iterable iterable = this.confList;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                HatConfigInfo it = (HatConfigInfo)t;
                boolean bl3 = false;
                if (!(it.getId() == id2)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        HatConfigInfo config = v0;
        MLog.info((Object)TAG, (String)("getConfigById id " + id2 + " config " + config), (Object[])new Object[0]);
        return config;
    }

    private final void checkHatExpire() {
        this.removeUnSeatUidsCache();
        Map<Long, UserHatData> map = this.usersHatCacheMap;
        boolean bl = false;
        Iterator<Map.Entry<Long, UserHatData>> iterator = map.entrySet().iterator();
        long time = SystemClock.elapsedRealtime();
        boolean isRefresh = false;
        while (iterator.hasNext()) {
            UserHatData data2 = iterator.next().getValue();
            if (data2.getExpiredTime() <= 0L || data2.getExpiredTime() * (long)1000 >= time) continue;
            MLog.info((Object)TAG, (String)("checkHatExpire data " + data2.getHatConfig() + ' '), (Object[])new Object[0]);
            isRefresh = true;
            break;
        }
        if (isRefresh) {
            HatService hatService = this;
            Object object = this.callback;
            if (object == null || (object = object.getSeats()) == null) {
                HatService hatService2 = hatService;
                boolean bl2 = false;
                List list2 = new ArrayList();
                hatService = hatService2;
                object = list2;
            }
            hatService.reqUserHatInfos((List<Long>)object, this.channelId);
        }
        this.postCheckRunnable();
    }

    private final void postCheckRunnable() {
        if (this.expireCheckTimeSecs > 0L) {
            MLog.info((Object)TAG, (String)("checkHatExpire expireCheckTimeSecs " + this.expireCheckTimeSecs), (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)this.expireRunnable, (long)this.expireCheckTimeSecs);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUnSeatUidsCache() {
        void $this$filterNotTo$iv$iv;
        Object object = this.callback;
        if (object == null || (object = object.getSeats()) == null) {
            boolean bl = false;
            object = new ArrayList();
        }
        Object seats = object;
        Iterable $this$filterNot$iv = this.usersHatCacheMap.keySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            long it = ((Number)element$iv$iv).longValue();
            boolean bl = false;
            if (seats.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keys = (List)destination$iv$iv;
        MLog.info((Object)TAG, (String)("removeUnSeats keys " + keys + " seats " + seats), (Object[])new Object[0]);
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            this.usersHatCacheMap.remove(it);
        }
    }

    @Override
    public void destroy() {
        this.channelId = "";
        this.callback = null;
        YYTaskExecutor.removeTask((Runnable)this.expireRunnable);
        this.usersHatCacheMap.clear();
    }

    public HatService() {
        HatService hatService = this;
        boolean bl = false;
        Object object = new ArrayList();
        hatService.confList = object;
        hatService = this;
        bl = false;
        hatService.usersHatCacheMap = object = (Map)new LinkedHashMap();
        this.channelId = "";
        this.dataModel$delegate = LazyKt.lazy((Function0)dataModel.2.INSTANCE);
        this.expireCheckTimeSecs = 180000L;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && ((CommonConfig)config).getData().hatExpireRunnableTime >= 0L) {
            this.expireCheckTimeSecs = ((CommonConfig)config).getData().hatExpireRunnableTime;
        }
        this.expireRunnable = new Runnable(this){
            final /* synthetic */ HatService this$0;

            public final void run() {
                HatService.access$checkHatExpire(this.this$0);
            }
            {
                this.this$0 = hatService;
            }
        };
    }

    public static final /* synthetic */ String access$getVersion$p(HatService $this) {
        return $this.version;
    }

    public static final /* synthetic */ void access$setVersion$p(HatService $this, String string2) {
        $this.version = string2;
    }

    public static final /* synthetic */ void access$reqConfig(HatService $this) {
        $this.reqConfig();
    }

    public static final /* synthetic */ void access$updateCache(HatService $this, long uid, HatConfigInfo userHatData, long expireTime) {
        $this.updateCache(uid, userHatData, expireTime);
    }

    public static final /* synthetic */ HatConfigInfo access$getConfigById(HatService $this, long id2) {
        return $this.getConfigById(id2);
    }

    public static final /* synthetic */ List access$getConfList$p(HatService $this) {
        return $this.confList;
    }

    public static final /* synthetic */ void access$setConfList$p(HatService $this, List list2) {
        $this.confList = list2;
    }

    public static final /* synthetic */ void access$refreshUserConfData(HatService $this) {
        $this.refreshUserConfData();
    }

    public static final /* synthetic */ void access$checkHatExpire(HatService $this) {
        $this.checkHatExpire();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/hat/HatService$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

