/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.contribution.rolling;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.hiyo.channel.component.contribution.rolling.CharOrderManager;
import com.yy.hiyo.channel.component.contribution.rolling.TextManager;
import com.yy.hiyo.channel.component.contribution.rolling.strategy.CharOrderStrategy;
import com.yy.hiyo.channel.component.contribution.rolling.strategy.Strategy;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0019\n\u0002\b\u000b\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u000e\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u0019\u0010H\u001a\u00020E2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J\u00a2\u0006\u0002\u0010LJ\u000e\u0010H\u001a\u00020E2\u0006\u0010I\u001a\u000202J\u0014\u0010H\u001a\u00020E2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0MJ\u0016\u0010N\u001a\u00020E2\u0006\u0010O\u001a\u00020\t2\u0006\u0010P\u001a\u00020KJ\b\u0010Q\u001a\u00020RH\u0002J\u0006\u0010S\u001a\u00020EJ\b\u0010T\u001a\u00020\tH\u0002J\b\u0010U\u001a\u00020\tH\u0002J\b\u0010V\u001a\u00020\tH\u0016J\u0006\u0010W\u001a\u000202J\u0006\u0010X\u001a\u00020YJ\u0006\u0010Z\u001a\u00020\tJ*\u0010[\u001a\u00020E2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u0010\u0010\\\u001a\u00020E2\u0006\u0010]\u001a\u00020^H\u0014J\u0018\u0010_\u001a\u00020E2\u0006\u0010`\u001a\u00020\t2\u0006\u0010a\u001a\u00020\tH\u0014J(\u0010b\u001a\u00020E2\u0006\u0010c\u001a\u00020\t2\u0006\u0010d\u001a\u00020\t2\u0006\u0010e\u001a\u00020\t2\u0006\u0010f\u001a\u00020\tH\u0014J\b\u0010g\u001a\u00020EH\u0002J\u0010\u0010h\u001a\u00020E2\u0006\u0010]\u001a\u00020^H\u0002J\u000e\u0010i\u001a\u00020E2\u0006\u0010F\u001a\u00020GJ\u000e\u0010j\u001a\u00020E2\u0006\u0010k\u001a\u000202J\u0016\u0010j\u001a\u00020E2\u0006\u0010k\u001a\u0002022\u0006\u0010l\u001a\u00020RJ\u000e\u0010m\u001a\u00020E2\u0006\u0010n\u001a\u00020YJ\u0016\u0010m\u001a\u00020E2\u0006\u0010o\u001a\u00020\t2\u0006\u0010p\u001a\u00020YJ\u0006\u0010q\u001a\u00020ER\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010,\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00104\u001a\u00020\t2\u0006\u00103\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010=\u001a\u0004\u0018\u00010<2\b\u0010\u001e\u001a\u0004\u0018\u00010<8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/yy/hiyo/channel/component/contribution/rolling/RollingTextView;", "Lcom/yy/base/memoryrecycle/views/YYView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "animationDuration", "", "getAnimationDuration", "()J", "setAnimationDuration", "(J)V", "animationInterpolator", "Landroid/view/animation/Interpolator;", "getAnimationInterpolator", "()Landroid/view/animation/Interpolator;", "setAnimationInterpolator", "(Landroid/view/animation/Interpolator;)V", "animator", "Landroid/animation/ValueAnimator;", "kotlin.jvm.PlatformType", "charOrderManager", "Lcom/yy/hiyo/channel/component/contribution/rolling/CharOrderManager;", "value", "Lcom/yy/hiyo/channel/component/contribution/rolling/strategy/CharOrderStrategy;", "charStrategy", "getCharStrategy", "()Lcom/yy/hiyo/channel/component/contribution/rolling/strategy/CharOrderStrategy;", "setCharStrategy", "(Lcom/yy/hiyo/channel/component/contribution/rolling/strategy/CharOrderStrategy;)V", "currentText", "", "getCurrentText", "()[C", "gravity", "lastMeasuredDesiredHeight", "lastMeasuredDesiredWidth", "letterSpacingExtra", "getLetterSpacingExtra", "()I", "setLetterSpacingExtra", "(I)V", "targetText", "", "color", "textColor", "getTextColor", "setTextColor", "textManager", "Lcom/yy/hiyo/channel/component/contribution/rolling/TextManager;", "textPaint", "Landroid/graphics/Paint;", "textStyle", "Landroid/graphics/Typeface;", "typeface", "getTypeface", "()Landroid/graphics/Typeface;", "setTypeface", "(Landroid/graphics/Typeface;)V", "viewBounds", "Landroid/graphics/Rect;", "addAnimatorListener", "", "listener", "Landroid/animation/Animator$AnimatorListener;", "addCharOrder", "orderList", "", "", "([Ljava/lang/Character;)V", "", "addSelfChar", "pos", "char", "checkForReLayout", "", "clearSelfChar", "computeDesiredHeight", "computeDesiredWidth", "getBaseline", "getText", "getTextSize", "", "getViewWidth", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "width", "height", "oldw", "oldh", "onTextPaintMeasurementChanged", "realignAndClipCanvasForGravity", "removeAnimatorListener", "setText", "text", "animate", "setTextSize", "textSize", "unit", "size", "stop", "channel-components_release"})
public class RollingTextView
extends YYView {
    private int lastMeasuredDesiredWidth;
    private int lastMeasuredDesiredHeight;
    private final Paint textPaint;
    private final CharOrderManager charOrderManager;
    private final TextManager textManager;
    private ValueAnimator animator;
    private final Rect viewBounds;
    private int gravity;
    private int textStyle;
    private CharSequence targetText;
    private long animationDuration;
    @NotNull
    private Interpolator animationInterpolator;
    private int textColor;
    private HashMap _$_findViewCache;

    private final void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.textPaint.setFlags(1);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ RollingTextView this$0;

            public final void onAnimationUpdate(ValueAnimator it) {
                TextManager textManager = RollingTextView.access$getTextManager$p(this.this$0);
                ValueAnimator valueAnimator = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"it");
                textManager.updateAnimation(valueAnimator.getAnimatedFraction());
                RollingTextView.access$checkForReLayout(this.this$0);
                this.this$0.invalidate();
            }
            {
                this.this$0 = rollingTextView;
            }
        });
        this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ RollingTextView this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                RollingTextView.access$getTextManager$p(this.this$0).onAnimationEnd();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.save();
        this.realignAndClipCanvasForGravity(canvas);
        canvas.translate(0.0f, this.textManager.getTextBaseline());
        this.textManager.draw(canvas);
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.lastMeasuredDesiredWidth = this.computeDesiredWidth();
        this.lastMeasuredDesiredHeight = this.computeDesiredHeight();
        int desiredWidth = YYView.resolveSize((int)this.lastMeasuredDesiredWidth, (int)widthMeasureSpec);
        int desiredHeight = YYView.resolveSize((int)this.lastMeasuredDesiredHeight, (int)heightMeasureSpec);
        this.setMeasuredDimension(desiredWidth, desiredHeight);
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        super.onSizeChanged(width, height, oldw, oldh);
        this.viewBounds.set(this.getPaddingLeft(), this.getPaddingTop(), width - this.getPaddingRight(), height - this.getPaddingBottom());
    }

    private final boolean checkForReLayout() {
        this.requestLayout();
        return true;
    }

    private final int computeDesiredWidth() {
        return (int)this.textManager.getCurrentTextWidth() + this.getPaddingLeft() + this.getPaddingRight();
    }

    private final int computeDesiredHeight() {
        return (int)this.textManager.getTextHeight() + this.getPaddingTop() + this.getPaddingBottom();
    }

    public final int getViewWidth() {
        return this.computeDesiredWidth();
    }

    private final void realignAndClipCanvasForGravity(Canvas canvas) {
        float currentWidth = this.textManager.getCurrentTextWidth();
        float currentHeight = this.textManager.getTextHeight();
        int availableWidth = this.viewBounds.width();
        int availableHeight = this.viewBounds.height();
        float translationX = 0.0f;
        float translationY = 0.0f;
        if ((this.gravity & 0x10) == 16) {
            translationY = (float)this.viewBounds.top + ((float)availableHeight - currentHeight) / 2.0f;
        }
        if ((this.gravity & 1) == 1) {
            translationX = (float)this.viewBounds.left + ((float)availableWidth - currentWidth) / 2.0f;
        }
        if ((this.gravity & 0x30) == 48) {
            translationY = 0.0f;
        }
        if ((this.gravity & 0x50) == 80) {
            translationY = (float)this.viewBounds.top + ((float)availableHeight - currentHeight);
        }
        if ((this.gravity & 0x800003) == 0x800003) {
            translationX = 0.0f;
        }
        if ((this.gravity & 0x800005) == 0x800005) {
            translationX = (float)this.viewBounds.left + ((float)availableWidth - currentWidth);
        }
        canvas.translate(translationX, translationY);
        canvas.clipRect(0.0f, 0.0f, currentWidth, currentHeight);
    }

    private final void onTextPaintMeasurementChanged() {
        this.textManager.updateFontMatrics();
        this.checkForReLayout();
        this.invalidate();
    }

    public final long getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(long l) {
        this.animationDuration = l;
    }

    @NotNull
    public final Interpolator getAnimationInterpolator() {
        return this.animationInterpolator;
    }

    public final void setAnimationInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"<set-?>");
        this.animationInterpolator = interpolator;
    }

    public final void stop() {
        block0: {
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator == null) break block0;
            valueAnimator.cancel();
        }
    }

    public final void setText(@NotNull CharSequence text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.setText(text, !TextUtils.isEmpty((CharSequence)this.targetText));
    }

    @NotNull
    public final CharSequence getText() {
        return this.targetText;
    }

    public final void setText(@NotNull CharSequence text, boolean animate) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.targetText = text;
        if (animate) {
            this.textManager.setText(text);
            ValueAnimator valueAnimator = this.animator;
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator $this$with = valueAnimator;
            boolean bl3 = false;
            if ($this$with.isRunning()) {
                $this$with.cancel();
            }
            $this$with.setDuration(this.animationDuration);
            $this$with.setInterpolator((TimeInterpolator)this.animationInterpolator);
            this.post(new Runnable($this$with){
                final /* synthetic */ ValueAnimator $this_with;

                public final void run() {
                    this.$this_with.start();
                }
                {
                    this.$this_with = valueAnimator;
                }
            });
        } else {
            CharOrderStrategy originalStrategy = this.getCharStrategy();
            this.setCharStrategy(Strategy.NoAnimation());
            this.textManager.setText(text);
            this.setCharStrategy(originalStrategy);
            this.textManager.onAnimationEnd();
            this.checkForReLayout();
            this.invalidate();
        }
    }

    public final void addSelfChar(int pos, char c) {
        this.textManager.addSelfChar(pos, c);
    }

    public final void clearSelfChar() {
        this.textManager.clearSelfChar();
    }

    @Nullable
    public final Typeface getTypeface() {
        return this.textPaint.getTypeface();
    }

    public final void setTypeface(@Nullable Typeface value) {
        Typeface typeface;
        switch (this.textStyle) {
            case 3: {
                typeface = Typeface.create((Typeface)value, (int)3);
                break;
            }
            case 1: {
                typeface = Typeface.create((Typeface)value, (int)1);
                break;
            }
            case 2: {
                typeface = Typeface.create((Typeface)value, (int)2);
                break;
            }
            default: {
                typeface = value;
            }
        }
        this.textPaint.setTypeface(typeface);
        this.onTextPaintMeasurementChanged();
    }

    @NotNull
    public final char[] getCurrentText() {
        return this.textManager.getCurrentText();
    }

    public final void setTextSize(float textSize) {
        this.setTextSize(2, textSize);
    }

    public final float getTextSize() {
        return this.textPaint.getTextSize();
    }

    public final void setTextSize(int unit, float size) {
        Context context = this.getContext();
        if (context == null || (context = context.getResources()) == null) {
            Resources resources = Resources.getSystem();
            context = resources;
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        }
        Context r = context;
        this.textPaint.setTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)r.getDisplayMetrics()));
        this.onTextPaintMeasurementChanged();
    }

    public final int getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(int color2) {
        if (this.textColor != color2) {
            this.textColor = color2;
            this.textPaint.setColor(color2);
            this.invalidate();
        }
    }

    public final int getLetterSpacingExtra() {
        return this.textManager.getLetterSpacingExtra();
    }

    public final void setLetterSpacingExtra(int value) {
        this.textManager.setLetterSpacingExtra(value);
    }

    public int getBaseline() {
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        return (int)(this.textManager.getTextHeight() / (float)2 + ((fontMetrics.descent - fontMetrics.ascent) / (float)2 - fontMetrics.descent));
    }

    @NotNull
    public final CharOrderStrategy getCharStrategy() {
        return this.charOrderManager.getCharStrategy();
    }

    public final void setCharStrategy(@NotNull CharOrderStrategy value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.charOrderManager.setCharStrategy(value);
    }

    public final void addAnimatorListener(@NotNull Animator.AnimatorListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.animator.addListener(listener2);
    }

    public final void removeAnimatorListener(@NotNull Animator.AnimatorListener listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        this.animator.removeListener(listener2);
    }

    public final void addCharOrder(@NotNull CharSequence orderList) {
        Intrinsics.checkParameterIsNotNull((Object)orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(StringsKt.asIterable((CharSequence)orderList));
    }

    public final void addCharOrder(@NotNull Iterable<Character> orderList) {
        Intrinsics.checkParameterIsNotNull(orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(orderList);
    }

    public final void addCharOrder(@NotNull Character[] orderList) {
        Intrinsics.checkParameterIsNotNull((Object)orderList, (String)"orderList");
        this.charOrderManager.addCharOrder(ArraysKt.asIterable((Object[])orderList));
    }

    public RollingTextView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.textPaint = new Paint();
        this.charOrderManager = new CharOrderManager();
        this.textManager = new TextManager(this.textPaint, this.charOrderManager);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        this.viewBounds = new Rect();
        this.gravity = 17;
        this.targetText = "";
        this.animationDuration = 750L;
        this.animationInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
        this.textColor = -16777216;
        this.init(context, null, 0, 0);
    }

    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        this.textPaint = new Paint();
        this.charOrderManager = new CharOrderManager();
        this.textManager = new TextManager(this.textPaint, this.charOrderManager);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        this.viewBounds = new Rect();
        this.gravity = 17;
        this.targetText = "";
        this.animationDuration = 750L;
        this.animationInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
        this.textColor = -16777216;
        this.init(context, attrs, 0, 0);
    }

    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textPaint = new Paint();
        this.charOrderManager = new CharOrderManager();
        this.textManager = new TextManager(this.textPaint, this.charOrderManager);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        this.viewBounds = new Rect();
        this.gravity = 17;
        this.targetText = "";
        this.animationDuration = 750L;
        this.animationInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
        this.textColor = -16777216;
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public RollingTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.textPaint = new Paint();
        this.charOrderManager = new CharOrderManager();
        this.textManager = new TextManager(this.textPaint, this.charOrderManager);
        this.animator = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        this.viewBounds = new Rect();
        this.gravity = 17;
        this.targetText = "";
        this.animationDuration = 750L;
        this.animationInterpolator = (Interpolator)new AccelerateDecelerateInterpolator();
        this.textColor = -16777216;
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    public static final /* synthetic */ TextManager access$getTextManager$p(RollingTextView $this) {
        return $this.textManager;
    }

    public static final /* synthetic */ boolean access$checkForReLayout(RollingTextView $this) {
        return $this.checkForReLayout();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

