/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.contribution;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.pagelifecycle.IPageReuseView;
import com.yy.hiyo.channel.component.contribution.IGiftContributionMvp;
import com.yy.hiyo.channel.component.contribution.rolling.RollingTextView;
import com.yy.hiyo.channel.component.contribution.view.FlowLayout;
import java.util.List;

public class GiftContributionView
extends YYLinearLayout
implements IGiftContributionMvp.IView,
View.OnClickListener,
IPageReuseView {
    public static final String TAG = "GiftContributionPresenter";
    private YYTextView mGiftContributeTv;
    private RollingTextView mGiftRollingTv;
    private YYTextView mGiftUnitRollingTv;
    private YYLinearLayout mRollingLayout;
    private YYTextView mBigRollingTv;
    private RecycleImageView mBgIv;
    private String roomId;
    private FlowLayout mFlowLayout;
    private RecycleImageView mIvCrown;
    private View mContributionLayout;
    private IGiftContributionMvp.IPresenter mPresenter;

    public GiftContributionView(Context context) {
        super(context);
        this.createView(context);
    }

    public GiftContributionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public GiftContributionView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        GiftContributionView.inflate((Context)context, (int)R.layout.layout_gift_contribution_channel, (ViewGroup)this);
        this.mGiftContributeTv = (YYTextView)this.findViewById(R.id.tv_contribution);
        this.mGiftRollingTv = (RollingTextView)this.findViewById(R.id.tv_contribution_rolling);
        if (LanguageUtils.isRtl()) {
            this.mGiftUnitRollingTv = (YYTextView)this.findViewById(R.id.tv_contribution_unit_rolling_right);
            this.mGiftUnitRollingTv.setVisibility(0);
        } else {
            this.mGiftUnitRollingTv = (YYTextView)this.findViewById(R.id.tv_contribution_unit_rolling);
            this.mGiftUnitRollingTv.setVisibility(0);
        }
        this.mRollingLayout = (YYLinearLayout)this.findViewById(R.id.layout_contribution_rolling);
        this.mBigRollingTv = (YYTextView)this.findViewById(R.id.tv_big_rolling);
        this.mFlowLayout = (FlowLayout)this.findViewById(R.id.fl_avatar);
        this.mIvCrown = (RecycleImageView)this.findViewById(R.id.iv_flow_crown);
        this.mGiftContributeTv.setOnClickListener((View.OnClickListener)this);
        this.mContributionLayout = this.findViewById(R.id.layout_contribution);
        this.mContributionLayout.setOnClickListener((View.OnClickListener)this);
        this.mBgIv = (RecycleImageView)this.findViewById(R.id.bg_image);
        this.mBigRollingTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mBigRollingTv.setVisibility(4);
    }

    public void updateRollingLayout() {
        YYTaskExecutor.postToMainThread(() -> {
            int bigRollingTvWidth;
            int giftContributeWidth = this.mGiftContributeTv.getMeasuredWidth();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mGiftContributeTv.getLayoutParams();
            int midPoint = lp.getMarginStart() + giftContributeWidth / 2;
            int rollingWidth = this.mGiftRollingTv.getViewWidth() + this.mGiftUnitRollingTv.getMeasuredWidth();
            if (rollingWidth > 0) {
                FrameLayout.LayoutParams rollingLayoutLp = (FrameLayout.LayoutParams)this.mRollingLayout.getLayoutParams();
                rollingLayoutLp.setMarginStart(midPoint - rollingWidth / 2);
                this.mRollingLayout.setLayoutParams((ViewGroup.LayoutParams)rollingLayoutLp);
            }
            if ((bigRollingTvWidth = this.mBigRollingTv.getMeasuredWidth()) > 0) {
                FrameLayout.LayoutParams bigRollingLp = (FrameLayout.LayoutParams)this.mBigRollingTv.getLayoutParams();
                bigRollingLp.setMarginStart(midPoint - bigRollingTvWidth / 2);
                this.mBigRollingTv.setLayoutParams((ViewGroup.LayoutParams)bigRollingLp);
            }
        });
    }

    public void onClick(View view) {
        if ((view.getId() == R.id.tv_contribution || view.getId() == R.id.layout_contribution) && this.mPresenter != null) {
            this.mPresenter.onContributionClick();
        }
    }

    @Override
    public void setGiftContributeNum(String num) {
        if (TextUtils.isEmpty((CharSequence)num)) {
            this.mGiftContributeTv.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_day_contriubution));
            this.mIvCrown.setVisibility(8);
        } else {
            if (this.getVisibility() == 8) {
                RoomTrack.INSTANCE.giftContributionShow(this.roomId);
            }
            this.mGiftContributeTv.setText((CharSequence)num);
            this.mGiftContributeTv.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
            if (this.mFlowLayout.getUrlSize() > 0) {
                this.updateFirstIcon();
            }
        }
        this.mBigRollingTv.setText((CharSequence)num);
    }

    @Override
    public YYTextView getGiftContributeTv() {
        return this.mGiftContributeTv;
    }

    @Override
    public RollingTextView getGiftRollingTv() {
        return this.mGiftRollingTv;
    }

    @Override
    public YYTextView getGiftUnitTv() {
        return this.mGiftUnitRollingTv;
    }

    @Override
    public YYTextView getBigTv() {
        return this.mBigRollingTv;
    }

    @Override
    public void updateLayout() {
        if (this.mIvCrown.getVisibility() == 0) {
            this.updateFirstIcon();
        }
        this.updateRollingLayout();
    }

    @Override
    public void setGiftBackground(int drawable2) {
        this.mBgIv.setImageResource(drawable2);
    }

    public void setTopAvatar(List<String> avatarList) {
        if (avatarList == null) {
            this.mFlowLayout.setVisibility(8);
            return;
        }
        this.mFlowLayout.setVisibility(0);
        MLog.info((Object)TAG, (String)("setTopAvatar:" + avatarList), (Object[])new Object[0]);
        this.mFlowLayout.setUrls(avatarList);
        if (avatarList.size() > 0) {
            this.updateFirstIcon();
        }
    }

    private void updateFirstIcon() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GiftContributionView.this.mIvCrown.setVisibility(0);
                GiftContributionView.this.mGiftContributeTv.measure(0, 0);
                int measuredWidth = GiftContributionView.this.getMeasuredWidth() - GiftContributionView.this.mFlowLayout.getMeasuredWidth();
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)GiftContributionView.this.mIvCrown.getLayoutParams();
                layoutParams.setMarginStart(measuredWidth - ResolutionUtils.dip2Px((float)6.0f));
                GiftContributionView.this.mIvCrown.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }, (long)500L);
    }

    @Override
    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setPresenter(IGiftContributionMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    public void resetViewState() {
        this.mPresenter = null;
        this.setVisibility(8);
    }
}

