/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.contribution;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.component.contribution.ContributionDataManager;
import com.yy.hiyo.channel.component.contribution.IGiftContributionMvp;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakProtoCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.List;
import net.ihago.money.api.contribrank.GetContribInfoReq;
import net.ihago.money.api.contribrank.GetContribInfoRes;
import net.ihago.money.api.contribrank.GetDayRanksReq;
import net.ihago.money.api.contribrank.GetDayRanksRes;
import net.ihago.money.api.contribrank.GetWeekContributionsReq;
import net.ihago.money.api.contribrank.GetWeekContributionsRes;

public class GiftContributionModel
implements IGiftContributionMvp.IModel {
    private static final String TAG = "GiftContributionModel";
    private IDestroyable destroyable;

    GiftContributionModel(IDestroyable destroyable) {
        this.destroyable = destroyable;
    }

    @Override
    public void getDayContributions(String rid, final IGiftContributionMvp.CallBack callBack) {
        GetDayRanksReq req = new GetDayRanksReq.Builder().rid(rid).build();
        MLog.info((Object)TAG, (String)"getDayContributions request start", (Object[])new Object[0]);
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)WeakProtoCallback.of((IDestroyable)this.destroyable, (IProtoCallback)new SimpleProtoCallback<GetDayRanksRes>(){

            public void onResponse(@NonNull GetDayRanksRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)GiftContributionModel.TAG, (String)("getDayContributions onResponse code: " + code), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    long num = message.contributions;
                    List rankInfoList = message.ranks;
                    if (callBack != null) {
                        callBack.onSuccess(num);
                    }
                } else {
                    MLog.info((Object)GiftContributionModel.TAG, (String)"getDayContributions errorCode:%s, errorInfo:%s", (Object[])new Object[]{message.result.errcode, message.result.errmsg});
                }
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)GiftContributionModel.TAG, (String)("getDayContributions retryWhenError reason and code :" + reason + "," + code), (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError(code, reason);
                        }
                    }
                });
                return super.retryWhenError(canRetry, reason, code);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)GiftContributionModel.TAG, (String)"getDayContributions retryWhenTimeout reason and code time out", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(-1, "time out");
                        }
                    }
                });
                return super.retryWhenTimeout(canRetry);
            }
        }));
    }

    @Override
    public void getWeekContributions(String rid, final IGiftContributionMvp.CallBack callBack) {
        GetWeekContributionsReq req = new GetWeekContributionsReq.Builder().rid(rid).build();
        MLog.info((Object)TAG, (String)"getWeekContributions request start", (Object[])new Object[0]);
        ProtoManager.getInstance().sendHttp((AndroidMessage)req, (IProtoCallback)WeakProtoCallback.of((IDestroyable)this.destroyable, (IProtoCallback)new SimpleProtoCallback<GetWeekContributionsRes>(){

            public void onResponse(@NonNull GetWeekContributionsRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                MLog.info((Object)GiftContributionModel.TAG, (String)("getWeekContributions onResponse code: " + code), (Object[])new Object[0]);
                if (ProtoManager.isSuccessCode((long)code)) {
                    long num = message.contributions;
                    if (callBack != null) {
                        callBack.onSuccess(num);
                    }
                } else {
                    MLog.info((Object)GiftContributionModel.TAG, (String)"getWeekContributions errorCode:%s, errorInfo:%s", (Object[])new Object[]{message.result.errcode, message.result.errmsg});
                }
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.info((Object)GiftContributionModel.TAG, (String)("getWeekContributions retryWhenError reason and code :" + reason + "," + code), (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError(code, reason);
                        }
                    }
                });
                return super.retryWhenError(canRetry, reason, code);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)GiftContributionModel.TAG, (String)"getWeekContributions retryWhenTimeout reason and code time out", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callBack != null) {
                            callBack.onError(-1, "time out");
                        }
                    }
                });
                return super.retryWhenTimeout(canRetry);
            }
        }));
    }

    @Override
    public void getContributionsInfo(final String roomId, final IGiftContributionMvp.ITopDayContributionsCallback callback2) {
        GetContribInfoReq contribInfoReq = new GetContribInfoReq.Builder().rid(roomId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)contribInfoReq, (IProtoCallback)WeakProtoCallback.of((IDestroyable)this.destroyable, (IProtoCallback)new IProtoCallback<GetContribInfoRes>(){
            String currentRoomId;
            {
                this.currentRoomId = roomId;
            }

            public void onResponse(@NonNull GetContribInfoRes message, long code, String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (!TextUtils.isEmpty((CharSequence)this.currentRoomId) && !this.currentRoomId.equals(roomId)) {
                    MLog.info((Object)GiftContributionModel.TAG, (String)"getContributionsInfo roomId not right", (Object[])new Object[0]);
                    return;
                }
                if (ProtoManager.isSuccessCode((long)code)) {
                    int i;
                    List topDayUidsList = message.top_day_uids;
                    List topWeekUidsList = message.top_week_uids;
                    MLog.info((Object)GiftContributionModel.TAG, (String)("getContributionsInfo topDay:" + topDayUidsList + ", topWeek:" + topWeekUidsList), (Object[])new Object[0]);
                    int size = topDayUidsList.size();
                    for (i = 0; i < size; ++i) {
                        ContributionDataManager.Instance.addDayTopUser((Long)topDayUidsList.get(i), i);
                    }
                    size = topWeekUidsList.size();
                    for (i = 0; i < size; ++i) {
                        ContributionDataManager.Instance.addWeekTopUser((Long)topWeekUidsList.get(i), i);
                    }
                    if (callback2 != null) {
                        callback2.onSuccess(message.day_contributions, topDayUidsList);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.info((Object)GiftContributionModel.TAG, (String)"getContributionsInfo timeout", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFail(-1L, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                MLog.info((Object)GiftContributionModel.TAG, (String)("getContributionsInfo error, reason:" + reason + "code:" + code), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        }));
    }
}

