/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar.quickanswer;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.squareup.wire.AndroidMessage;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.BaseRequestManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.channel.srv.mgr.GetFastReplyReq;
import net.ihago.channel.srv.mgr.GetFastReplyRes;

public enum QuickAnswerManager {
    INSTANCE;

    private String mCurrentLanguage;
    private Map<String, List<String>> mQuickAnswerMap = new HashMap<String, List<String>>();

    public LiveData<List<String>> getQuickAnswer(Context context, String gid) {
        final MutableLiveData quickMsgData = new MutableLiveData();
        quickMsgData.setValue(null);
        this.getQuickAnswer(context, gid, new IQuickReplyCallback(){

            @Override
            public void onSuccess(String gid, List<String> result) {
                quickMsgData.setValue(result);
            }

            @Override
            public void onFail(int code, String message) {
                quickMsgData.setValue(null);
            }
        });
        return quickMsgData;
    }

    public void getQuickAnswer(final Context context, final String gid, final IQuickReplyCallback callback2) {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentLanguage) && this.mCurrentLanguage.equals(SystemUtils.getLangAndCountry())) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QuickAnswerManager.this.mQuickAnswerMap != null && QuickAnswerManager.this.mQuickAnswerMap.containsKey(gid)) {
                        FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer from cache, language:%s, gid:%s, result:%s", (Object[])new Object[]{QuickAnswerManager.this.mCurrentLanguage, gid, QuickAnswerManager.this.mQuickAnswerMap.get(gid)});
                        if (callback2 != null) {
                            callback2.onSuccess(gid, (List)QuickAnswerManager.this.mQuickAnswerMap.get(gid));
                        }
                    } else {
                        QuickAnswerManager.this.requestQuickReply(context, gid, callback2);
                    }
                }
            });
            return;
        }
        this.requestQuickReply(context, gid, callback2);
    }

    private void requestQuickReply(final Context context, final String gid, final IQuickReplyCallback callback2) {
        if (context != null && !NetworkUtils.isNetworkAvailable((Context)context)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToastUtils.showToast((Context)context, (int)R.string.check_network_and_retry);
                }
            });
            FeatureLog.i((String)"FTquickAnswer", (String)"requestQuickReply not network", (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback2 != null) {
                        callback2.onFail(-1, "not network");
                    }
                }
            });
            return;
        }
        String requestGid = "";
        if (!TextUtils.isEmpty((CharSequence)gid)) {
            requestGid = gid;
        }
        this.mCurrentLanguage = SystemUtils.getLangAndCountry();
        final long startTime = SystemClock.uptimeMillis();
        GetFastReplyReq replyReq = new GetFastReplyReq.Builder().gid(requestGid).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)replyReq, (IProtoCallback)new IProtoCallback<GetFastReplyRes>(){

            public void onResponse(final @NonNull GetFastReplyRes message, final long code, final String msg) {
                super.onResponse((AndroidMessage)message, code, msg);
                if (message == null) {
                    BaseRequestManager.statMetric((String)"channel/getquickans", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer gid:%s, message null", (Object[])new Object[]{gid});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFail(-1, "message null");
                            }
                        }
                    });
                    return;
                }
                if (!ProtoManager.isSuccessCode((long)code)) {
                    BaseRequestManager.statMetric((String)"channel/getquickans", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                    FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer gid:%s, error\uff0ccode:%s, message:%s", (Object[])new Object[]{gid, code, msg});
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (callback2 != null) {
                                callback2.onFail((int)code, msg);
                            }
                        }
                    });
                    return;
                }
                BaseRequestManager.statMetric((String)"channel/getquickans", (long)(SystemClock.uptimeMillis() - startTime), (boolean)true, (long)0L);
                FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer gid:%s, success:%s", (Object[])new Object[]{gid, message.replies});
                if (QuickAnswerManager.this.mQuickAnswerMap != null && message.replies != null && message.replies.size() > 0) {
                    QuickAnswerManager.this.mQuickAnswerMap.put(gid, message.replies);
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onSuccess(gid, message.replies);
                        }
                    }
                });
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer gid:%s, timeout", (Object[])new Object[]{gid});
                BaseRequestManager.statMetric((String)"channel/getquickans", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)99L);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFail(-1, "timeout");
                        }
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, final String reason, final int code) {
                FeatureLog.i((String)"FTquickAnswer", (String)"getQuickAnswer gid:%s, error, code:%s, reason:%s", (Object[])new Object[]{gid, code, reason});
                BaseRequestManager.statMetric((String)"channel/getquickans", (long)(SystemClock.uptimeMillis() - startTime), (boolean)false, (long)code);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (callback2 != null) {
                            callback2.onFail(code, reason);
                        }
                    }
                });
                return false;
            }
        });
    }

    public static interface IQuickReplyCallback {
        public void onSuccess(String var1, List<String> var2);

        public void onFail(int var1, String var2);
    }
}

