/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bottombar.emoji;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.SpannableString;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.edit.FixEditTextView;
import com.yy.appbase.ui.widget.indicator.CirclePageIndicator;
import com.yy.base.keyevent.OwnKeyEvent;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.component.bottombar.emoji.EmotionAdapter;
import com.yy.hiyo.channel.component.bottombar.emoji.SmileFacePagerAdapter;
import com.yy.hiyo.emotion.base.emoji.EmojiEntity;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import java.util.ArrayList;
import java.util.List;

public class EmojiEmotionsView
extends YYRelativeLayout {
    ViewPager viewPager;
    CirclePageIndicator pageIndicator;
    static final int COLUMN = 7;
    static final int ROW = 3;
    static final int VERTICAL_SPACING = 20;
    Context activity;
    FixEditTextView inputEditText;

    public EmojiEmotionsView(Context context, FixEditTextView inputEditText) {
        super(context);
        this.inputEditText = inputEditText;
        this.init();
    }

    private void init() {
        this.activity = this.getContext();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_emoji_channel, (ViewGroup)this, true);
        this.genEmojiPager();
    }

    private void genEmojiPager() {
        this.viewPager = (ViewPager)this.findViewById(R.id.vp_msg_input_emoticon);
        this.pageIndicator = (CirclePageIndicator)this.findViewById(R.id.page_indicator);
        ArrayList emojiArray = new ArrayList();
        emojiArray.addAll(EmojiManager.INSTANCE.getEmojiData());
        int onePageNumber = 20;
        int page = (int)Math.ceil(((float)emojiArray.size() + 0.0f) / (float)onePageNumber);
        int star = 0;
        int end = 0;
        ArrayList<View> gridViews = new ArrayList<View>();
        for (int i = 0; i < page; ++i) {
            List<EmojiEntity> array = new ArrayList();
            if (i == page - 1) {
                array = emojiArray.subList(end, emojiArray.size());
            } else {
                star = i * onePageNumber;
                end = (i + 1) * onePageNumber;
                array.addAll(emojiArray.subList(star, end));
            }
            array.add(new EmojiEntity(0));
            GridView gridView = new GridView(this.activity);
            gridView.setSelector((Drawable)new ColorDrawable(0));
            gridView.setNumColumns(7);
            gridView.setGravity(17);
            gridView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
            EmotionAdapter adapter2 = new EmotionAdapter(this.activity);
            gridView.setAdapter((ListAdapter)adapter2);
            adapter2.setDatas(array);
            EmojiItemClickListener itemClickListener = new EmojiItemClickListener(array);
            gridView.setOnItemClickListener((AdapterView.OnItemClickListener)itemClickListener);
            gridViews.add((View)gridView);
        }
        this.viewPager.setAdapter((PagerAdapter)new SmileFacePagerAdapter(gridViews));
        this.pageIndicator.setViewPager(this.viewPager);
    }

    public class EmojiItemClickListener
    implements AdapterView.OnItemClickListener {
        List<EmojiEntity> emojiArray;
        Activity context;

        public EmojiItemClickListener(List<EmojiEntity> emojiArray) {
            this.emojiArray = emojiArray;
            this.context = (Activity)EmojiEmotionsView.this.inputEditText.getContext();
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
            EmojiEmotionsView.this.inputEditText.requestFocus();
            EmojiEntity emojiEntity = this.emojiArray.get(i);
            if (emojiEntity.getId() == 0) {
                EmojiEmotionsView.this.inputEditText.dispatchKeyEvent((KeyEvent)new OwnKeyEvent(0, 67, false));
                EmojiEmotionsView.this.inputEditText.dispatchKeyEvent((KeyEvent)new OwnKeyEvent(1, 67, false));
            } else {
                int index = EmojiEmotionsView.this.inputEditText.getSelectionStart();
                Editable editText = EmojiEmotionsView.this.inputEditText.getEditableText();
                SpannableString emojiStr = EmojiManager.INSTANCE.getNewEmojiImage(emojiEntity.getCode());
                if (index < 0 || index >= editText.length()) {
                    editText.append((CharSequence)emojiStr);
                } else {
                    editText.insert(index, (CharSequence)emojiStr);
                }
            }
        }
    }
}

