/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.bigface;

import android.graphics.Bitmap;
import android.text.TextUtils;
import biz.SimpleCardInfo;
import biz.UserMark;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.data.FaceDbBean;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.event.kvo.list.KvoList;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.bigface.IRoomBigFaceServices;
import com.yy.hiyo.bigface.base.data.BigFaceModuleData;
import com.yy.hiyo.bigface.base.data.bean.BigFaceTabInfoBean;
import com.yy.hiyo.channel.base.callback.bigface.IGetFaceResCallBack;
import com.yy.hiyo.channel.base.service.IChannelHonorService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.radio.IVideoLinkMicPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IMsgItemFactory;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.BigFaceMsg;
import com.yy.hiyo.channel.component.bigface.FaceCommonPresenter;
import com.yy.hiyo.channel.component.bigface.FaceGamePresenter;
import com.yy.hiyo.channel.component.bigface.FaceMsgViewModel;
import com.yy.hiyo.channel.component.bigface.FaceNotifyDispatchService;
import com.yy.hiyo.channel.component.bigface.FaceRedDotViewModel;
import com.yy.hiyo.channel.component.bigface.FaceResManager;
import com.yy.hiyo.channel.component.bigface.ICommonFaceMvp;
import com.yy.hiyo.channel.component.bigface.IFaceMvp;
import com.yy.hiyo.channel.component.bottombar.BottomPresenter;
import com.yy.hiyo.channel.component.dragbar.PublicScreenDragBarPresenter;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.INotifyDispatchService;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ihago.room.api.bigemoji.BCInfo;
import net.ihago.room.api.bigemoji.BCRandomVal;
import net.ihago.room.api.bigemoji.EmojiPush;
import net.ihago.room.api.bigemoji.Uri;
import org.jetbrains.annotations.NotNull;

public class FacePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IFaceMvp.IPresenter {
    private static final String TAG = "BFace";
    private IFaceMvp.IView mView;
    private FaceNotifyDispatchService mFaceNotifyDispatchService;
    private FaceCommonPresenter mFaceCommonPresenter;
    private KvoBinder mKvoBinder = new KvoBinder((Object)this);

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        super.onInit(mvpContext);
        this.mFaceNotifyDispatchService = new FaceNotifyDispatchService();
        this.mFaceNotifyDispatchService.setRoomId(this.getChannel().getChannelId());
        this.mFaceCommonPresenter = new FaceCommonPresenter();
        this.mFaceNotifyDispatchService.addHandler((INotifyDispatchService.INotifyHandler)new INotifyDispatchService.INotifyHandler<EmojiPush>(){

            public void onHandleNotify(EmojiPush notify2) {
                FacePresenter.this.handleFaceNotify(notify2);
            }
        });
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.mFaceNotifyDispatchService);
        this.requestData();
    }

    public void onPageAttach(@NotNull AbsPage page, boolean isReAttach) {
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            this.getViewModel(FaceMsgViewModel.class);
            this.getViewModel(FaceRedDotViewModel.class);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.mKvoBinder.clearAllKvoConnections();
        ProtoManager.getInstance().unregisterNotify((IProtoNotify)this.mFaceNotifyDispatchService);
    }

    @Override
    public void setView(IFaceMvp.IView iView) {
        this.mView = iView;
    }

    @Override
    public void requestData() {
        this.mFaceCommonPresenter.requestData(this.getChannel().getChannelId(), new ICommonFaceMvp.CallBack<List<FaceDbBean>>(){

            @Override
            public void onSuccess(List<FaceDbBean> data2) {
                if (FacePresenter.this.mView != null) {
                    FacePresenter.this.mView.setData(data2);
                }
                if (!FacePresenter.this.isDestroyed()) {
                    ((IPublicScreenModulePresenter)FacePresenter.this.getPresenter(IPublicScreenModulePresenter.class)).onBigfaceBeanBack();
                }
            }

            @Override
            public void onFail() {
                if (FacePresenter.this.mView != null) {
                    FacePresenter.this.mView.hideLoading();
                }
            }
        });
        ServiceManagerProxy.getInstance().observeService(IRoomBigFaceServices.class, (Callback)new Callback<IRoomBigFaceServices>(){

            public void onResponse(IRoomBigFaceServices data2) {
                data2.requestTabBigFaceList(FacePresenter.this.getChannel().getChannelId());
                FacePresenter.this.mKvoBinder.singleBindSourceTo((KvoSource)data2.data());
            }
        });
    }

    @KvoMethodAnnotation(name="bigface_tab_list", sourceClass=BigFaceModuleData.class)
    public void onListChange(KvoEventIntent eventIntent) {
        KvoList sourceList = (KvoList)eventIntent.newValue();
        if (sourceList != null) {
            ArrayList tabInfoInfoList = new ArrayList(sourceList);
            YYTaskExecutor.execute(() -> {
                for (BigFaceTabInfoBean faceTab : tabInfoInfoList) {
                    for (FaceDbBean face : faceTab.getEmojiList()) {
                        FaceResManager.getInstance().preloadRes(face);
                    }
                }
            });
        }
    }

    private void sendFaceInner(FaceDbBean dbBean) {
        if (this.isDestroyed()) {
            return;
        }
        if (((PublicScreenDragBarPresenter)this.getPresenter(PublicScreenDragBarPresenter.class)).isSeatVisible() && !this.isLinkMic()) {
            this.mFaceCommonPresenter.sendFace(dbBean, this.getChannel().getChannelId(), new ICommonFaceMvp.CallBack<BCInfo>(){

                @Override
                public void onSuccess(BCInfo data2) {
                    FacePresenter.this.handleFaceSvgaShow(data2, true);
                }

                @Override
                public void onFail() {
                }
            });
        } else {
            IMsgItemFactory factory = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory();
            IPublicScreenPresenter publicScreenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            if (factory != null && publicScreenPresenter != null) {
                BigFaceMsg bigFaceMsg = factory.generateBigFaceMsg(this.getChannelId(), AccountUtil.getUid(), this.getChannel().getRoleService().getMyRoleCache(), dbBean, true, null, "");
                publicScreenPresenter.appendLocalMsgAndSendToServer((BaseImMsg)bigFaceMsg);
            }
        }
    }

    @Override
    public void sendFace(final FaceDbBean dbBean) {
        if (SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"env_svga_gift_ani_test", (int)-1) == 2) {
            for (int i = 0; i < 100; ++i) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FacePresenter.this.sendFaceInner(dbBean);
                    }
                }, (long)(500 * i));
            }
        } else {
            this.sendFaceInner(dbBean);
        }
    }

    private boolean isLinkMic() {
        return ((IChannelPageContext)this.getMvpContext()).hasPresenter(IVideoLinkMicPresenter.class) && ((IVideoLinkMicPresenter)this.getPresenter(IVideoLinkMicPresenter.class)).isLinkMic();
    }

    private void handleFaceNotify(EmojiPush data2) {
        if (data2 instanceof EmojiPush) {
            EmojiPush faceData = data2;
            Uri faceUri = faceData.uri;
            final BCInfo bcInfo = faceData.bcinfo;
            if (faceUri != null && bcInfo != null && faceUri == Uri.UriBCInfo && bcInfo.from_uid != AccountUtil.getUid()) {
                MLog.info((Object)TAG, (String)("\u5904\u7406\u5927\u8868\u60c5\u5e7f\u64ad " + bcInfo.id), (Object[])new Object[0]);
                if (SystemUtils.isShowEnvSetting() && SettingFlags.getIntValue((String)"env_svga_gift_ani_test", (int)-1) == 2) {
                    for (int i = 0; i < 100; ++i) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                FacePresenter.this.handleFaceSvgaShow(bcInfo, false);
                            }
                        }, (long)(500 * i));
                    }
                } else {
                    this.handleFaceSvgaShow(bcInfo, false);
                }
            } else if (faceUri == null) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u5e7f\u64ad\u7684 faceUri \u662f null", (Object[])new Object[0]);
            } else if (bcInfo == null) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u5e7f\u64ad\u7684 bcInfo \u662f null", (Object[])new Object[0]);
            } else if (faceUri != Uri.UriBCInfo) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u5e7f\u64ad\u7684 faceUri \u662f \u9519\u8bef\u7684", (Object[])new Object[0]);
            } else if (bcInfo.from_uid == AccountUtil.getUid()) {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u5e7f\u64ad\u7684 \u8868\u60c5\u662f\u81ea\u5df1\u53d1\u51fa\u7684", (Object[])new Object[0]);
            }
        }
    }

    private void handleFaceSvgaShow(BCInfo bcInfo, boolean isMySend) {
        FaceDbBean dbBean = ((IRoomBigFaceServices)ServiceManagerProxy.getServiceManager().getService(IRoomBigFaceServices.class)).findFaceBean(bcInfo.id);
        if (dbBean != null) {
            if (isMySend && dbBean.isCold()) {
                this.setBottomFaceIconEnable(false);
            }
            if (bcInfo.random_vals.size() > 0) {
                this.handleFaceRandom(bcInfo, dbBean);
            } else {
                this.handleFaceFixed(bcInfo, dbBean);
            }
        }
    }

    private void handleFaceRandom(final BCInfo bcInfo, final FaceDbBean dbBean) {
        MLog.info((Object)TAG, (String)("handleFaceRandom  " + dbBean.getFaceId()), (Object[])new Object[0]);
        List list2 = bcInfo.random_vals;
        final ArrayList<String> arrayList = new ArrayList<String>();
        final HashMap<String, String> resultKeyValue = new HashMap<String, String>();
        for (int i = 0; i < bcInfo.random_vals.size(); ++i) {
            BCRandomVal bcRandomVal = (BCRandomVal)list2.get(i);
            arrayList.add(bcRandomVal.rand_val);
            resultKeyValue.put(bcRandomVal.key, bcRandomVal.rand_val);
        }
        arrayList.add(bcInfo.id + ".svga");
        FaceResManager.getInstance().getResPath(dbBean, arrayList, new IGetFaceResCallBack(){

            public void onSuccess(final HashMap<String, String> resValue) {
                if (FacePresenter.this.isDestroyed()) {
                    return;
                }
                final HashMap svgaMap = new HashMap();
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        File file = null;
                        for (int i = 0; i < arrayList.size(); ++i) {
                            String imageName = (String)arrayList.get(i);
                            String localUrl = (String)resValue.get(imageName);
                            if (!imageName.endsWith(".svga")) {
                                Bitmap bitmap = YYImageUtils.decodeFile((String)localUrl);
                                List keys = (List)FacePresenter.this.getKey(resultKeyValue, imageName);
                                for (int j = 0; j < keys.size(); ++j) {
                                    String key = (String)keys.get(j);
                                    svgaMap.put(key, bitmap);
                                }
                                continue;
                            }
                            if (!StringUtils.isNotEmpty((String)localUrl)) continue;
                            file = new File(localUrl);
                        }
                        final File fFile = file;
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (svgaMap.size() > 0 && fFile != null) {
                                    MLog.info((Object)FacePresenter.TAG, (String)"\u5e7f\u64ad \u83b7\u53d6\u5230sd\u5361\u4e0a\u7684\u6587\u4ef6", (Object[])new Object[0]);
                                    ((FaceGamePresenter)FacePresenter.this.getPresenter(FaceGamePresenter.class)).addFaceView(bcInfo.from_uid, false, svgaMap, fFile, new FaceGamePresenter.FaceSvgaAnimCallBack(){

                                        @Override
                                        public void onSvgaAnimFinish(Bitmap bitmap) {
                                            FacePresenter.this.randomFaceResult(dbBean, arrayList, bcInfo, bitmap, resValue);
                                        }

                                        @Override
                                        public void onSvgaComplete() {
                                            if (bcInfo.from_uid == AccountUtil.getUid()) {
                                                FacePresenter.this.setBottomFaceIconEnable(true);
                                            }
                                        }

                                        @Override
                                        public void onNoLocation() {
                                            FacePresenter.this.randomFaceResult(dbBean, arrayList, bcInfo, null, null);
                                        }
                                    });
                                } else if (svgaMap.size() == 0) {
                                    MLog.info((Object)FacePresenter.TAG, (String)"\u5e7f\u64ad svgaMap.size()==0", (Object[])new Object[0]);
                                } else if (fFile == null) {
                                    MLog.info((Object)FacePresenter.TAG, (String)"\u5e7f\u64ad file == null", (Object[])new Object[0]);
                                }
                            }
                        });
                    }
                });
            }

            public void onError(int errorType, String errorInfo) {
                MLog.error((Object)FacePresenter.TAG, (String)("handleFaceRandom getResPath error, " + errorInfo), (Object[])new Object[0]);
            }
        });
        this.appendRandomResultMsg(dbBean, bcInfo);
    }

    private void handleFaceFixed(final BCInfo bcInfo, final FaceDbBean dbBean) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.info((Object)TAG, (String)("\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b handleFaceFixed  " + dbBean.getFaceId()), (Object[])new Object[0]);
        }
        FaceResManager.getInstance().getResPath(dbBean, bcInfo.id + ".svga", new IGetFaceResCallBack(){

            public void onSuccess(HashMap<String, String> resValue) {
                if (FacePresenter.this.isDestroyed()) {
                    return;
                }
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.info((Object)FacePresenter.TAG, (String)"\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b \u83b7\u53d6\u5230sd\u5361\u4e0a\u7684\u6587\u4ef6", (Object[])new Object[0]);
                }
                File file = new File(resValue.get(bcInfo.id + ".svga"));
                ((FaceGamePresenter)FacePresenter.this.getPresenter(FaceGamePresenter.class)).addFaceView(bcInfo.from_uid, false, null, file, new FaceGamePresenter.FaceSvgaAnimCallBack(){

                    @Override
                    public void onSvgaAnimFinish(Bitmap bitmap) {
                        FacePresenter.this.fixedFaceResult(dbBean, bcInfo, bitmap);
                    }

                    @Override
                    public void onSvgaComplete() {
                        if (bcInfo.from_uid == AccountUtil.getUid()) {
                            FacePresenter.this.setBottomFaceIconEnable(true);
                        }
                    }

                    @Override
                    public void onNoLocation() {
                        FacePresenter.this.fixedFaceResult(dbBean, bcInfo, null);
                    }
                });
            }

            public void onError(int errorType, String errorInfo) {
                MLog.error((Object)FacePresenter.TAG, (String)("handleFaceFixed getResPath error, " + errorInfo), (Object[])new Object[0]);
            }
        });
        this.appendFixResultMsg(dbBean, bcInfo);
    }

    private Object getKey(Map map, Object value) {
        ArrayList keyList = new ArrayList();
        for (Object key : map.keySet()) {
            if (!map.get(key).equals(value)) continue;
            keyList.add(key);
        }
        return keyList;
    }

    private void randomFaceResult(FaceDbBean dbBean, ArrayList<String> arrayList, BCInfo bcInfo, Bitmap bitmap, HashMap<String, String> resValue) {
        if (this.isDestroyed()) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b svga\u64ad\u653e\u5b8c\u6bd5 \u8fd4\u56debitmap", (Object[])new Object[0]);
        }
        if (bcInfo.from_uid == AccountUtil.getUid()) {
            this.setBottomFaceIconEnable(true);
        }
    }

    private void appendRandomResultMsg(FaceDbBean dbBean, BCInfo bcInfo) {
        if (dbBean.isSettle()) {
            IPublicScreenPresenter screenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (screenPresenter != null && service != null) {
                MLog.info((Object)TAG, (String)("\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b \u53d1\u9001\u516c\u5c4f" + dbBean.getFaceId()), (Object[])new Object[0]);
                BigFaceMsg msg = service.getMsgItemFactory().generateBigFaceMsg(this.getChannel().getChannelId(), bcInfo.from_uid.longValue(), this.getChannel().getRoleService().getRoleCache(bcInfo.from_uid.longValue()), dbBean, false, null, null);
                msg.setMsgState(1);
                List randomVals = bcInfo.random_vals;
                ArrayList<FaceDbBean.RandomVal> randomValList = new ArrayList<FaceDbBean.RandomVal>();
                for (int i = 0; i < randomVals.size(); ++i) {
                    BCRandomVal randomVal = (BCRandomVal)randomVals.get(i);
                    if (!TextUtils.isEmpty((CharSequence)randomVal.rand_val) && !TextUtils.isEmpty((CharSequence)randomVal.key)) {
                        String strValue;
                        int endIndex;
                        String key = randomVal.key;
                        String value = randomVal.rand_val;
                        FaceDbBean.RandomVal randomVal1 = new FaceDbBean.RandomVal();
                        randomVal1.key = key;
                        int startIndex = value.indexOf("_");
                        if (startIndex + 1 < (endIndex = value.indexOf(".")) && !TextUtils.isEmpty((CharSequence)(strValue = value.substring(startIndex + 1, endIndex)))) {
                            try {
                                randomVal1.randomVal = Integer.valueOf(strValue);
                                randomValList.add(randomVal1);
                            }
                            catch (Exception e) {
                                MLog.info((Object)TAG, (String)("\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b publicScreenService is error " + strValue + ":" + e.toString()), (Object[])new Object[0]);
                            }
                        }
                    }
                    BigFaceMsg.addResult((BigFaceMsg)msg, randomValList);
                }
                this.insertUserMark((BaseImMsg)msg, bcInfo.from_umark);
                screenPresenter.appendLocalMsg((BaseImMsg)msg);
            } else {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b publicScreenService is null", (Object[])new Object[0]);
            }
        }
    }

    private void fixedFaceResult(FaceDbBean dbBean, BCInfo bcInfo, Bitmap bitmap) {
        if (this.isDestroyed()) {
            return;
        }
        MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b svga\u64ad\u653e\u5b8c\u6bd5 \u8fd4\u56debitmap", (Object[])new Object[0]);
        if (bcInfo.from_uid == AccountUtil.getUid()) {
            this.setBottomFaceIconEnable(true);
        }
    }

    private void appendFixResultMsg(FaceDbBean dbBean, BCInfo bcInfo) {
        if (this.isDestroyed()) {
            return;
        }
        if (dbBean.isSettle()) {
            IPublicScreenPresenter screenPresenter = ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter();
            IPublicScreenService service = (IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class);
            if (screenPresenter != null && service != null) {
                MLog.info((Object)TAG, (String)("\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b \u53d1\u9001\u516c\u5c4f" + dbBean.getFaceId()), (Object[])new Object[0]);
                IMsgItemFactory factory = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory();
                BigFaceMsg msg = factory.generateBigFaceMsg(this.getChannel().getChannelId(), bcInfo.from_uid.longValue(), this.getChannel().getRoleService().getRoleCache(bcInfo.from_uid.longValue()), dbBean, true, null, dbBean.getThumbnail());
                msg.setMsgState(1);
                this.insertUserMark((BaseImMsg)msg, bcInfo.from_umark);
                screenPresenter.appendLocalMsg((BaseImMsg)msg);
            } else {
                MLog.info((Object)TAG, (String)"\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b publicScreenService is null", (Object[])new Object[0]);
            }
        } else {
            MLog.info((Object)TAG, (String)("\u5927\u8868\u60c5\u7684\u5904\u7406\u5e7f\u64ad\u6d41\u7a0b \u8868\u60c5\u4e0d\u80fd\u6c89\u6dc0" + dbBean.getFaceId()), (Object[])new Object[0]);
        }
    }

    private void setBottomFaceIconEnable(boolean enable) {
        if (this.isDestroyed()) {
            return;
        }
        ((BottomPresenter)this.getPresenter(BottomPresenter.class)).setFaceEnable(enable);
    }

    @Override
    public FaceDbBean getCacheDbbean(String id2) {
        if (this.mFaceCommonPresenter != null) {
            return this.mFaceCommonPresenter.getCacheFaceDb(id2);
        }
        return null;
    }

    private void insertUserMark(BaseImMsg msgItem, UserMark userMark) {
        MLog.info((Object)TAG, (String)"insertUserMark %s, %s", (Object[])new Object[]{msgItem, userMark});
        if (userMark == null) {
            return;
        }
        ArrayList honorIds = new ArrayList(userMark.medal_id);
        msgItem.setHonerIds(honorIds);
        msgItem.setIsNewComer(userMark.new_comer.booleanValue());
        if (ServiceManagerProxy.getService(IChannelHonorService.class) != null) {
            ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfHonorIds(honorIds);
        }
        if (userMark.cards != null) {
            ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo> list2 = new ArrayList<com.yy.hiyo.channel.base.bean.SimpleCardInfo>(userMark.cards.size());
            for (SimpleCardInfo cardInfo : userMark.cards) {
                list2.add(new com.yy.hiyo.channel.base.bean.SimpleCardInfo(cardInfo.card_type.intValue(), cardInfo.level.intValue(), cardInfo.name, cardInfo.fid, cardInfo.sub_type));
            }
            msgItem.getUserTagInfos().postValue(list2);
            ((IChannelHonorService)ServiceManagerProxy.getService(IChannelHonorService.class)).updateSelfUserTags(list2);
        }
    }
}

