/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.barrage.ui;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.SpannableString;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnProfileListCallback;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.BaseBarrageMsgData;
import com.yy.hiyo.channel.base.bean.video.BarrageConfigData;
import com.yy.hiyo.channel.base.service.IChannelBarrageService;
import com.yy.hiyo.channel.component.barrage.IBarragePresenterCallback;
import com.yy.hiyo.emotion.base.emoji.EmojiManager;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0010J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/yy/hiyo/channel/component/barrage/ui/BarrageView;", "Lcom/yy/base/memoryrecycle/views/YYConstraintLayout;", "Landroid/view/View$OnClickListener;", "context", "Landroid/content/Context;", "data", "Lcom/yy/hiyo/channel/base/bean/BaseBarrageMsgData;", "callback", "Lcom/yy/hiyo/channel/component/barrage/IBarragePresenterCallback;", "layer", "Landroid/view/ViewGroup;", "screenWidth", "", "(Landroid/content/Context;Lcom/yy/hiyo/channel/base/bean/BaseBarrageMsgData;Lcom/yy/hiyo/channel/component/barrage/IBarragePresenterCallback;Landroid/view/ViewGroup;I)V", "maxBarrageWidth", "time", "", "translationWidth", "getStartEnterAnim", "Landroid/animation/ObjectAnimator;", "onClick", "", "p0", "Landroid/view/View;", "startAnim", "updateUserInfo", "userInfoBean", "Lcom/yy/appbase/data/UserInfoBean;", "Companion", "channel-components_release"})
public final class BarrageView
extends YYConstraintLayout
implements View.OnClickListener {
    private long time;
    private int translationWidth;
    private final int maxBarrageWidth;
    private final BaseBarrageMsgData data;
    private final IBarragePresenterCallback callback;
    private final ViewGroup layer;
    public static final long DURATION = 7000L;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void updateUserInfo(UserInfoBean userInfoBean) {
        YYTextView yYTextView = (YYTextView)this._$_findCachedViewById(R.id.tvName);
        Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"tvName");
        yYTextView.setText((CharSequence)(userInfoBean.getNick() + ':'));
        ImageLoader.loadImage((ImageView)((CircleImageView)this._$_findCachedViewById(R.id.avatar)), (String)userInfoBean.getAvatar());
    }

    public final long startAnim() {
        block1: {
            this.layer.addView((View)this);
            BarrageView $this$updateLayoutParams$iv = this;
            boolean $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ViewGroup.MarginLayoutParams)layoutParams);
            ViewGroup.MarginLayoutParams $this$updateLayoutParams = (ViewGroup.MarginLayoutParams)params$iv;
            boolean bl = false;
            $this$updateLayoutParams.topMargin = this.callback.getMarginTop();
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
            ObjectAnimator objectAnimator = this.getStartEnterAnim();
            if (objectAnimator == null) break block1;
            objectAnimator.start();
        }
        return this.time;
    }

    private final ObjectAnimator getStartEnterAnim() {
        ObjectAnimator mStartAnimator = null;
        float trans = this.translationWidth;
        if (LanguageUtils.isRtl()) {
            trans = -((float)this.translationWidth);
        }
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.TRANSLATION_X, (float[])new float[]{trans, -trans})});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator\n         \u2026LATION_X, trans, -trans))");
        mStartAnimator = objectAnimator;
        mStartAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mStartAnimator.setDuration(7000L);
        mStartAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ BarrageView this$0;

            public void onAnimationEnd(@Nullable Animator animation) {
                block4: {
                    super.onAnimationEnd(animation);
                    BarrageView $this$removeSelfFromParent$iv = this.this$0;
                    boolean $i$f$removeSelfFromParent = false;
                    if ($this$removeSelfFromParent$iv.getParent() != null && $this$removeSelfFromParent$iv.getParent() instanceof ViewGroup) {
                        try {
                            ViewParent viewParent = $this$removeSelfFromParent$iv.getParent();
                            if (viewParent == null) {
                                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                            }
                            ((ViewGroup)viewParent).removeView((View)$this$removeSelfFromParent$iv);
                        }
                        catch (Exception e$iv) {
                            MLog.error((Object)"removeSelfFromParent", (Throwable)e$iv);
                            if (!RuntimeContext.isLocalBuild()) break block4;
                            throw (Throwable)e$iv;
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        return mStartAnimator;
    }

    public void onClick(@Nullable View p0) {
        Boolean has;
        IChannelBarrageService iChannelBarrageService = this.callback.getBarrageService();
        Boolean bl = iChannelBarrageService != null && (iChannelBarrageService = iChannelBarrageService.getBarrageConfig(null, false)) != null && (iChannelBarrageService = (BarrageConfigData)iChannelBarrageService.getValue()) != null ? Boolean.valueOf(iChannelBarrageService.getHas()) : (has = null);
        if (Intrinsics.areEqual(has, (Object)true) ^ true) {
            String string2 = this.data.getPopUrl();
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager != null && (iServiceManager = (IYYUriService)iServiceManager.getService(IYYUriService.class)) != null) {
                iServiceManager.handleUriString(it);
            }
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("60070400").put("event", "send_barrage_click").put("is_noble", Intrinsics.areEqual((Object)has, (Object)true) ? "1" : "2"));
    }

    public BarrageView(@NotNull Context context, @NotNull BaseBarrageMsgData data2, @NotNull IBarragePresenterCallback callback2, @NotNull ViewGroup layer, int screenWidth) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)data2, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
            Intrinsics.checkParameterIsNotNull((Object)layer, (String)"layer");
            super(context);
            this.data = data2;
            this.callback = callback2;
            this.layer = layer;
            this.time = 1200L;
            this.maxBarrageWidth = DpToPxDef.RESOLUTION_100_DP * 5 + DpToPxDef.RESOLUTION_30_DP;
            View.inflate((Context)context, (int)R.layout.layout_barrage_view, (ViewGroup)((ViewGroup)this));
            SpannableString content = EmojiManager.INSTANCE.getExpressionString(String.valueOf(this.data.getTextContent()));
            YYTextView yYTextView = (YYTextView)this._$_findCachedViewById(R.id.tvContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView, (String)"tvContent");
            yYTextView.setText((CharSequence)content);
            YYTextView yYTextView2 = (YYTextView)this._$_findCachedViewById(R.id.tvContent);
            Intrinsics.checkExpressionValueIsNotNull((Object)yYTextView2, (String)"tvContent");
            float wid = yYTextView2.getPaint().measureText(String.valueOf(this.data.getTextContent())) + (float)DpToPxDef.RESOLUTION_30_DP;
            if (wid > (float)this.maxBarrageWidth) {
                wid = this.maxBarrageWidth;
            }
            this.time = (long)((double)(wid * (float)7000L) * 0.5 / (double)screenWidth) + (long)500;
            this.translationWidth = ResolutionUtils.getScreenWidth((Context)context);
            ((CircleImageView)this._$_findCachedViewById(R.id.avatar)).setOnClickListener((View.OnClickListener)this);
            ((YYTextView)this._$_findCachedViewById(R.id.tvContent)).setOnClickListener((View.OnClickListener)this);
            ((YYTextView)this._$_findCachedViewById(R.id.tvName)).setOnClickListener((View.OnClickListener)this);
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IUserInfoService)iServiceManager.getService(IUserInfoService.class)) == null || (iServiceManager = iServiceManager.getUserInfo(this.data.getSender(), new OnProfileListCallback(){

                public void onError(@Nullable Call call, @Nullable Exception e, int id2) {
                }

                public void onResponseError(int id2, @Nullable String message, @Nullable String response) {
                }

                public void onUISuccess(@Nullable List<UserInfoBean> userInfo) {
                    if (userInfo != null && userInfo.size() > 0) {
                        this.updateUserInfo(userInfo.get(0));
                    }
                }
            })) == null) break block1;
            IServiceManager iServiceManager2 = iServiceManager;
            boolean bl = false;
            boolean bl2 = false;
            IServiceManager $this$apply = iServiceManager2;
            boolean bl3 = false;
            this.updateUserInfo((UserInfoBean)$this$apply);
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/barrage/ui/BarrageView$Companion;", "", "()V", "DURATION", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

