/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.barrage;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.DpToPxDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.degrade.DiscardResult;
import com.yy.appbase.degrade.ISceneDegradedService;
import com.yy.appbase.degrade.ISceneOptLimiter;
import com.yy.appbase.degrade.ISceneOptLimiterCallback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.ScenePerfOptSceneDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.BaseBarrageMsgData;
import com.yy.hiyo.channel.base.bean.plugins.ChannelPluginData;
import com.yy.hiyo.channel.base.bean.video.BarrageConfigData;
import com.yy.hiyo.channel.base.service.IChannelBarrageService;
import com.yy.hiyo.channel.base.service.plugin.IPluginService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.component.barrage.BarragePresenter;
import com.yy.hiyo.channel.component.barrage.BarrageTest;
import com.yy.hiyo.channel.component.barrage.IBarragePresenterCallback;
import com.yy.hiyo.channel.component.barrage.ui.BarrageView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.money.api.nobleprize.ECode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\t\u0018\u0000 <2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u00020\u0004:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0005J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020!H\u0016J<\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00110(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*2\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020!H\u0002J\b\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u000201H\u0016J\u0018\u00103\u001a\u0002012\u0006\u00104\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u000eH\u0016J\u0010\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u0011H\u0002J\u000e\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002012\u0006\u00107\u001a\u00020\u0011H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/yy/hiyo/channel/component/barrage/BarragePresenter;", "Lcom/yy/hiyo/channel/cbase/context/BaseChannelPresenter;", "Lcom/yy/hiyo/channel/cbase/AbsPage;", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "Lcom/yy/hiyo/channel/component/barrage/IBarragePresenterCallback;", "()V", "barrageLayer", "Lcom/yy/base/memoryrecycle/views/YYFrameLayout;", "barrageMsgListener", "com/yy/hiyo/channel/component/barrage/BarragePresenter$barrageMsgListener$1", "Lcom/yy/hiyo/channel/component/barrage/BarragePresenter$barrageMsgListener$1;", "barrageTest", "Lcom/yy/hiyo/channel/component/barrage/BarrageTest;", "canAnimate", "", "discardComparator", "Ljava/util/Comparator;", "Lcom/yy/hiyo/channel/base/bean/BaseBarrageMsgData;", "kotlin.jvm.PlatformType", "mQueue", "Ljava/util/concurrent/PriorityBlockingQueue;", "nextTimeRunnable", "Ljava/lang/Runnable;", "playing", "refreshTime", "", "sceneOptLimiter", "Lcom/yy/appbase/degrade/ISceneOptLimiter;", "getSceneOptLimiter", "()Lcom/yy/appbase/degrade/ISceneOptLimiter;", "sceneOptLimiter$delegate", "Lkotlin/Lazy;", "screenWidth", "", "getBarrageService", "Lcom/yy/hiyo/channel/base/service/IChannelBarrageService;", "getBarrageViewGroup", "Landroid/view/ViewGroup;", "getMarginTop", "getRealItemList", "", "itemList", "", "discardOther", "discardRatio", "", "discardMinRemain", "maxRemain", "next", "", "onDestroy", "onPageAttach", "page", "isReAttach", "realAddItem", "data", "sendMsg", "msg", "", "startBarrageAnim", "Companion", "channel-components_release"})
public final class BarragePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IBarragePresenterCallback {
    private boolean playing;
    private YYFrameLayout barrageLayer;
    private int screenWidth = 1000;
    private long refreshTime;
    private final Comparator<BaseBarrageMsgData> discardComparator = discardComparator.1.INSTANCE;
    private boolean canAnimate = true;
    private BarrageTest barrageTest;
    private final Lazy sceneOptLimiter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ISceneOptLimiter<BaseBarrageMsgData>>(this){
        final /* synthetic */ BarragePresenter this$0;

        @NotNull
        public final ISceneOptLimiter<BaseBarrageMsgData> invoke() {
            return ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).createLimiter("barrage", (ISceneOptLimiterCallback)new ISceneOptLimiterCallback<BaseBarrageMsgData>(this){
                final /* synthetic */ sceneOptLimiter.2 this$0;

                public boolean needSkip(@NotNull BaseBarrageMsgData item) {
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    return item.getSender() == AccountUtil.getUid();
                }

                public void onAppendItem(@NotNull BaseBarrageMsgData item) {
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    BarragePresenter.access$realAddItem(this.this$0.this$0, item);
                }

                @NotNull
                public DiscardResult onDiscard(@NotNull BaseBarrageMsgData item, float discardRatio, int discardMinRemain, int maxRemain) {
                    block0: {
                        List list2;
                        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                        List list3 = list2 = ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).findDiscardList((Collection)BarragePresenter.access$getMQueue$p(this.this$0.this$0), discardRatio, discardMinRemain, maxRemain, BarragePresenter.access$getDiscardComparator$p(this.this$0.this$0));
                        if (list3 == null) break block0;
                        List list4 = list3;
                        boolean bl = false;
                        boolean bl2 = false;
                        List it = list4;
                        boolean bl3 = false;
                        BarragePresenter.access$getMQueue$p(this.this$0.this$0).removeAll(it);
                    }
                    return DiscardResult.DISCARD_ALSO_NEW;
                }

                @Nullable
                public List<BaseBarrageMsgData> needDiscardWhenOnDiscard(@NotNull List<? extends BaseBarrageMsgData> items, float discardRatio, int discardMinRemain, int maxRemain) {
                    Intrinsics.checkParameterIsNotNull(items, (String)"items");
                    MLog.info((Object)"BarragePresenter", (String)("needDiscardWhenOnDiscard size " + items.size()), (Object[])new Object[0]);
                    return ((ISceneDegradedService)ServiceManagerProxy.getService(ISceneDegradedService.class)).findDiscardList((Collection)items, discardRatio, discardMinRemain, maxRemain, BarragePresenter.access$getDiscardComparator$p(this.this$0.this$0));
                }

                public void onStopAnimate() {
                    BarragePresenter.access$setCanAnimate$p(this.this$0.this$0, false);
                }

                public void onRecoverAnimate() {
                    BarragePresenter.access$setCanAnimate$p(this.this$0.this$0, true);
                    BarragePresenter.access$next(this.this$0.this$0);
                }
                {
                    this.this$0 = $outer;
                }

                public boolean isDisCardOldDataFrequency() {
                    return ISceneOptLimiterCallback.DefaultImpls.isDisCardOldDataFrequency((ISceneOptLimiterCallback)this);
                }
            });
        }
        {
            this.this$0 = barragePresenter;
            super(0);
        }
    }));
    private final PriorityBlockingQueue<BaseBarrageMsgData> mQueue = new PriorityBlockingQueue(15);
    private final Runnable nextTimeRunnable = new Runnable(this){
        final /* synthetic */ BarragePresenter this$0;

        public final void run() {
            BarragePresenter.access$setPlaying$p(this.this$0, false);
            BarragePresenter.access$next(this.this$0);
        }
        {
            this.this$0 = barragePresenter;
        }
    };
    private final barrageMsgListener.1 barrageMsgListener = new IChannelBarrageService.BarrageListener(this){
        final /* synthetic */ BarragePresenter this$0;

        public void onRecyBarrage(@Nullable BaseBarrageMsgData data2) {
            if (data2 == null) {
                return;
            }
            MLog.info((Object)"BarragePresenter", (String)"onRecyBarrage", (Object[])new Object[0]);
            BarragePresenter.access$getSceneOptLimiter$p(this.this$0).addItem((Object)data2, BarragePresenter.access$getMQueue$p(this.this$0).size());
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    public static final String TAG = "BarragePresenter";
    public static final Companion Companion = new Companion(null);

    private final ISceneOptLimiter<BaseBarrageMsgData> getSceneOptLimiter() {
        Lazy lazy = this.sceneOptLimiter$delegate;
        BarragePresenter barragePresenter = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ISceneOptLimiter)lazy.getValue();
    }

    private final List<BaseBarrageMsgData> getRealItemList(List<? extends BaseBarrageMsgData> itemList, boolean discardOther, float discardRatio, int discardMinRemain, int maxRemain) {
        List list2;
        int reserveNum;
        boolean bl = false;
        List selfMsgs = new ArrayList();
        boolean bl2 = false;
        List<BaseBarrageMsgData> otherMsgs = new ArrayList();
        Iterable $this$forEach$iv = itemList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseBarrageMsgData it = (BaseBarrageMsgData)element$iv;
            boolean bl3 = false;
            if (it.getSender() == AccountUtil.getUid()) {
                selfMsgs.add(it);
                continue;
            }
            otherMsgs.add(it);
        }
        int n = reserveNum = discardRatio > 0.0f ? (int)((float)otherMsgs.size() * (1.0f - discardRatio)) : 0;
        if (discardMinRemain > 0 && selfMsgs.size() + reserveNum < discardMinRemain) {
            int n2 = reserveNum = selfMsgs.size() + otherMsgs.size() <= discardMinRemain ? otherMsgs.size() : discardMinRemain - selfMsgs.size();
        }
        if (maxRemain > 0 && selfMsgs.size() + reserveNum > maxRemain) {
            if (selfMsgs.size() > maxRemain) {
                return discardOther ? selfMsgs.subList(0, maxRemain) : otherMsgs;
            }
            reserveNum = maxRemain - selfMsgs.size();
        }
        if (reserveNum > otherMsgs.size()) {
            reserveNum = otherMsgs.size();
        }
        MLog.info((Object)TAG, (String)("onDisCard itemList size:" + itemList.size() + ", " + "newItemList size: " + selfMsgs.size() + " reserveNum," + reserveNum), (Object[])new Object[0]);
        if (discardOther) {
            selfMsgs.addAll(otherMsgs.subList(0, reserveNum));
            list2 = selfMsgs;
        } else {
            list2 = otherMsgs.subList(reserveNum, otherMsgs.size());
        }
        return list2;
    }

    private final void realAddItem(BaseBarrageMsgData data2) {
        if (this.canAnimate && this.mQueue.isEmpty() && !this.playing) {
            this.startBarrageAnim(data2);
        } else {
            this.mQueue.offer(data2);
            this.next();
        }
    }

    public void onPageAttach(@NotNull AbsPage page, boolean isReAttach) {
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        super.onPageAttach(page, isReAttach);
        if (!isReAttach) {
            int state;
            CommonConfig commonConfig;
            AConfigData aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
            if (!(aConfigData instanceof CommonConfig)) {
                aConfigData = null;
            }
            int n = (commonConfig = (CommonConfig)aConfigData) != null && (commonConfig = commonConfig.getData()) != null ? commonConfig.barrageSwitchState : (state = 0);
            if (state == 0) {
                MLog.info((Object)TAG, (String)"onPageAttach return state is 0", (Object[])new Object[0]);
                return;
            }
            this.getChannel().getBarrageService().onInit();
            this.getChannel().getBarrageService().getBarrageConfig(null, true);
            ScreenUtils screenUtils = ScreenUtils.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)screenUtils, (String)"ScreenUtils.getInstance()");
            this.screenWidth = screenUtils.getWidthPixels();
            this.getChannel().getBarrageService().registerListener((IChannelBarrageService.BarrageListener)this.barrageMsgListener);
            if (ScenePerfOptSceneDef.isScenePressure((String)"barrage")) {
                if (this.barrageTest == null) {
                    this.barrageTest = new BarrageTest();
                }
                BarrageTest barrageTest = this.barrageTest;
                if (barrageTest == null) {
                    Intrinsics.throwNpe();
                }
                barrageTest.registerListener(this.barrageMsgListener);
            }
            this.getBarrageViewGroup();
        }
    }

    private final void next() {
        if (this.playing) {
            return;
        }
        if (!this.canAnimate) {
            MLog.info((Object)TAG, (String)"next size: %d", (Object[])new Object[]{this.mQueue.size()});
            return;
        }
        if (!this.mQueue.isEmpty()) {
            BaseBarrageMsgData data2;
            BaseBarrageMsgData baseBarrageMsgData = data2 = this.mQueue.poll();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseBarrageMsgData, (String)"data");
            this.startBarrageAnim(baseBarrageMsgData);
        }
    }

    private final void startBarrageAnim(BaseBarrageMsgData data2) {
        this.playing = true;
        FragmentActivity fragmentActivity = ((IChannelPageContext)this.getMvpContext()).getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"mvpContext.context");
        BarrageView barrageView = new BarrageView((Context)fragmentActivity, data2, this, this.getBarrageViewGroup(), this.screenWidth);
        YYTaskExecutor.postToMainThread((Runnable)this.nextTimeRunnable, (long)barrageView.startAnim());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void sendMsg(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        MutableLiveData mutableLiveData = IChannelBarrageService.DefaultImpls.getBarrageConfig$default((IChannelBarrageService)this.getChannel().getBarrageService(), null, (boolean)false, (int)3, null);
        if (mutableLiveData != null && (mutableLiveData = (BarrageConfigData)mutableLiveData.getValue()) != null) {
            if (mutableLiveData.getHas()) {
                this.getChannel().getBarrageService().sendBarrageTxt(this.getChannelId(), msg, (ICommonCallback)new ICommonCallback<Long>(this){
                    final /* synthetic */ BarragePresenter this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void onSuccess(@Nullable Long data2, Object ... ext) {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                        Long l = data2;
                        if (l != null) {
                            if ((int)l.longValue() == ECode.CODE_SHOUT_MSG_INVALID.getValue()) {
                                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_barrage_error), (int)0);
                                return;
                            }
                        }
                        Long l2 = data2;
                        if (l2 == null) return;
                        if ((int)l2.longValue() != ECode.CODE_SHOUT_NO_AUTH.getValue()) return;
                        this.this$0.getChannel().getBarrageService().getBarrageConfig(null, true);
                    }

                    public void onFail(int errCode, @Nullable String msg, Object ... ext) {
                        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
                return;
            }
        }
        MLog.info((Object)TAG, (String)"sendMsg error has is false", (Object[])new Object[0]);
    }

    private final ViewGroup getBarrageViewGroup() {
        if (this.barrageLayer == null) {
            this.barrageLayer = new YYFrameLayout((Context)((IChannelPageContext)this.getMvpContext()).getContext());
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            this.getWindow().getExtLayer().addView((View)this.barrageLayer, 0, lp);
        }
        YYFrameLayout yYFrameLayout = this.barrageLayer;
        if (yYFrameLayout == null) {
            Intrinsics.throwNpe();
        }
        return (ViewGroup)yYFrameLayout;
    }

    public void onDestroy() {
        block1: {
            BarrageTest it;
            boolean bl;
            boolean bl2;
            BarrageTest barrageTest;
            super.onDestroy();
            this.getSceneOptLimiter().destroy();
            BarrageTest barrageTest2 = this.barrageTest;
            if (barrageTest2 != null) {
                barrageTest = barrageTest2;
                bl2 = false;
                bl = false;
                it = barrageTest;
                boolean bl3 = false;
                it.onDestroy();
            }
            this.getChannel().getBarrageService().onDestroy();
            this.getChannel().getBarrageService().unregisterListener((IChannelBarrageService.BarrageListener)this.barrageMsgListener);
            YYTaskExecutor.removeTask((Runnable)this.nextTimeRunnable);
            this.mQueue.clear();
            YYFrameLayout yYFrameLayout = this.barrageLayer;
            if (yYFrameLayout == null) break block1;
            barrageTest = yYFrameLayout;
            bl2 = false;
            bl = false;
            it = barrageTest;
            boolean bl4 = false;
            this.getWindow().getExtLayer().removeView((View)it);
        }
    }

    @Override
    @Nullable
    public IChannelBarrageService getBarrageService() {
        return this.getChannel().getBarrageService();
    }

    @Override
    public int getMarginTop() {
        IPluginService iPluginService = this.getChannel().getPluginService();
        Intrinsics.checkExpressionValueIsNotNull((Object)iPluginService, (String)"channel.pluginService");
        ChannelPluginData channelPluginData = iPluginService.getCurPluginData();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPluginData, (String)"channel.pluginService.curPluginData");
        return channelPluginData.isVideoMode() ? DpToPxDef.RESOLUTION_100_DP : (int)((double)this.screenWidth * 0.3);
    }

    public static final /* synthetic */ void access$realAddItem(BarragePresenter $this, BaseBarrageMsgData data2) {
        $this.realAddItem(data2);
    }

    public static final /* synthetic */ PriorityBlockingQueue access$getMQueue$p(BarragePresenter $this) {
        return $this.mQueue;
    }

    public static final /* synthetic */ Comparator access$getDiscardComparator$p(BarragePresenter $this) {
        return $this.discardComparator;
    }

    public static final /* synthetic */ boolean access$getCanAnimate$p(BarragePresenter $this) {
        return $this.canAnimate;
    }

    public static final /* synthetic */ void access$setCanAnimate$p(BarragePresenter $this, boolean bl) {
        $this.canAnimate = bl;
    }

    public static final /* synthetic */ void access$next(BarragePresenter $this) {
        $this.next();
    }

    public static final /* synthetic */ boolean access$getPlaying$p(BarragePresenter $this) {
        return $this.playing;
    }

    public static final /* synthetic */ void access$setPlaying$p(BarragePresenter $this, boolean bl) {
        $this.playing = bl;
    }

    public static final /* synthetic */ ISceneOptLimiter access$getSceneOptLimiter$p(BarragePresenter $this) {
        return $this.getSceneOptLimiter();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/barrage/BarragePresenter$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

