/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.barrage;

import android.content.Context;
import androidx.lifecycle.Observer;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.video.BarrageConfigData;
import com.yy.hiyo.channel.base.service.IChannelBarrageService;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 !2\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\n \u0017*\u0004\u0018\u00010\r0\rH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001b\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001d\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u001e\u001a\u00020\u00142\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u001f\u001a\u00020\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/yy/hiyo/channel/component/barrage/BarrageHandler;", "", "callback", "Lcom/yy/hiyo/channel/component/barrage/BarrageHandler$BarrageHandlerCallback;", "(Lcom/yy/hiyo/channel/component/barrage/BarrageHandler$BarrageHandlerCallback;)V", "barrageConfigData", "Lcom/yy/hiyo/channel/base/bean/video/BarrageConfigData;", "isSelected", "", "maxTextLength", "", "msgCache", "", "", "nobelCardGuideJumpUrl", "observer", "Landroidx/lifecycle/Observer;", "reqConfigMillis", "", "change", "", "dismiss", "getEditHintContent", "kotlin.jvm.PlatformType", "isBarrageLimit", "isLimitText", "text", "onBarrageClick", "msg", "onSendClick", "show", "unSelect", "BarrageHandlerCallback", "Companion", "channel-components_release"})
public final class BarrageHandler {
    private final BarrageHandlerCallback callback;
    private boolean isSelected;
    private final Map<Boolean, String> msgCache;
    private BarrageConfigData barrageConfigData;
    private final int maxTextLength = 30;
    private long reqConfigMillis;
    private String nobelCardGuideJumpUrl;
    private final Observer<BarrageConfigData> observer;
    @NotNull
    public static final String TAG = "BarrageHandler";
    public static final Companion Companion = new Companion(null);

    public final void show(@Nullable String msg) {
        int state;
        AConfigData aConfigData;
        IChannelBarrageService iChannelBarrageService;
        IChannelBarrageService iChannelBarrageService2 = this.callback.getBarrageService();
        if (iChannelBarrageService2 != null && (iChannelBarrageService2 = IChannelBarrageService.DefaultImpls.getBarrageConfig$default((IChannelBarrageService)iChannelBarrageService2, null, (boolean)false, (int)3, null)) != null) {
            iChannelBarrageService2.removeObserver(this.observer);
        }
        if ((iChannelBarrageService = this.callback.getBarrageService()) != null && (iChannelBarrageService = IChannelBarrageService.DefaultImpls.getBarrageConfig$default((IChannelBarrageService)iChannelBarrageService, null, (boolean)false, (int)3, null)) != null) {
            iChannelBarrageService.observeForever(this.observer);
        }
        if (!((aConfigData = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG)) instanceof CommonConfig)) {
            aConfigData = null;
        }
        CommonConfig commonConfig = (CommonConfig)aConfigData;
        Object data2 = commonConfig != null ? commonConfig.getData() : null;
        Object object = data2;
        if (object == null || (object = object.nobelCardGuideJumpUrl) == null) {
            object = "";
        }
        this.nobelCardGuideJumpUrl = object;
        CommonConfigData commonConfigData = data2;
        int n = state = commonConfigData != null ? commonConfigData.barrageSwitchState : 0;
        if (state == 0) {
            return;
        }
        if (state == 2) {
            BarrageConfigData barrageConfigData = this.barrageConfigData;
            if (barrageConfigData == null || !barrageConfigData.isWhite()) {
                return;
            }
        }
        BarrageConfigData barrageConfigData = this.barrageConfigData;
        long resetSeconds = barrageConfigData != null ? barrageConfigData.getResetSecond() : 0L;
        long current = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)("show refresh resetSeconds " + resetSeconds + ", current" + (current - this.reqConfigMillis)), (Object[])new Object[0]);
        BarrageConfigData barrageConfigData2 = this.barrageConfigData;
        if (barrageConfigData2 != null) {
            if (barrageConfigData2.getHas()) {
                if (current - this.reqConfigMillis >= resetSeconds * (long)1000) {
                    IChannelBarrageService iChannelBarrageService3 = this.callback.getBarrageService();
                    if (iChannelBarrageService3 != null) {
                        iChannelBarrageService3.getBarrageConfig(null, true);
                    }
                    this.reqConfigMillis = current;
                }
            }
        }
        this.msgCache.put(this.isSelected, msg);
        String string2 = this.getEditHintContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getEditHintContent()");
        BarrageConfigData barrageConfigData3 = this.barrageConfigData;
        this.callback.onBarrageShow(this.isSelected, this.msgCache.get(this.isSelected), string2, this.maxTextLength, barrageConfigData3 != null ? barrageConfigData3.isNobelCardGuide() : false);
    }

    public final boolean isLimitText(@Nullable String text) {
        if (!this.isSelected) {
            return false;
        }
        String string2 = text;
        int length = string2 != null ? string2.length() : 0;
        return length >= this.maxTextLength;
    }

    public final void dismiss() {
        block0: {
            IChannelBarrageService iChannelBarrageService = this.callback.getBarrageService();
            if (iChannelBarrageService == null || (iChannelBarrageService = IChannelBarrageService.DefaultImpls.getBarrageConfig$default((IChannelBarrageService)iChannelBarrageService, null, (boolean)false, (int)3, null)) == null) break block0;
            iChannelBarrageService.removeObserver(this.observer);
        }
    }

    public final void unSelect() {
        this.isSelected = false;
        String string2 = this.getEditHintContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getEditHintContent()");
        BarrageConfigData barrageConfigData = this.barrageConfigData;
        this.callback.onBarrageShow(this.isSelected, this.msgCache.get(this.isSelected), string2, this.maxTextLength, barrageConfigData != null ? barrageConfigData.isNobelCardGuide() : false);
    }

    public final void onBarrageClick(@Nullable String msg) {
        if (!this.isBarrageLimit() && !this.isSelected) {
            return;
        }
        this.msgCache.put(this.isSelected, msg);
        this.change();
    }

    private final void change() {
        this.isSelected = !this.isSelected;
        String string2 = this.getEditHintContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getEditHintContent()");
        BarrageConfigData barrageConfigData = this.barrageConfigData;
        this.callback.onBarrageShow(this.isSelected, this.msgCache.get(this.isSelected), string2, this.maxTextLength, barrageConfigData != null ? barrageConfigData.isNobelCardGuide() : false);
    }

    public final boolean onSendClick(@Nullable String msg) {
        if (this.isSelected && msg != null && this.isBarrageLimit()) {
            this.callback.sendMsg(msg);
        }
        this.msgCache.put(this.isSelected, "");
        return this.isSelected;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isBarrageLimit() {
        BarrageConfigData barrageConfigData = this.barrageConfigData;
        if (barrageConfigData != null) {
            if (barrageConfigData.isNobelCardGuide()) {
                if (CommonExtensionsKt.isNotNullOrEmpty((String)this.nobelCardGuideJumpUrl)) {
                    IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                    if (iServiceManager != null && (iServiceManager = (IYYUriService)iServiceManager.getService(IYYUriService.class)) != null) {
                        iServiceManager.handleUriString(this.nobelCardGuideJumpUrl);
                    }
                    this.callback.dismissInputDialog();
                    return false;
                }
            }
        }
        BarrageConfigData barrageConfigData2 = this.barrageConfigData;
        if (barrageConfigData2 == null || !barrageConfigData2.getHas()) {
            Object object = this.barrageConfigData;
            if (object != null && (object = object.getPopUrl()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object object3 = object2;
                boolean bl3 = false;
                IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
                if (iServiceManager != null && (iServiceManager = (IYYUriService)iServiceManager.getService(IYYUriService.class)) != null) {
                    iServiceManager.handleUriString((String)object3);
                }
            }
            this.callback.dismissInputDialog();
            return false;
        }
        BarrageConfigData barrageConfigData3 = this.barrageConfigData;
        if ((barrageConfigData3 != null ? barrageConfigData3.getRemainCnt() : 0) > 0) {
            return true;
        }
        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.short_tips_barrage_edit_hint, (Object[])new Object[]{0}), (int)0);
        return false;
    }

    private final String getEditHintContent() {
        Object[] objectArray = new Object[1];
        BarrageConfigData barrageConfigData = this.barrageConfigData;
        objectArray[0] = barrageConfigData != null ? Integer.valueOf(barrageConfigData.getRemainCnt()) : null;
        return ResourceUtils.getString((int)(!this.isSelected ? R.string.tips_input_hint : R.string.short_tips_barrage_edit_hint), (Object[])objectArray);
    }

    public BarrageHandler(@NotNull BarrageHandlerCallback callback2) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)callback2, (String)"callback");
        this.callback = callback2;
        BarrageHandler barrageHandler = this;
        boolean bl = false;
        barrageHandler.msgCache = map = (Map)new LinkedHashMap();
        this.maxTextLength = 30;
        this.nobelCardGuideJumpUrl = "";
        this.observer = (Observer)new Observer<BarrageConfigData>(this){
            final /* synthetic */ BarrageHandler this$0;

            public final void onChanged(BarrageConfigData it) {
                BarrageHandler.access$setBarrageConfigData$p(this.this$0, it);
                if ((it.getRemainCnt() <= 0 || !it.getHas()) && BarrageHandler.access$isSelected$p(this.this$0)) {
                    BarrageHandler.access$change(this.this$0);
                }
            }
            {
                this.this$0 = barrageHandler;
            }
        };
    }

    public static final /* synthetic */ BarrageConfigData access$getBarrageConfigData$p(BarrageHandler $this) {
        return $this.barrageConfigData;
    }

    public static final /* synthetic */ void access$setBarrageConfigData$p(BarrageHandler $this, BarrageConfigData barrageConfigData) {
        $this.barrageConfigData = barrageConfigData;
    }

    public static final /* synthetic */ boolean access$isSelected$p(BarrageHandler $this) {
        return $this.isSelected;
    }

    public static final /* synthetic */ void access$setSelected$p(BarrageHandler $this, boolean bl) {
        $this.isSelected = bl;
    }

    public static final /* synthetic */ void access$change(BarrageHandler $this) {
        $this.change();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J2\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH&J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000bH&\u00a8\u0006\u0012"}, d2={"Lcom/yy/hiyo/channel/component/barrage/BarrageHandler$BarrageHandlerCallback;", "", "dismissInputDialog", "", "getBarrageService", "Lcom/yy/hiyo/channel/base/service/IChannelBarrageService;", "onBarrageHide", "onBarrageShow", "isSelected", "", "editMsg", "", "editHintContent", "maxTextLength", "", "nobelCardGuide", "sendMsg", "msg", "channel-components_release"})
    public static interface BarrageHandlerCallback {
        public void onBarrageShow(boolean var1, @Nullable String var2, @NotNull String var3, int var4, boolean var5);

        public void onBarrageHide();

        public void sendMsg(@NotNull String var1);

        @Nullable
        public IChannelBarrageService getBarrageService();

        public void dismissInputDialog();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/channel/component/barrage/BarrageHandler$Companion;", "", "()V", "TAG", "", "channel-components_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

