/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.announcement;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.VoiceRoomBillboardTipConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.R;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.SeatUser;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IDataService;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.channelhiido.RoomTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.utils.ChannelUtils;
import com.yy.hiyo.channel.component.announcement.ui.NoticeDialog;
import com.yy.hiyo.channel.component.announcement.ui.NoticeView;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import com.yy.hiyo.mvp.base.callback.IDestroyable;
import com.yy.hiyo.mvp.base.callback.WeakRunnable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NoticePresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IHolderPresenter {
    private static final String TAG = "NoticePresenter";
    private static Pattern noticePattern = Pattern.compile("\n{3,}");
    @Nullable
    protected NoticeView mNoticeView;
    private static final int CODE_SUCCESS = 0;
    private String mChannelId;
    private String mNotice;
    private DialogLinkManager mDialogLinkManager;
    private NoticeDialog mNoticeDialog;

    public void setNotice(String mNotice) {
        MLog.info((Object)TAG, (String)"mChannelId Id: %s  setNotice value: %s", (Object[])new Object[]{this.mChannelId, mNotice});
        this.mNotice = mNotice;
    }

    public String getNotice() {
        return this.mNotice;
    }

    private DialogLinkManager getDialogLinkManager() {
        if (this.mDialogLinkManager == null) {
            this.mDialogLinkManager = new DialogLinkManager((Context)((IChannelPageContext)this.getMvpContext()).getContext());
        }
        return this.mDialogLinkManager;
    }

    public void onInit(IChannelPageContext<AbsPage> mvpContext) {
        IRoleService roleService;
        int role;
        VoiceRoomBillboardTipConfig billboardTipConfig;
        int mode;
        super.onInit(mvpContext);
        if (this.getChannel() == null || FP.empty((CharSequence)this.getChannel().getChannelId())) {
            MLog.info((Object)TAG, (String)"onInit group data is empty!!!!!!", (Object[])new Object[0]);
            return;
        }
        this.mChannelId = this.getChannel().getChannelId();
        this.setNotice(this.getChannelDetailInfo().baseInfo.announcement);
        IAB billboardAB = NewABDefine.SHOW_GUIDE.getTest();
        MLog.info((Object)TAG, (String)("billboard ab " + billboardAB), (Object[])new Object[0]);
        if (NAB.A.equals((Object)NewABDefine.SHOW_GUIDE.getTest()) && ((mode = this.getChannel().getPluginService().getCurPluginData().mode) == 10 || mode == 11 || mode == 12 || mode == 13 || mode == 14 && !this.getChannel().getPluginService().getCurPluginData().isVideoMode()) && (billboardTipConfig = (VoiceRoomBillboardTipConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.VOICE_ROOM_BILLBOARD_TIP)) != null && billboardTipConfig.isOpen() && (role = (roleService = this.getChannel().getRoleService()).getRoleCache(AccountUtil.getUid())) < 5) {
            String billboard;
            List seatUserList = this.getChannel().getSeatService().getHasUserSeatList();
            long ownerId = 0L;
            for (SeatUser seatUser : seatUserList) {
                if (roleService.getRoleCache(seatUser.uid) != 15) continue;
                ownerId = seatUser.uid;
                break;
            }
            if (ownerId != 0L && !TextUtils.isEmpty((CharSequence)(billboard = this.getChannel().getChannelDetail().baseInfo.announcement))) {
                long finalOwnerId = ownerId;
                YYTaskExecutor.postToMainThread((Runnable)WeakRunnable.of((IDestroyable)this, () -> {
                    BaseImMsg billboardMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalBillboardMsg(billboard, this.getChannelId(), 15, finalOwnerId);
                    billboardMsg.setMsgState(1);
                    ((IPublicScreenModulePresenter)this.getPresenter(IPublicScreenModulePresenter.class)).getPublicScreenPresenter().appendLocalMsg(billboardMsg);
                    ChannelTrack.INSTANCE.publicScreenRoomBulletinPrompt(AccountUtil.getUid(), finalOwnerId, this.mChannelId);
                }), (long)3000L);
            }
        }
    }

    public void setContainer(@NonNull View container) {
        if (container instanceof YYPlaceHolderView) {
            this.mNoticeView = new NoticeView(container.getContext());
            ((YYPlaceHolderView)container).inflate((View)this.mNoticeView);
        } else if (this.mNoticeView == null && container instanceof NoticeView) {
            ChannelUtils.checkReuseViewType(container.getClass());
            this.mNoticeView = (NoticeView)container;
        }
        this.mNoticeView.setClickListener(v -> this.handlerNoticeClick());
        ConstraintLayout.LayoutParams cl = (ConstraintLayout.LayoutParams)this.mNoticeView.getLayoutParams();
        cl.setMarginEnd(ResolutionUtils.dip2Px((float)10.0f));
        this.updateNoticeView();
    }

    protected void handlerNoticeClick() {
        RoomTrack.INSTANCE.clickNoticeEntry(this.mChannelId, this.isRoomOwner() ? 1 : 2);
        this.showNoticeDialog();
    }

    public void showNoticeDialog() {
        if (((IChannelPageContext)this.getMvpContext()).getContext() != null) {
            if (this.mNoticeDialog == null) {
                this.mNoticeDialog = new NoticeDialog((Context)((IChannelPageContext)this.getMvpContext()).getContext(), this);
            }
            this.mNoticeDialog.show();
        }
    }

    protected void updateNoticeView() {
        boolean isRoomOwnerOrAnchor = this.isRoomOwnerOrAnchor();
        MLog.info((Object)TAG, (String)"updateNoticeView isRoomOwnerOrAnchor: %s", (Object[])new Object[]{isRoomOwnerOrAnchor});
        if (this.mNoticeView != null) {
            this.mNoticeView.updateNoticeView(isRoomOwnerOrAnchor, this.mNotice);
        }
    }

    private boolean isRoomOwner() {
        if (this.getChannelDetailInfo().baseInfo == null || this.getChannelDetailInfo().baseInfo.ownerUid <= 0L) {
            return false;
        }
        return this.getChannelDetailInfo().baseInfo.ownerUid == AccountUtil.getUid();
    }

    public boolean isRoomOwnerOrAnchor() {
        if (this.getChannel().getRoleService().isMeAnchor()) {
            return true;
        }
        return this.isRoomOwner();
    }

    public NoticeView getNoticeView() {
        return this.mNoticeView;
    }

    public void saveNotice(String content, boolean withPush) {
        RoomTrack.INSTANCE.clickSaveNotice(this.mChannelId, withPush);
        if (content == null) {
            content = "";
        }
        if (StringUtils.equal((String)content, (String)this.mNotice)) {
            MLog.info((Object)TAG, (String)"save notice content not change!!", (Object[])new Object[0]);
            this.closeNoticeDialog();
            return;
        }
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_save_notice_not_network, (int)0);
            RoomTrack.INSTANCE.saveNoticeFailed(this.mChannelId, "Network unavailable");
            MLog.info((Object)TAG, (String)"save notice network error!!!", (Object[])new Object[0]);
            return;
        }
        final String notice = this.filterSeriesNewLineChar(content);
        MLog.info((Object)TAG, (String)"saveNotice notice: %s", (Object[])new Object[]{notice});
        ProgressDialog dialog2 = new ProgressDialog();
        this.getDialogLinkManager().showDialog((BaseDialog)dialog2);
        this.getChannel().getDataService().updateannouncement(notice, withPush, new IDataService.IUpdateInfoCallBack(){

            public void onSuccess(IChannel group) {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
                RoomTrack.INSTANCE.saveNoticeSuccess(NoticePresenter.this.mChannelId);
                NoticePresenter.this.setNotice(notice);
                NoticePresenter.this.closeNoticeDialog();
            }

            public void onContainSensitiveWord() {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_modify_failed), (int)0);
            }

            public void onFailUnauthorized() {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tips_channel_no_permission, (int)0);
            }

            public void updateLimit(String toast) {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
                ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)toast, (int)0);
            }

            public void limitNoToast() {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
            }

            public void onError(String channelId, int errorCode, String errorTips, Exception e) {
                NoticePresenter.this.getDialogLinkManager().dismissDialog();
                String errorMsg = "response code: " + errorCode;
                if (errorCode == 1006) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_save_notice_contains_sensitive, (int)0);
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (int)R.string.tip_save_notice_failed, (int)0);
                }
                RoomTrack.INSTANCE.saveNoticeFailed(NoticePresenter.this.mChannelId, errorMsg);
            }
        });
    }

    public void onDataUpdate(String channelId, ChannelDetailInfo info) {
        if (StringUtils.equal((String)channelId, (String)this.mChannelId) && info != null) {
            this.handlerNoticeNotify(info.baseInfo.announcement);
        }
    }

    private void handlerNoticeNotify(String newNotice) {
        MLog.info((Object)TAG, (String)"handlerNoticeNotify notice: %s", (Object[])new Object[]{newNotice});
        this.setNotice(newNotice);
        this.updateNoticeView();
    }

    private String filterSeriesNewLineChar(String notice) {
        Matcher m = noticePattern.matcher(notice);
        return m.replaceAll("\n\n");
    }

    private void closeNoticeDialog() {
        if (this.mNoticeDialog != null) {
            this.mNoticeDialog.dismiss();
        }
    }

    public void onPageDetach(AbsPage page) {
        super.onPageDetach(page);
        this.closeNoticeDialog();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.isPageSupportReuse() && this.mNoticeView != null) {
            this.mNoticeView.resetViewState();
        }
        this.mNoticeView = null;
    }
}

