/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.component.act.rightbanner.ui;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.component.act.rightbanner.viewmanager.BaseViewManager;
import com.yy.hiyo.wallet.base.action.ActivityAction;
import com.yy.hiyo.wallet.base.action.RoomActivityAction;

public abstract class BaseRoomActivityView
extends YYFrameLayout {
    private BaseViewManager.OnActivityActionClickListener mListener;

    public BaseRoomActivityView(Context context) {
        super(context);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BaseRoomActivityView.this.mListener != null) {
                    BaseRoomActivityView.this.mListener.onActivityActionClick((ActivityAction)BaseRoomActivityView.this.getData());
                }
            }
        });
    }

    public abstract void setData(RoomActivityAction var1);

    public abstract RoomActivityAction getData();

    public abstract View getView();

    public void setListener(BaseViewManager.OnActivityActionClickListener listener2) {
        this.mListener = listener2;
    }

    public void updateSize() {
        this.requestLayout();
        this.post(new Runnable(){

            @Override
            public void run() {
                BaseRoomActivityView.this.setViewSize(BaseRoomActivityView.this.getView(), BaseRoomActivityView.this.getData());
            }
        });
    }

    protected void setViewSize(final View view, final RoomActivityAction roomActivityAction) {
        if (roomActivityAction == null || view == null) {
            return;
        }
        if (this.getMeasuredWidth() <= 0 || this.getMeasuredHeight() <= 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BaseRoomActivityView.this.setViewSizePost(view, roomActivityAction);
                }
            });
        } else {
            this.setViewSizePost(view, roomActivityAction);
        }
    }

    protected void setViewSizePost(View view, RoomActivityAction roomActivityAction) {
        FrameLayout.LayoutParams lp = null;
        int width = ResolutionUtils.dip2Px((float)(roomActivityAction.width / 2));
        int height = ResolutionUtils.dip2Px((float)(roomActivityAction.height / 2));
        int gravity = 81;
        lp = (FrameLayout.LayoutParams)view.getLayoutParams();
        int measureWidth = this.getMeasuredWidth();
        int measureHeight = this.getMeasuredHeight();
        if (measureWidth > 0 && width > measureWidth) {
            width = measureWidth;
        }
        if (measureHeight > 0 && height > measureHeight) {
            height = measureHeight;
        }
        lp.width = width;
        lp.height = height;
        lp.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
    }
}

